## RabbitMQ 4.1.2

RabbitMQ `4.1.2` is a maintenance release in the `4.1.x` [release series](https://www.rabbitmq.com/release-information).

It is **strongly recommended** that you read [4.1.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.1.0)
in detail if upgrading from a version prior to `4.1.0`.


### Minimum Supported Erlang Version

[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.1.x/release-notes).


### Core Server

#### Bug Fixes

 * Channels that had consumers that consumed from quorum queues could leak file handles
   when those queues were deleted.

   GitHub issue: [#14177](https://github.com/rabbitmq/rabbitmq-server/issues/14177), [#14138](https://github.com/rabbitmq/rabbitmq-server/pull/14138)

 * Classic queues now retry opening files when flushing buffers to significantly reduce the probability of running into
   `eacces` file system operation errors from the Windows kernel.

   GitHub issue: [#14131](https://github.com/rabbitmq/rabbitmq-server/pull/14131)

 * A higher priority quorum queue SAC consumer was never activated when a quiescing consumer
   returned or requeued its last outstanding delivery.

   GitHub issue: [#14149](https://github.com/rabbitmq/rabbitmq-server/pull/14149)

#### Enhancements

 * An opt-in setting that makes a node refuse to boot if there's evidence that the node might have been reset
   in the past.

   GitHub issue: [#14125](https://github.com/rabbitmq/rabbitmq-server/pull/14125)

 * Minor memory footprint optimizations.

   GitHub issues: [#14089](https://github.com/rabbitmq/rabbitmq-server/pull/14089), [#14065](https://github.com/rabbitmq/rabbitmq-server/pull/14065), [#14058](https://github.com/rabbitmq/rabbitmq-server/pull/14058)


### Stream Plugin

#### Bug Fixes

 * Multiple stream and stream SAC (Single Active Consumer) coordinator resilience improvements.

   GitHub issues: [#14107](https://github.com/rabbitmq/rabbitmq-server/pull/14107), [#14085](https://github.com/rabbitmq/rabbitmq-server/pull/14085), [#14070](https://github.com/rabbitmq/rabbitmq-server/issues/14070)

 * Consumer on a stream that was deleted could leak a file descriptor.

   GitHub issue: [#14143](https://github.com/rabbitmq/rabbitmq-server/pull/14143)

 * When a stream member (replica) failed, consumer cleanup could affect consumers connected to different nodes.

   GitHub issue: [#13961](https://github.com/rabbitmq/rabbitmq-server/issues/13961)

 * Unhandled stream coordinator exceptions now close stream connections, giving clients a chance to reconnect and reset stream state.

   GitHub issue: [#14040](https://github.com/rabbitmq/rabbitmq-server/issues/14040)

 * A closing connection could log a scary looking harmless exception.

   GitHub issue: [#14128](https://github.com/rabbitmq/rabbitmq-server/pull/14128)


### CLI Tools

#### Enhancements

 * `rabbitmq-streams activate_stream_consumer` is a new CLI command that forcefully activates a specific consumer in a SAC (Single Active Consumer) group:

   ```shell
   rabbitmq-streams activate_stream_consumer --stream [stream name] --reference [reference]
   ```

   This is an emergency operations command that won't be necessary most of the time.

   GitHub issue: [#14055](https://github.com/rabbitmq/rabbitmq-server/issues/14055)

#### Bug Fixes

 * `rabbitmq-streams coordinator_status` command reported an incorrect Raft machine version.

   GitHub issue: [#14112](https://github.com/rabbitmq/rabbitmq-server/pull/14112)

 * `rabbitmq-diagnostics environment` now correctly transforms its output
   when `--formatter=json` is used.

   GitHub issue: [#14118](https://github.com/rabbitmq/rabbitmq-server/pull/14118)


### Management Plugin

#### Bug Fixes

 * Eliminated a JavaScript exception that could affect those upgrading from `3.13.x` to `4.x` versions.

   GitHub issue: [#13973](https://github.com/rabbitmq/rabbitmq-server/issues/13973)

 * Virtual host restart form now sanitizes virtual host name.


### Dependency Changes

 * `ra` was upgraded to [`2.16.11`](https://github.com/rabbitmq/ra/releases)
 * `redbug` was upgraded to `2.1.0`


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-4.1.2.tar.xz`
instead of the source tarball produced by GitHub.
