/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.jupyter.core.core.api.NotebookDisposable;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.extensions.JupyterPsiCellExt;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterDebugSessionManager;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterSessionPath;
import com.intellij.jupyter.py.debugger.JupyterCellSourcePosition;
import com.intellij.jupyter.py.debugger.JupyterPositionConverter;
import com.intellij.jupyter.py.debugger.remote.JupyterCellDebugProcess;
import com.intellij.jupyter.py.debugger.remote.JupyterRemoteDebugContext;
import com.intellij.jupyter.py.debugger.remote.JupyterRemoteDebugLog;
import com.intellij.jupyter.py.debugger.remote.JupyterRemoteDebuggerAdapter;
import com.intellij.jupyter.py.debugger.remote.JupyterRemotePyDebugValue;
import com.intellij.jupyter.py.debugger.remote.JupyterRemotePyLineBreakpointHandler;
import com.intellij.jupyter.py.debugger.remote.JupyterRemotePyStackFrame;
import com.intellij.jupyter.py.debugger.remote.StopReason;
import com.intellij.jupyter.py.editor.JupyterFileUtilKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.ArrayChunkBuilder;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyThreadInfo;
import com.jetbrains.python.tables.TableCommandParameters;
import com.jetbrains.python.tables.TableCommandType;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u00101\u001a\u00020\u001cH\u0016J\u0013\u00102\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020\u000eH\u0016J\b\u00105\u001a\u000206H\u0016J\r\u00107\u001a\u000708\u00a2\u0006\u0002\b9H\u0016J \u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\"2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>H\u0016J\u0014\u0010@\u001a\u0004\u0018\u00010A2\b\u0010B\u001a\u0004\u0018\u00010CH\u0016J\u0014\u0010D\u001a\u0004\u0018\u00010A2\b\u0010E\u001a\u0004\u0018\u00010;H\u0016J\u0018\u0010F\u001a\u0002062\u0006\u0010G\u001a\u00020;2\u0006\u0010<\u001a\u00020\"H\u0016J\n\u0010H\u001a\u0004\u0018\u00010IH\u0016J<\u0010J\u001a\u00020K2\b\u0010E\u001a\u0004\u0018\u00010;2\u0006\u0010L\u001a\u00020\u001f2\u0006\u0010M\u001a\u00020\u001f2\u0006\u0010N\u001a\u00020\u001f2\u0006\u0010O\u001a\u00020\u001f2\b\u0010P\u001a\u0004\u0018\u00010\"H\u0016J\u001e\u0010Q\u001a\u0004\u0018\u00010I2\b\u0010R\u001a\u0004\u0018\u00010\"2\b\u0010S\u001a\u0004\u0018\u00010\"H\u0016J\u0014\u0010T\u001a\u0004\u0018\u00010I2\b\u0010U\u001a\u0004\u0018\u00010\"H\u0016J(\u0010V\u001a\u0004\u0018\u00010I2\b\u0010W\u001a\u0004\u0018\u00010\"2\b\u0010X\u001a\u0004\u0018\u00010Y2\b\u0010Z\u001a\u0004\u0018\u00010[H\u0016J(\u0010\\\u001a\u0004\u0018\u00010I2\b\u0010W\u001a\u0004\u0018\u00010\"2\b\u0010X\u001a\u0004\u0018\u00010Y2\b\u0010Z\u001a\u0004\u0018\u00010[H\u0016J\u0012\u0010]\u001a\u0002062\b\b\u0001\u0010^\u001a\u00020\"H\u0002J\u001f\u0010_\u001a\u0002062\u0010\u0010`\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030a0 H\u0000\u00a2\u0006\u0002\bbJ\u001f\u0010c\u001a\u0002062\u0010\u0010`\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030a0 H\u0000\u00a2\u0006\u0002\bdJ\u000e\u0010i\u001a\b\u0012\u0004\u0012\u00020k0jH\u0016J\u0018\u0010l\u001a\u0002062\u0006\u0010m\u001a\u00020k2\u0006\u0010n\u001a\u00020>H\u0016J\u0010\u0010o\u001a\u00020p2\u0006\u0010m\u001a\u00020kH\u0002J\u0012\u0010q\u001a\u0002062\b\u0010r\u001a\u0004\u0018\u00010pH\u0016J\u0012\u0010s\u001a\u0002062\b\u0010r\u001a\u0004\u0018\u00010pH\u0016J\u0012\u0010t\u001a\u0002062\b\u0010r\u001a\u0004\u0018\u00010pH\u0016J\u0012\u0010u\u001a\u0002062\b\u0010r\u001a\u0004\u0018\u00010pH\u0016J\u0012\u0010v\u001a\u0002062\b\u0010r\u001a\u0004\u0018\u00010pH\u0016J\u001a\u0010w\u001a\u0002062\u0006\u0010x\u001a\u00020y2\b\u0010r\u001a\u0004\u0018\u00010pH\u0016J\b\u0010z\u001a\u000206H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001e\u0010e\u001a\u0004\u0018\u00010f*\u0006\u0012\u0002\b\u00030 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bg\u0010h\u00a8\u0006{"}, d2={"Lcom/intellij/jupyter/py/debugger/remote/JupyterRemoteDebugProcess;", "Lcom/intellij/jupyter/py/debugger/remote/JupyterCellDebugProcess;", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "Lkotlinx/coroutines/CoroutineScope;", "debugSession", "Lcom/intellij/xdebugger/XDebugSession;", "notebookSessionSupplier", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "cell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "executionConsole", "Lcom/intellij/execution/ui/ConsoleView;", "<init>", "(Lcom/intellij/xdebugger/XDebugSession;Ljava/util/concurrent/CompletableFuture;Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Lcom/intellij/execution/ui/ConsoleView;)V", "getCell", "()Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "getCellPointer", "()Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "debuggerAdapter", "Lcom/intellij/jupyter/py/debugger/remote/JupyterRemoteDebuggerAdapter;", "breakpointHandlers", "", "Lcom/intellij/jupyter/py/debugger/remote/JupyterRemotePyLineBreakpointHandler;", "[Lcom/intellij/jupyter/py/debugger/remote/JupyterRemotePyLineBreakpointHandler;", "editorsProvider", "Lcom/jetbrains/python/debugger/PyDebuggerEditorsProvider;", "registeredBreakpoints", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "cellCode", "", "getCellCode", "()Ljava/lang/String;", "cellVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCellVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "cellPosition", "Lcom/intellij/jupyter/py/debugger/JupyterCellSourcePosition;", "getCellPosition", "()Lcom/intellij/jupyter/py/debugger/JupyterCellSourcePosition;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getEditorsProvider", "getBreakpointHandlers", "()[Lcom/intellij/jupyter/py/debugger/remote/JupyterRemotePyLineBreakpointHandler;", "createConsole", "sessionInitialized", "", "getProject", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "evaluate", "Lcom/jetbrains/python/debugger/PyDebugValue;", "expression", "execute", "", "doTrunc", "loadFrame", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "frame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "loadVariable", "var", "changeVariable", "variable", "getReferrersLoader", "", "getArrayItems", "Lcom/jetbrains/python/debugger/ArrayChunk;", "rowOffset", "colOffset", "rows", "cols", "format", "getSourcePositionForName", "name", "parentType", "getSourcePositionForType", "type", "execTableCommand", "command", "commandType", "Lcom/jetbrains/python/tables/TableCommandType;", "tableCommandParameters", "Lcom/jetbrains/python/tables/TableCommandParameters;", "execTableImageCommand", "printToConsole", "text", "registerBreakpoint", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpointProperties;", "registerBreakpoint$intellij_jupyter_py", "unregisterBreakpoint", "unregisterBreakpoint$intellij_jupyter_py", "pySourcePosition", "Lcom/jetbrains/python/debugger/PySourcePosition;", "getPySourcePosition", "(Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;)Lcom/jetbrains/python/debugger/PySourcePosition;", "getThreads", "", "Lcom/jetbrains/python/debugger/PyThreadInfo;", "threadSuspended", "threadInfo", "updateSourcePosition", "createSuspendContext", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "resume", "context", "startStepOver", "startStepInto", "startForceStepInto", "startStepOut", "runToPosition", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "stop", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterRemoteDebugProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteDebugProcess.kt\ncom/intellij/jupyter/py/debugger/remote/JupyterRemoteDebugProcess\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,240:1\n1104#2,3:241\n*S KotlinDebug\n*F\n+ 1 JupyterRemoteDebugProcess.kt\ncom/intellij/jupyter/py/debugger/remote/JupyterRemoteDebugProcess\n*L\n150#1:241,3\n*E\n"})
public final class JupyterRemoteDebugProcess
extends JupyterCellDebugProcess
implements PyFrameAccessor,
CoroutineScope {
    @NotNull
    private final JupyterPsiCell cell;
    @NotNull
    private final NotebookIntervalPointer cellPointer;
    @NotNull
    private final ConsoleView executionConsole;
    @NotNull
    private final JupyterRemoteDebuggerAdapter debuggerAdapter;
    @NotNull
    private final JupyterRemotePyLineBreakpointHandler[] breakpointHandlers;
    @NotNull
    private final PyDebuggerEditorsProvider editorsProvider;
    @NotNull
    private final ConcurrentHashMap<Integer, XLineBreakpoint<?>> registeredBreakpoints;
    @NotNull
    private final String cellCode;
    @NotNull
    private final VirtualFile cellVirtualFile;
    @NotNull
    private final JupyterCellSourcePosition cellPosition;
    @NotNull
    private final CoroutineContext coroutineContext;

    public JupyterRemoteDebugProcess(@NotNull XDebugSession debugSession, @NotNull CompletableFuture<JupyterNotebookSession> notebookSessionSupplier, @NotNull JupyterPsiCell cell, @NotNull NotebookIntervalPointer cellPointer, @NotNull ConsoleView executionConsole) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)debugSession, (String)"debugSession");
        Intrinsics.checkNotNullParameter(notebookSessionSupplier, (String)"notebookSessionSupplier");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)executionConsole, (String)"executionConsole");
        super(debugSession);
        this.cell = cell;
        this.cellPointer = cellPointer;
        this.executionConsole = executionConsole;
        this.debuggerAdapter = new JupyterRemoteDebuggerAdapter(this, notebookSessionSupplier);
        JupyterRemotePyLineBreakpointHandler[] jupyterRemotePyLineBreakpointHandlerArray = new JupyterRemotePyLineBreakpointHandler[]{new JupyterRemotePyLineBreakpointHandler(this)};
        this.breakpointHandlers = jupyterRemotePyLineBreakpointHandlerArray;
        this.editorsProvider = new PyDebuggerEditorsProvider();
        this.registeredBreakpoints = this.debuggerAdapter.getRegisteredBreakpoints$intellij_jupyter_py();
        String string = this.getCell().getSource().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.cellCode = string;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterPsiCellExt.INSTANCE.getJupyterBackedVirtualFile(this.getCell());
        if (backedNotebookVirtualFile == null || (backedNotebookVirtualFile = backedNotebookVirtualFile.getOriginFile()) == null) {
            JupyterRemoteDebugProcess jupyterRemoteDebugProcess = this;
            boolean bl = false;
            debugSession.reportError(JupyterBundle.message((String)"Jupyter.debugger.failed.to.start", (Object[])new Object[0]));
            throw new IllegalStateException("Cell virtual file is 'null'.");
        }
        this.cellVirtualFile = backedNotebookVirtualFile;
        JupyterCellSourcePosition jupyterCellSourcePosition = JupyterFileUtilKt.getCellPositionForJupyterCell(this.getCellVirtualFile(), this.getCell());
        if (jupyterCellSourcePosition == null) {
            JupyterRemoteDebugProcess jupyterRemoteDebugProcess = this;
            boolean bl = false;
            debugSession.reportError(JupyterBundle.message((String)"Jupyter.debugger.failed.to.start", (Object[])new Object[0]));
            throw new IllegalStateException("Cell position is 'null'.");
        }
        this.cellPosition = jupyterCellSourcePosition;
        this.coroutineContext = NotebookDisposable.Companion.forProject(this.getProject()).getCoroutineContext().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null));
        this.getSession().setPauseActionSupported(false);
    }

    @Override
    @NotNull
    public JupyterPsiCell getCell() {
        return this.cell;
    }

    @Override
    @NotNull
    public NotebookIntervalPointer getCellPointer() {
        return this.cellPointer;
    }

    @Override
    @NotNull
    public String getCellCode() {
        return this.cellCode;
    }

    @Override
    @NotNull
    public VirtualFile getCellVirtualFile() {
        return this.cellVirtualFile;
    }

    @Override
    @NotNull
    public JupyterCellSourcePosition getCellPosition() {
        return this.cellPosition;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @NotNull
    public PyDebuggerEditorsProvider getEditorsProvider() {
        return this.editorsProvider;
    }

    @NotNull
    public JupyterRemotePyLineBreakpointHandler[] getBreakpointHandlers() {
        return this.breakpointHandlers;
    }

    @NotNull
    public ConsoleView createConsole() {
        return this.executionConsole;
    }

    public void sessionInitialized() {
        this.debuggerAdapter.initialRun();
    }

    @NotNull
    public Project getProject() {
        Project project = this.getSession().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    @NotNull
    public PyDebugValue evaluate(@NotNull String expression, boolean execute, boolean doTrunc) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        XStackFrame currentFrame = this.getSession().getCurrentStackFrame();
        Intrinsics.checkNotNull((Object)currentFrame, (String)"null cannot be cast to non-null type com.jetbrains.python.debugger.PyStackFrame");
        String frameId = ((PyStackFrame)currentFrame).getFrameId();
        Intrinsics.checkNotNull((Object)frameId);
        return this.debuggerAdapter.evaluate(expression, Integer.parseInt(frameId));
    }

    @Nullable
    public XValueChildrenList loadFrame(@Nullable XStackFrame frame) {
        if (!(frame instanceof PyStackFrame)) {
            return null;
        }
        String string = ((PyStackFrame)frame).getFrameId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFrameId(...)");
        return this.debuggerAdapter.loadFrame(Integer.parseInt(string));
    }

    @Nullable
    public XValueChildrenList loadVariable(@Nullable PyDebugValue var) {
        if (var == null) {
            return null;
        }
        return this.debuggerAdapter.loadVariable(var);
    }

    public void changeVariable(@NotNull PyDebugValue variable, @NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (!(variable instanceof JupyterRemotePyDebugValue)) {
            return;
        }
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        if (!(frame instanceof JupyterRemotePyStackFrame)) {
            return;
        }
        this.debuggerAdapter.setVariable((JupyterRemotePyDebugValue)variable, expression);
    }

    @Nullable
    public Void getReferrersLoader() {
        return null;
    }

    @NotNull
    public ArrayChunk getArrayItems(@Nullable PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, @Nullable String format) {
        ArrayChunk arrayChunk = new ArrayChunkBuilder().createArrayChunk();
        Intrinsics.checkNotNullExpressionValue((Object)arrayChunk, (String)"createArrayChunk(...)");
        return arrayChunk;
    }

    @Nullable
    public Void getSourcePositionForName(@Nullable String name, @Nullable String parentType) {
        return null;
    }

    @Nullable
    public Void getSourcePositionForType(@Nullable String type) {
        return null;
    }

    @Nullable
    public Void execTableCommand(@Nullable String command, @Nullable TableCommandType commandType, @Nullable TableCommandParameters tableCommandParameters) {
        return null;
    }

    @Nullable
    public Void execTableImageCommand(@Nullable String command, @Nullable TableCommandType commandType, @Nullable TableCommandParameters tableCommandParameters) {
        return null;
    }

    private final void printToConsole(@Nls String text) {
        this.executionConsole.print(text, ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    public final void registerBreakpoint$intellij_jupyter_py(@NotNull XLineBreakpoint<XBreakpointProperties<?>> breakpoint) {
        block0: {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            PySourcePosition pySourcePosition = this.getPySourcePosition(breakpoint);
            if (pySourcePosition == null) break block0;
            PySourcePosition it = pySourcePosition;
            boolean bl = false;
            ((Map)this.registeredBreakpoints).put(it.getLine(), breakpoint);
            this.debuggerAdapter.synchronizeBreakpoints();
        }
    }

    public final void unregisterBreakpoint$intellij_jupyter_py(@NotNull XLineBreakpoint<XBreakpointProperties<?>> breakpoint) {
        block0: {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            PySourcePosition pySourcePosition = this.getPySourcePosition(breakpoint);
            if (pySourcePosition == null) break block0;
            PySourcePosition it = pySourcePosition;
            boolean bl = false;
            this.registeredBreakpoints.remove(it.getLine());
            this.debuggerAdapter.synchronizeBreakpoints();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final PySourcePosition getPySourcePosition(XLineBreakpoint<?> $this$pySourcePosition) {
        PySourcePosition pySourcePosition;
        XSourcePosition xSourcePosition = $this$pySourcePosition.getSourcePosition();
        if (xSourcePosition != null) {
            XSourcePosition position = xSourcePosition;
            boolean bl = false;
            BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterPsiCellExt.INSTANCE.getJupyterBackedVirtualFile(this.getCell());
            if (Intrinsics.areEqual((Object)position.getFile(), (Object)(backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getFile() : null)) && position.getFile().isValid()) {
                void $this$count$iv;
                int n = this.getCellPosition().getStart().getLine();
                int n2 = this.getCellPosition().getStart().getLine();
                String string = this.getCell().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                CharSequence charSequence = string;
                int n3 = n2;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(i);
                    boolean bl2 = false;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                int n4 = count$iv;
                int n5 = n3 + n4;
                int n6 = $this$pySourcePosition.getLine();
                pySourcePosition = (n <= n6 ? n6 <= n5 : false) ? new JupyterPositionConverter(this.getProject()).convertToPython(position) : null;
            } else {
                pySourcePosition = null;
            }
        } else {
            pySourcePosition = null;
        }
        return pySourcePosition;
    }

    @Override
    @NotNull
    public Collection<PyThreadInfo> getThreads() {
        return this.debuggerAdapter.getThreads();
    }

    @Override
    public void threadSuspended(@NotNull PyThreadInfo threadInfo, boolean updateSourcePosition) {
        Intrinsics.checkNotNullParameter((Object)threadInfo, (String)"threadInfo");
        XSuspendContext suspendContext = this.createSuspendContext(threadInfo);
        XExecutionStack xExecutionStack = suspendContext.getActiveExecutionStack();
        if (xExecutionStack == null || (xExecutionStack = xExecutionStack.getTopFrame()) == null) {
            return;
        }
        XExecutionStack topFrame = xExecutionStack;
        if (threadInfo.getStopReason() == StopReason.BREAKPOINT.ordinal()) {
            XLineBreakpoint breakpoint;
            XSourcePosition xSourcePosition = topFrame.getSourcePosition();
            if (xSourcePosition != null) {
                int line = xSourcePosition.getLine();
                boolean bl = false;
                v2 = ((Map)this.registeredBreakpoints).getOrDefault(line - this.getCellPosition().getStart().getLine(), null);
            } else {
                v2 = breakpoint = null;
            }
            if (breakpoint != null) {
                this.getSession().breakpointReached((XBreakpoint)breakpoint, null, suspendContext);
            } else {
                JupyterRemoteDebugLog.INSTANCE.getLOG().info("Stop on breakpoint, but no suitable breakpoint found. Fall back to stop on a position.");
                this.getSession().positionReached(suspendContext);
            }
        } else if (threadInfo.getStopReason() == StopReason.STEP.ordinal()) {
            this.getSession().positionReached(suspendContext);
        } else {
            JupyterRemoteDebugLog.INSTANCE.getLOG().info("Unsupported stop reason '" + threadInfo.getStopReason() + "'. Fall back to stop on a position.");
            this.getSession().positionReached(suspendContext);
        }
    }

    private final XSuspendContext createSuspendContext(PyThreadInfo threadInfo) {
        return new JupyterRemoteDebugContext(this, threadInfo, this.debuggerAdapter);
    }

    public void resume(@Nullable XSuspendContext context) {
        if (!(context instanceof JupyterRemoteDebugContext)) {
            return;
        }
        XStackFrame xStackFrame = ((JupyterRemoteDebugContext)context).getActiveExecutionStack().getTopFrame();
        Object object = xStackFrame instanceof PyStackFrame ? (PyStackFrame)xStackFrame : null;
        if (object == null || (object = object.getThreadId()) == null) {
            return;
        }
        int threadId = Integer.parseInt((String)object);
        this.debuggerAdapter.resume(threadId);
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        if (!(context instanceof JupyterRemoteDebugContext)) {
            return;
        }
        XStackFrame xStackFrame = ((JupyterRemoteDebugContext)context).getActiveExecutionStack().getTopFrame();
        Object object = xStackFrame instanceof PyStackFrame ? (PyStackFrame)xStackFrame : null;
        if (object == null || (object = object.getThreadId()) == null) {
            return;
        }
        int threadId = Integer.parseInt((String)object);
        this.debuggerAdapter.stepOver(threadId);
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        if (!(context instanceof JupyterRemoteDebugContext)) {
            return;
        }
        XStackFrame xStackFrame = ((JupyterRemoteDebugContext)context).getActiveExecutionStack().getTopFrame();
        PyStackFrame pyStackFrame = xStackFrame instanceof PyStackFrame ? (PyStackFrame)xStackFrame : null;
        if (pyStackFrame == null) {
            return;
        }
        PyStackFrame frame = pyStackFrame;
        String string = frame.getThreadId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getThreadId(...)");
        int threadId = Integer.parseInt(string);
        String string2 = frame.getFrameId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFrameId(...)");
        this.debuggerAdapter.stepInto(threadId, Integer.parseInt(string2));
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        this.startStepInto(context);
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.startStepOver(context);
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.startStepOver(context);
    }

    public void stop() {
        this.debuggerAdapter.handleStop();
        ApplicationManager.getApplication().invokeLater(() -> JupyterRemoteDebugProcess.stop$lambda$7(this));
        this.printToConsole(JupyterBundle.message((String)"debugger.disconnected", (Object[])new Object[0]) + "\n");
    }

    private static final void stop$lambda$7(JupyterRemoteDebugProcess this$0) {
        BackedNotebookVirtualFile notebookVirtualFile = JupyterPsiCellExt.INSTANCE.getJupyterBackedVirtualFileOrThrow(this$0.getCell());
        JupyterDebugSessionManager.Companion.getInstance(this$0.getProject()).debugInSessionFinished(new JupyterSessionPath(notebookVirtualFile));
    }
}

