/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.validation.PyAnnotator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class PyDefinitionsAnnotator
extends PyAnnotator {
    @Override
    public void visitPyClass(@NotNull PyClass node) {
        ASTNode name_node;
        if (node == null) {
            PyDefinitionsAnnotator.$$$reportNull$$$0(0);
        }
        if ((name_node = node.getNameNode()) != null) {
            this.addHighlightingAnnotation(name_node, PyHighlighter.PY_CLASS_DEFINITION);
        }
    }

    @Override
    public void visitPyFunction(@NotNull PyFunction node) {
        ASTNode nameNode;
        if (node == null) {
            PyDefinitionsAnnotator.$$$reportNull$$$0(1);
        }
        if ((nameNode = node.getNameNode()) != null) {
            String name2 = node.getName();
            LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)node);
            if (PyNames.UNDERSCORED_ATTRIBUTES.contains(name2) || PyNames.getBuiltinMethods((LanguageLevel)languageLevel).containsKey(name2)) {
                PyClass cls = node.getContainingClass();
                if (PyUtil.isNewMethod(node)) {
                    boolean new_style_class = false;
                    try {
                        if (cls != null) {
                            new_style_class = cls.isNewStyleClass(null);
                        }
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                    if (new_style_class) {
                        this.addHighlightingAnnotation(nameNode, PyHighlighter.PY_PREDEFINED_DEFINITION);
                    }
                } else {
                    this.addHighlightingAnnotation(nameNode, PyHighlighter.PY_PREDEFINED_DEFINITION);
                }
            } else if (ScopeUtil.getScopeOwner(node) instanceof PyFunction) {
                this.addHighlightingAnnotation(nameNode, PyHighlighter.PY_NESTED_FUNC_DEFINITION);
            } else {
                this.addHighlightingAnnotation(nameNode, PyHighlighter.PY_FUNC_DEFINITION);
            }
        }
    }

    @Override
    public void visitPyDecorator(@NotNull PyDecorator node) {
        PsiElement atSign;
        if (node == null) {
            PyDefinitionsAnnotator.$$$reportNull$$$0(2);
        }
        if ((atSign = node.getFirstChild()) != null) {
            this.addHighlightingAnnotation(atSign, PyHighlighter.PY_DECORATOR);
            if (node.getQualifiedName() != null) {
                this.addHighlightingAnnotation((PsiElement)Objects.requireNonNull(node.getCallee()), PyHighlighter.PY_DECORATOR);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "node";
        objectArray2[1] = "com/jetbrains/python/validation/PyDefinitionsAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyFunction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyDecorator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

