/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor.markdown;

import com.intellij.jupyter.core.editor.markdown.Heading;
import com.intellij.jupyter.core.editor.markdown.MarkdownEditorCell;
import com.intellij.jupyter.core.editor.markdown.NotebookStructureElement;
import com.intellij.notebooks.ui.observables.DistinctObservablePropertyKt;
import com.intellij.notebooks.visualization.EditorNotebookExtension;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellEventListener;
import com.intellij.notebooks.visualization.ui.EditorCellExtension;
import com.intellij.notebooks.visualization.ui.EditorNotebook;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0002J.\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u001c\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/core/editor/markdown/MarkdownExtension;", "Lcom/intellij/notebooks/visualization/EditorNotebookExtension;", "Lcom/intellij/openapi/Disposable;", "notebook", "Lcom/intellij/notebooks/visualization/ui/EditorNotebook;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorNotebook;)V", "parser", "Lorg/intellij/markdown/parser/MarkdownParser;", "structure", "Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "Lcom/intellij/jupyter/core/editor/markdown/NotebookStructureElement$Notebook;", "getStructure", "()Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "onCellCreated", "", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "buildNotebookStructure", "", "cells", "", "i", "level", "parent", "Lcom/intellij/jupyter/core/editor/markdown/NotebookStructureElement$WithChildren;", "getCellHeading", "Lcom/intellij/jupyter/core/editor/markdown/Heading;", "dispose", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nMarkdownExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownExtension.kt\ncom/intellij/jupyter/core/editor/markdown/MarkdownExtension\n+ 2 EditorCell.kt\ncom/intellij/notebooks/visualization/ui/EditorCell\n*L\n1#1,100:1\n93#2:101\n*S KotlinDebug\n*F\n+ 1 MarkdownExtension.kt\ncom/intellij/jupyter/core/editor/markdown/MarkdownExtension\n*L\n92#1:101\n*E\n"})
public final class MarkdownExtension
implements EditorNotebookExtension,
Disposable {
    @NotNull
    private final EditorNotebook notebook;
    @NotNull
    private final MarkdownParser parser;
    @NotNull
    private final ObservableMutableProperty<NotebookStructureElement.Notebook> structure;

    public MarkdownExtension(@NotNull EditorNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        this.notebook = notebook;
        this.parser = new MarkdownParser((MarkdownFlavourDescriptor)new GFMFlavourDescriptor(false, false, false, 7, null));
        this.structure = DistinctObservablePropertyKt.distinct((ObservableMutableProperty)((ObservableMutableProperty)new AtomicProperty((Object)this.buildNotebookStructure())));
        this.notebook.addCellEventsListener((Disposable)this, new EditorCellEventListener(){

            public void onEditorCellEvents(List<? extends EditorCellEventListener.EditorCellEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                for (EditorCellEventListener.EditorCellEvent editorCellEvent : events) {
                    EditorCellEventListener.EditorCellEvent editorCellEvent2 = editorCellEvent;
                    if (editorCellEvent2 instanceof EditorCellEventListener.CellCreated) {
                        NotebookStructureElement.Notebook notebook = this.buildNotebookStructure();
                        this.getStructure().set((Object)notebook);
                        NotebookStructureElement element = notebook.getElement(((EditorCellEventListener.CellCreated)editorCellEvent).getCell());
                        if (element == null) continue;
                        for (NotebookStructureElement.WithChildren container = element.getParent(); container != null; container = container.getParent()) {
                            if (!(container instanceof NotebookStructureElement.NotebookSection)) continue;
                            ((NotebookStructureElement.NotebookSection)container).unfold();
                        }
                        continue;
                    }
                    if (editorCellEvent2 instanceof EditorCellEventListener.CellRemoved) {
                        this.getStructure().set((Object)this.buildNotebookStructure());
                        continue;
                    }
                    throw new NoWhenBranchMatchedException();
                }
            }
        });
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.notebook));
    }

    @NotNull
    public final ObservableMutableProperty<NotebookStructureElement.Notebook> getStructure() {
        return this.structure;
    }

    public void onCellCreated(@NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        if (cell.getType() == NotebookCellLines.CellType.MARKDOWN) {
            MarkdownEditorCell markdownEditorCell = new MarkdownEditorCell(cell, this.parser);
            markdownEditorCell.getHeading().afterChange(arg_0 -> MarkdownExtension.onCellCreated$lambda$0(this, arg_0));
            cell.addExtension(Reflection.getOrCreateKotlinClass(MarkdownEditorCell.class), (EditorCellExtension)markdownEditorCell);
        }
    }

    private final NotebookStructureElement.Notebook buildNotebookStructure() {
        NotebookStructureElement.Notebook notebook = new NotebookStructureElement.Notebook();
        this.buildNotebookStructure(this.notebook.getCells(), 0, 0, notebook);
        return notebook;
    }

    private final int buildNotebookStructure(List<EditorCell> cells, int i, int level, NotebookStructureElement.WithChildren parent) {
        int pointer = i;
        while (pointer < cells.size()) {
            EditorCell cell = cells.get(pointer);
            Heading cellHeading = this.getCellHeading(cell);
            if (cellHeading != null) {
                if (cellHeading.getLevel() <= level) break;
                NotebookStructureElement.NotebookSection section = new NotebookStructureElement.NotebookSection(cell);
                parent.addChildren(section);
                pointer = this.buildNotebookStructure(cells, pointer + 1, cellHeading.getLevel(), section);
                continue;
            }
            parent.addChildren(new NotebookStructureElement.NotebookCell(cell));
            ++pointer;
        }
        return pointer;
    }

    private final Heading getCellHeading(EditorCell cell) {
        Heading heading;
        NotebookCellLines.Interval interval = cell.getIntervalOrNull();
        if ((interval != null ? interval.getType() : null) == NotebookCellLines.CellType.MARKDOWN) {
            EditorCell this_$iv = cell;
            boolean $i$f$getExtension = false;
            ObservableMutableProperty<Heading> observableMutableProperty = (ObservableMutableProperty<Heading>)this_$iv.getExtension(Reflection.getOrCreateKotlinClass(MarkdownEditorCell.class));
            heading = observableMutableProperty != null && (observableMutableProperty = observableMutableProperty.getHeading()) != null ? (Heading)observableMutableProperty.get() : null;
        } else {
            heading = null;
        }
        return heading;
    }

    public void dispose() {
    }

    private static final Unit onCellCreated$lambda$0(MarkdownExtension this$0, Heading it) {
        this$0.structure.set((Object)this$0.buildNotebookStructure());
        return Unit.INSTANCE;
    }
}

