/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.dnd;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dnd.TreeNodeTransfer;
import org.jkiss.dbeaver.ui.navigator.INavigatorNodeContainer;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorContent;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorDropTargetListener
implements DropTargetListener {
    private final Viewer viewer;

    public NavigatorDropTargetListener(Viewer viewer) {
        this.viewer = viewer;
    }

    public void dragEnter(DropTargetEvent event) {
        this.handleDragEvent(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.handleDragEvent(event);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.handleDragEvent(event);
    }

    public void dragOver(DropTargetEvent event) {
        this.handleDragEvent(event);
    }

    public void drop(DropTargetEvent event) {
        this.handleDragEvent(event);
        if (event.detail == 2) {
            this.moveNodes(event);
        }
    }

    public void dropAccept(DropTargetEvent event) {
        this.handleDragEvent(event);
    }

    private void handleDragEvent(DropTargetEvent event) {
        event.detail = this.isDropSupported(event) ? 2 : 0;
        event.feedback = 9;
    }

    private boolean isDropSupported(DropTargetEvent event) {
        Object curObject = NavigatorDropTargetListener.getDropTarget(event, this.viewer);
        if (TreeNodeTransfer.getInstance().isSupportedType(event.currentDataType)) {
            Collection nodesToDrop = (Collection)event.data;
            if (curObject instanceof DBNNode) {
                if (!CommonUtils.isEmpty((Collection)nodesToDrop)) {
                    for (DBNNode node : nodesToDrop) {
                        if (((DBNNode)curObject).supportsDrop(node)) continue;
                        return false;
                    }
                    return true;
                }
                return ((DBNNode)curObject).supportsDrop(null);
            }
            if (curObject == null) {
                if (!CommonUtils.isEmpty((Collection)nodesToDrop)) {
                    for (DBNNode node : nodesToDrop) {
                        if (node instanceof DBNDataSource) continue;
                        return false;
                    }
                    return true;
                }
                Widget widget = event.widget;
                if (widget instanceof DropTarget) {
                    widget = ((DropTarget)widget).getControl();
                }
                return widget == this.viewer.getControl();
            }
        }
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType) && curObject instanceof IAdaptable) {
            IResource curResource = (IResource)((IAdaptable)curObject).getAdapter(IResource.class);
            return curResource != null;
        }
        return false;
    }

    private void moveNodes(final DropTargetEvent event) {
        IAdaptable adaptable;
        IResource curResource;
        Object curObject = NavigatorDropTargetListener.getDropTarget(event, this.viewer);
        if (TreeNodeTransfer.getInstance().isSupportedType(event.currentDataType)) {
            if (curObject instanceof DBNNode) {
                Collection nodesToDrop = (Collection)TreeNodeTransfer.getInstance().getObject();
                try {
                    UIUtils.runInProgressService(monitor -> {
                        try {
                            ((DBNNode)curObject).dropNodes(monitor, nodesToDrop);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    });
                }
                catch (Exception e) {
                    DBWorkbench.getPlatformUI().showError("Drop error", "Can't drop node", (Throwable)e);
                    return;
                }
            } else if (curObject == null) {
                for (DBNNode node : (Collection)TreeNodeTransfer.getInstance().getObject()) {
                    if (node instanceof DBNDataSource) {
                        DBNNode rootNode;
                        DBNDataSource ds = (DBNDataSource)node;
                        if (this.viewer.getInput() instanceof DatabaseNavigatorContent && (rootNode = ((DatabaseNavigatorContent)this.viewer.getInput()).getRootNode()) != null && rootNode.getOwnerProject() != null) {
                            ds.moveToFolder(rootNode.getOwnerProject(), null);
                        }
                    } else {
                        if (!(node instanceof DBNLocalFolder)) continue;
                        DBNLocalFolder lf = (DBNLocalFolder)node;
                        lf.getFolder().setParent(null);
                    }
                    DBNModel.updateConfigAndRefreshDatabases((DBNNode)node);
                }
            }
        }
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType) && curObject instanceof IAdaptable && (curResource = (IResource)(adaptable = (IAdaptable)curObject).getAdapter(IResource.class)) != null) {
            if (curResource instanceof IFile) {
                curResource = curResource.getParent();
            }
            if (curResource instanceof IContainer) {
                final IContainer toFolder = (IContainer)curResource;
                new AbstractJob("Copy files to workspace"){
                    {
                        super($anonymous0);
                        this.setUser(true);
                    }

                    protected IStatus run(DBRProgressMonitor monitor) {
                        String[] fileNames = (String[])event.data;
                        monitor.beginTask("Copy files", fileNames.length);
                        try {
                            try {
                                NavigatorDropTargetListener.dropFilesIntoFolder(monitor, toFolder, fileNames);
                            }
                            catch (Exception e) {
                                IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                                monitor.done();
                                return iStatus;
                            }
                        }
                        finally {
                            monitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            } else {
                DBWorkbench.getPlatformUI().showError("Drop error", "Can't drop file into '" + curResource.getName() + "'. Files can be dropped only into folders.");
            }
        }
    }

    @Nullable
    private static Object getDropTarget(@NotNull DropTargetEvent event, @NotNull Viewer viewer) {
        List list;
        if (event.item instanceof Item) {
            return event.item.getData();
        }
        Object input = viewer.getInput();
        if (input instanceof INavigatorNodeContainer) {
            INavigatorNodeContainer dnc = (INavigatorNodeContainer)input;
            return dnc.getRootNode();
        }
        if (input instanceof List && !(list = (List)input).isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    private static void dropFilesIntoFolder(DBRProgressMonitor monitor, IContainer toFolder, String[] data) throws Exception {
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String extFileName = stringArray[n2];
            java.nio.file.Path extFile = java.nio.file.Path.of(extFileName, new String[0]);
            NavigatorDropTargetListener.dropFileIntoContainer(monitor, toFolder, extFile);
            ++n2;
        }
    }

    private static void dropFileIntoContainer(DBRProgressMonitor monitor, IContainer toFolder, java.nio.file.Path extFile) throws CoreException, IOException {
        if (Files.exists(extFile, new LinkOption[0])) {
            Path ePath = new Path(extFile.getFileName().toString());
            if (Files.isDirectory(extFile, new LinkOption[0])) {
                List<java.nio.file.Path> sourceFolderContents;
                IFolder subFolder = toFolder.getFolder((IPath)ePath);
                if (!subFolder.exists()) {
                    subFolder.create(true, true, monitor.getNestedMonitor());
                }
                Throwable throwable = null;
                Iterator<java.nio.file.Path> iterator = null;
                try (Stream<java.nio.file.Path> list = Files.list(extFile);){
                    sourceFolderContents = list.toList();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                for (java.nio.file.Path folderFile : sourceFolderContents) {
                    NavigatorDropTargetListener.dropFileIntoContainer(monitor, (IContainer)subFolder, folderFile);
                }
            } else {
                monitor.subTask("Copy file " + String.valueOf(extFile));
                try {
                    IFile targetFile;
                    if (toFolder instanceof IFolder && !toFolder.exists()) {
                        ((IFolder)toFolder).create(true, true, monitor.getNestedMonitor());
                    }
                    if ((targetFile = toFolder.getFile((IPath)ePath)).exists() && !UIUtils.confirmAction((String)"File exists", (String)("File '" + targetFile.getName() + "' exists. Do you want to overwrite it?"))) {
                        return;
                    }
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (InputStream is = Files.newInputStream(extFile, new OpenOption[0]);){
                        if (targetFile.exists()) {
                            targetFile.setContents(is, true, false, monitor.getNestedMonitor());
                        } else {
                            targetFile.create(is, true, monitor.getNestedMonitor());
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                finally {
                    monitor.worked(1);
                }
            }
        }
    }
}

