/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.itemlist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectEditor;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseDynamicItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeReference;
import org.jkiss.dbeaver.model.navigator.DBNObjectNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.INavigatorListener;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNodeHandler;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceAbstract;
import org.jkiss.dbeaver.runtime.properties.PropertySourceEditable;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ObjectViewerRenderer;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.INavigatorNodeContainer;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class NodeListControl
extends ObjectListControl<DBNNode>
implements DBPDataSourceContainerProvider,
INavigatorModelView,
INavigatorListener {
    private static final Log log = Log.getLog(NodeListControl.class);
    private final IWorkbenchSite workbenchSite;
    private DBNNode rootNode;
    private DBXTreeNode nodeMeta;
    private final NodeSelectionProvider selectionProvider;

    protected NodeListControl(@NotNull Composite parent, int style, @Nullable IWorkbenchSite workbenchSite, @NotNull DBNNode rootNode, @NotNull IContentProvider contentProvider) {
        super(parent, style, contentProvider);
        this.workbenchSite = workbenchSite;
        this.rootNode = rootNode;
        this.selectionProvider = this.createSelectionProvider(super.getSelectionProvider());
        NavigatorUtils.addContextMenu(workbenchSite, (Viewer)this.getItemsViewer(), this.selectionProvider);
        this.setDoubleClickHandler(event -> {
            ISelection selection = this.getItemsViewer().getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)selection;
                for (Object obj : ss.toList()) {
                    DBNNode node;
                    if (!(obj instanceof DBNNode) || !(node = (DBNNode)obj).allowsOpen()) continue;
                    this.openNodeEditor(node);
                }
            }
        });
        NavigatorUtils.addDragAndDropSupport((Viewer)this.getItemsViewer());
        if (workbenchSite != null) {
            EditorUtils.trackControlContext((IWorkbenchSite)workbenchSite, (Control)this.getItemsViewer().getControl(), (String)"org.jkiss.dbeaver.ui.context.navigator");
        }
        DBWorkbench.getPlatform().getNavigatorModel().addListener((INavigatorListener)this);
    }

    protected NodeSelectionProvider createSelectionProvider(ISelectionProvider selectionProvider) {
        return new NodeSelectionProvider(selectionProvider);
    }

    protected void openNodeEditor(DBNNode node) {
        IWorkbenchWindow serviceLocator = this.workbenchSite != null ? this.workbenchSite : UIUtils.getActiveWorkbenchWindow();
        NavigatorUtils.executeNodeAction(DBXTreeNodeHandler.Action.open, node, (IServiceLocator)serviceLocator);
    }

    NodeListControl(@NotNull Composite parent, int style, @NotNull IWorkbenchSite workbenchSite, @NotNull DBNNode rootNode, @Nullable DBXTreeNode nodeMeta) {
        this(parent, style, workbenchSite, rootNode, NodeListControl.createContentProvider(rootNode, nodeMeta));
        this.nodeMeta = nodeMeta;
    }

    IWorkbenchSite getWorkbenchSite() {
        return this.workbenchSite;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        DBNNode dBNNode = this.rootNode;
        if (dBNNode instanceof DBNDatabaseNode) {
            DBNDatabaseNode node = (DBNDatabaseNode)dBNNode;
            return node.getDataSourceContainer();
        }
        return null;
    }

    @Override
    public void disposeControl() {
        if (this.selectionProvider != null) {
            this.selectionProvider.dispose();
        }
        DBWorkbench.getPlatform().getNavigatorModel().removeListener((INavigatorListener)this);
        super.disposeControl();
    }

    @Override
    protected List<DBNNode> createViewerInput(Collection<DBNNode> objectList) {
        return new NodeListInput(objectList);
    }

    @Override
    public NodeSelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    private static IContentProvider createContentProvider(DBNNode node, DBXTreeNode metaNode) {
        if (node instanceof DBNDatabaseNode) {
            List<DBXTreeNode> inlineMetas;
            DBNDatabaseNode dbNode = (DBNDatabaseNode)node;
            if (metaNode == null) {
                metaNode = dbNode.getMeta();
            }
            if (!(inlineMetas = NodeListControl.collectInlineMetas(dbNode, metaNode)).isEmpty() || !(node instanceof DBNDataSource) && dbNode.isDynamicStructObject()) {
                return new TreeContentProvider(){

                    public boolean hasChildren(Object parentElement) {
                        DBNDatabaseNode node;
                        return parentElement instanceof DBNDatabaseNode && (node = (DBNDatabaseNode)parentElement).hasChildren(false);
                    }

                    public Object[] getChildren(Object parentElement) {
                        if (parentElement instanceof DBNDatabaseNode) {
                            Object[] children;
                            block4: {
                                DBNDatabaseNode node = (DBNDatabaseNode)parentElement;
                                children = DBNUtils.getNodeChildrenFiltered((DBRProgressMonitor)new VoidProgressMonitor(), (DBNNode)node, (boolean)false);
                                if (!ArrayUtils.isEmpty((Object[])children)) break block4;
                                return null;
                            }
                            try {
                                return children;
                            }
                            catch (DBException e) {
                                log.error((Object)e);
                            }
                        }
                        return null;
                    }
                };
            }
        }
        return new ListContentProvider();
    }

    @Override
    protected boolean isDynamicObject(DBNNode object) {
        return object instanceof DBNDatabaseDynamicItem;
    }

    protected static List<DBXTreeNode> collectInlineMetas(DBNDatabaseNode node, DBXTreeNode meta) {
        ArrayList<DBXTreeNode> inlineMetas = new ArrayList<DBXTreeNode>();
        if (meta instanceof DBXTreeFolder) {
            for (DBXTreeNode metaChild : meta.getChildren((DBNNode)node)) {
                NodeListControl.collectInlineChildren(metaChild, inlineMetas);
            }
        } else {
            NodeListControl.collectInlineChildren(meta, inlineMetas);
        }
        return inlineMetas;
    }

    private static void collectInlineChildren(DBXTreeNode meta, List<DBXTreeNode> inlineMetas) {
        List metaChildren = meta.getChildren(null);
        if (!CommonUtils.isEmpty((Collection)metaChildren)) {
            for (DBXTreeNode child : metaChildren) {
                if (!child.isInline()) continue;
                inlineMetas.add(child);
            }
        }
    }

    @Override
    @Nullable
    protected Class<?>[] getListBaseTypes(Collection<DBNNode> items) {
        DBNNode dBNNode = this.getRootNode();
        if (dBNNode instanceof DBNDatabaseNode) {
            DBNDatabaseFolder folder;
            Class childrenClass;
            DBNDatabaseNode dbNode = (DBNDatabaseNode)dBNNode;
            List baseTypes = dbNode.getChildrenTypes(this.nodeMeta);
            if (CommonUtils.isEmpty((Collection)baseTypes) && dbNode instanceof DBNDatabaseFolder && (childrenClass = (folder = (DBNDatabaseFolder)dbNode).getChildrenClass()) != null) {
                return new Class[]{childrenClass};
            }
            return CommonUtils.isEmpty((Collection)baseTypes) ? null : baseTypes.toArray(new Class[0]);
        }
        return null;
    }

    @Override
    @Nullable
    public Viewer getNavigatorViewer() {
        return this.getItemsViewer();
    }

    @Override
    @NotNull
    public DBNNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(@NotNull DBNNode rootNode) {
        this.rootNode = rootNode;
    }

    protected DBXTreeNode getNodeMeta() {
        return this.nodeMeta;
    }

    @Override
    protected Object getObjectValue(@NotNull DBNNode item) {
        if (item instanceof DBSWrapper) {
            DBSWrapper wrapper = (DBSWrapper)item;
            return wrapper.getObject();
        }
        if (item instanceof DBNObjectNode) {
            DBNObjectNode node = (DBNObjectNode)item;
            return node.getNodeObject();
        }
        return item;
    }

    @Override
    protected DBPImage getObjectImage(DBNNode item) {
        return item.getNodeIconDefault();
    }

    @Override
    protected boolean isNewObject(DBNNode objectValue) {
        return !objectValue.isPersisted();
    }

    @Override
    protected boolean isReadOnlyList() {
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return container != null && container.isConnectionReadOnly();
    }

    @Override
    @NotNull
    protected String getListConfigId(List<Class<?>> classList) {
        StringBuilder sb = new StringBuilder("NodeList");
        for (Class<?> theClass : classList) {
            sb.append("/").append(theClass.getSimpleName());
        }
        return sb.toString();
    }

    @Override
    protected PropertySourceAbstract createListPropertySource() {
        IDatabaseEditor de;
        IEditorInput editorInput;
        IWorkbenchPartSite partSite;
        IWorkbenchPart iWorkbenchPart;
        IWorkbenchSite iWorkbenchSite = this.workbenchSite;
        if (iWorkbenchSite instanceof IWorkbenchPartSite && (iWorkbenchPart = (partSite = (IWorkbenchPartSite)iWorkbenchSite).getPart()) instanceof IDatabaseEditor && (editorInput = (de = (IDatabaseEditor)iWorkbenchPart).getEditorInput()) instanceof IDatabaseEditorInput) {
            IDatabaseEditorInput dei = (IDatabaseEditorInput)editorInput;
            return new NodeListPropertySource(dei.getCommandContext());
        }
        return super.createListPropertySource();
    }

    public void nodeChanged(DBNEvent event) {
        if (this.isDisposed()) {
            return;
        }
        DBNNode rootNode = this.getRootNode();
        DBNNode eventNode = event.getNode();
        if (eventNode == rootNode || eventNode.isChildOf(rootNode)) {
            switch (event.getAction()) {
                case ADD: 
                case REMOVE: {
                    this.loadData(false, true);
                    break;
                }
                case UPDATE: {
                    if (eventNode == rootNode) {
                        this.loadData(false, true);
                        break;
                    }
                    this.getItemsViewer().update((Object)eventNode, null);
                }
            }
        }
    }

    @Override
    protected ObjectViewerRenderer createRenderer() {
        return new NodeRenderer();
    }

    private class NodeListInput
    extends ArrayList<DBNNode>
    implements INavigatorNodeContainer {
        public NodeListInput(Collection<DBNNode> objectList) {
            super(objectList);
        }

        @Override
        public DBNNode getRootNode() {
            return NodeListControl.this.getRootNode();
        }
    }

    private class NodeListPropertySource
    extends PropertySourceEditable
    implements DBNNodeReference {
        private NodeListPropertySource(DBECommandContext commandContext) {
            super(commandContext, (Object)NodeListControl.this, (Object)NodeListControl.this);
        }

        public DBNNode getSourceObject() {
            return (DBNNode)NodeListControl.this.getCurrentListObject();
        }

        public Object getEditableValue() {
            return NodeListControl.this.getObjectValue((DBNNode)NodeListControl.this.getCurrentListObject());
        }

        /*
         * WARNING - void declaration
         */
        public boolean isEditable(Object editableValue) {
            DBPObject object;
            void databaseNode;
            if (editableValue == null) {
                return false;
            }
            DBNNode rootNode = NodeListControl.this.getRootNode();
            if (!(rootNode instanceof DBNDatabaseNode)) {
                return false;
            }
            DBNDatabaseNode dBNDatabaseNode = (DBNDatabaseNode)rootNode;
            Class<?> curClass = editableValue.getClass();
            Object valueObject = databaseNode.getValueObject();
            if (valueObject == null) {
                return false;
            }
            DBEObjectEditor objectEditor = (DBEObjectEditor)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(curClass, DBEObjectEditor.class);
            return objectEditor != null && editableValue instanceof DBPObject && objectEditor.canEditObject(object = (DBPObject)editableValue) && DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("metadata-editor");
        }

        public DBPPropertyDescriptor[] getProperties() {
            return NodeListControl.this.getAllProperties().toArray(new DBPPropertyDescriptor[0]);
        }

        public void setPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull Object editableValue, @NotNull ObjectPropertyDescriptor prop, @Nullable Object newValue) throws IllegalArgumentException {
            super.setPropertyValue(monitor, editableValue, prop, newValue);
            NodeListControl.this.resetLazyPropertyCache((DBNNode)NodeListControl.this.getCurrentListObject(), prop.getId());
        }

        public DBNNode getReferencedNode() {
            return NodeListControl.this.getRootNode();
        }
    }

    private class NodeRenderer
    extends ObjectListControl.ViewerRenderer {
        private NodeRenderer() {
        }

        public boolean isHyperlink(Object element, Object cellValue) {
            Object ownerObject = null;
            DBNNode dBNNode = NodeListControl.this.rootNode;
            if (dBNNode instanceof DBNDatabaseNode) {
                DBNDatabaseNode node = (DBNDatabaseNode)dBNNode;
                ownerObject = node.getValueObject();
            }
            return cellValue instanceof DBSObject && cellValue != ownerObject;
        }

        public void navigateHyperlink(Object cellValue) {
            if (cellValue instanceof DBSObject) {
                DBSObject object = (DBSObject)cellValue;
                NavigatorHandlerObjectOpen.openEntityEditor(object);
            }
        }
    }

    public class NodeSelectionProvider
    implements ISelectionProvider,
    ISelectionChangedListener {
        private final ISelectionProvider original;
        private final List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
        private StructuredSelection defaultSelection;

        NodeSelectionProvider(ISelectionProvider original) {
            this.original = original;
            this.defaultSelection = new StructuredSelection((Object)NodeListControl.this.rootNode);
            this.original.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            List<ISelectionChangedListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        public ISelection getSelection() {
            ISelection selection = this.original.getSelection();
            if (selection == null || selection.isEmpty()) {
                return this.defaultSelection;
            }
            return selection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            List<ISelectionChangedListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }

        public void setSelection(ISelection selection) {
            if (selection == this.defaultSelection) {
                this.original.setSelection((ISelection)new StructuredSelection());
            } else {
                this.original.setSelection(selection);
            }
            this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectionChanged(SelectionChangedEvent event) {
            List<ISelectionChangedListener> list = this.listeners;
            synchronized (list) {
                event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
                for (ISelectionChangedListener listener : this.listeners) {
                    listener.selectionChanged(event);
                }
            }
        }

        public void setDefaultSelection(StructuredSelection defaultSelection) {
            this.defaultSelection = defaultSelection;
        }

        void dispose() {
            this.original.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }
}

