/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCCachedContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCParameterizedStatement;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.qm.meta.Include;
import org.jkiss.dbeaver.model.qm.meta.QMMDataSourceInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMProjectInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMetaObjectType;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;

public class QMMConnectionInfo
extends QMMObject
implements QMMDataSourceInfo {
    @Include
    private final QMMProjectInfo projectInfo;
    @Include
    private final String containerId;
    private String containerName;
    private final String driverId;
    private String connectionUserName;
    private String connectionUrl;
    @Include
    private String instanceId;
    @Include
    private String contextName;
    private boolean transactional;
    private transient QMMStatementInfo statementStack;
    private transient QMMStatementExecuteInfo executionStack;
    private transient QMMTransactionInfo transaction;

    public QMMConnectionInfo(DBCExecutionContext context, boolean transactional) {
        super(QMMetaObjectType.CONNECTION_INFO);
        this.containerId = context.getDataSource().getContainer().getId();
        this.driverId = context.getDataSource().getContainer().getDriver().getFullId();
        this.projectInfo = new QMMProjectInfo(context.getDataSource().getContainer().getProject());
        this.initFromContext(context, transactional);
    }

    private QMMConnectionInfo(Builder builder) {
        super(QMMetaObjectType.CONNECTION_INFO, builder.openTime, builder.closeTime);
        this.projectInfo = builder.projectInfo;
        this.containerId = builder.containerId;
        this.driverId = builder.driverId;
        this.containerName = builder.containerName;
        this.connectionUserName = builder.connectionUserName;
        this.connectionUrl = builder.connectionUrl;
        this.instanceId = builder.instanceId;
        this.contextName = builder.contextName;
        this.transactional = builder.transactional;
        this.statementStack = builder.statementStack;
        this.executionStack = builder.executionStack;
        this.transaction = builder.transaction;
    }

    private void initFromContext(DBCExecutionContext context, boolean transactional) {
        this.containerName = context.getDataSource().getContainer().getName();
        DBPConnectionConfiguration connectionConfiguration = context.getDataSource().getContainer().getConnectionConfiguration();
        this.connectionUserName = connectionConfiguration.getUserName();
        this.connectionUrl = connectionConfiguration.getUrl();
        this.instanceId = context.getOwnerInstance().getName();
        this.contextName = context.getContextName();
        this.transactional = transactional;
        if (transactional) {
            this.transaction = new QMMTransactionInfo(this, null);
        }
    }

    public QMMConnectionInfo(long openTime, long closeTime, QMMProjectInfo projectInfo, String containerId, String containerName, String driverId, DBPConnectionConfiguration connectionConfiguration, String instanceID, String contextName, boolean transactional) {
        super(QMMetaObjectType.CONNECTION_INFO, openTime, closeTime);
        this.projectInfo = projectInfo;
        this.containerId = containerId;
        this.containerName = containerName;
        this.driverId = driverId;
        this.connectionUserName = connectionConfiguration.getUserName();
        this.connectionUrl = connectionConfiguration.getUrl();
        this.instanceId = instanceID;
        this.contextName = contextName;
        this.transactional = transactional;
    }

    @Override
    public void close() {
        if (this.transaction != null) {
            this.transaction.rollback(null);
            this.transaction = null;
        }
        QMMStatementInfo stat = this.statementStack;
        while (stat != null) {
            if (!stat.isClosed()) {
                DBCStatement statRef = stat.getReference();
                String query = statRef == null ? "?" : statRef.getQueryString();
                log.warn("Statement " + stat.getObjectId() + " (" + query + ") is not closed (" + stat.getConnection().connectionUrl + ")");
                stat.close();
            }
            stat = stat.getPrevious();
        }
        this.statementStack = null;
        super.close();
    }

    public void reopen(DBCExecutionContext context) {
        DBCTransactionManager txnManager = DBUtils.getTransactionManager(context);
        boolean autoCommit = true;
        if (txnManager != null) {
            try {
                autoCommit = txnManager.isAutoCommit();
            }
            catch (DBCException e) {
                log.warn(e);
            }
        }
        this.initFromContext(context, !autoCommit);
        super.reopen();
    }

    @Override
    public String getText() {
        return this.containerName + " - " + this.contextName;
    }

    @Override
    public QMMConnectionInfo getConnection() {
        return this;
    }

    public QMMTransactionInfo changeTransactional(boolean transactional) {
        if (this.transactional == transactional) {
            return null;
        }
        this.transactional = transactional;
        if (this.transaction != null) {
            this.transaction.commit();
        }
        this.transaction = new QMMTransactionInfo(this, this.transaction);
        return this.transaction.getPrevious();
    }

    public QMMTransactionInfo commit() {
        if (this.transactional) {
            if (this.transaction != null) {
                this.transaction.commit();
            }
            this.transaction = new QMMTransactionInfo(this, this.transaction);
            return this.transaction.getPrevious();
        }
        return null;
    }

    public QMMObject rollback(DBCSavepoint savepoint) {
        if (this.transactional) {
            if (this.transaction != null) {
                this.transaction.rollback(savepoint);
            }
            if (savepoint == null) {
                this.transaction = new QMMTransactionInfo(this, this.transaction);
                return this.transaction.getPrevious();
            }
            if (this.transaction != null) {
                return this.transaction.getSavepoint(savepoint);
            }
        }
        return null;
    }

    public QMMStatementInfo openStatement(DBCStatement statement) {
        this.statementStack = new QMMStatementInfo(this, statement, this.statementStack);
        return this.statementStack;
    }

    public QMMStatementInfo closeStatement(DBCStatement statement, long rows) {
        QMMStatementExecuteInfo execution = this.getExecution(statement);
        if (execution != null && execution.getUpdateRowCount() < 0L) {
            execution.close(rows, null);
        }
        QMMStatementInfo stat = this.statementStack;
        while (stat != null) {
            if (stat.getReference() == statement) {
                stat.close();
                return stat;
            }
            stat = stat.getPrevious();
        }
        if (this.statementStack != null) {
            log.warn("Closed statement " + String.valueOf(statement) + " meta info not found");
        }
        return null;
    }

    public QMMStatementInfo getStatement(DBCStatement statement) {
        QMMStatementInfo stat = this.statementStack;
        while (stat != null) {
            if (stat.getReference() == statement) {
                return stat;
            }
            stat = stat.getPrevious();
        }
        log.warn("Statement " + String.valueOf(statement) + " meta info not found");
        return null;
    }

    public QMMStatementExecuteInfo getExecution(DBCStatement statement) {
        QMMStatementExecuteInfo exec = this.executionStack;
        while (exec != null) {
            if (exec.getStatement().getReference() == statement) {
                return exec;
            }
            exec = exec.getPrevious();
        }
        return null;
    }

    public QMMStatementExecuteInfo beginExecution(DBCStatement statement) {
        QMMStatementInfo stat = this.getStatement(statement);
        if (stat != null) {
            String queryString = statement instanceof DBCParameterizedStatement ? ((DBCParameterizedStatement)statement).getFormattedQuery() : statement.getQueryString();
            QMMTransactionSavepointInfo savepoint = this.isTransactional() && this.getTransaction() != null ? this.getTransaction().getCurrentSavepoint() : null;
            SQLDialect sqlDialect = statement.getSession().getDataSource().getSQLDialect();
            String schema = null;
            String catalog = null;
            DBCExecutionContextDefaults contextDefaults = statement.getSession().getExecutionContext().getContextDefaults();
            if (contextDefaults != null) {
                DBCCachedContextDefaults cachedDefault = contextDefaults.getCachedDefault();
                schema = cachedDefault.schemaName();
                catalog = cachedDefault.catalogName();
            }
            this.executionStack = new QMMStatementExecuteInfo(stat, savepoint, queryString, this.executionStack, sqlDialect, schema, catalog);
            return this.executionStack;
        }
        return null;
    }

    public QMMStatementExecuteInfo endExecution(DBCStatement statement, long rowCount, Throwable error) {
        QMMStatementExecuteInfo exec = this.getExecution(statement);
        if (exec != null) {
            exec.close(rowCount, error);
        }
        return exec;
    }

    public QMMStatementExecuteInfo beginFetch(DBCResultSet resultSet) {
        QMMStatementExecuteInfo exec = this.getExecution(resultSet.getSourceStatement());
        if (exec == null) {
            exec = this.beginExecution(resultSet.getSourceStatement());
        }
        if (exec != null) {
            exec.beginFetch();
        }
        return exec;
    }

    public QMMStatementExecuteInfo endFetch(DBCResultSet resultSet, long rowCount) {
        QMMStatementExecuteInfo exec = this.getExecution(resultSet.getSourceStatement());
        if (exec != null) {
            exec.endFetch(rowCount);
        }
        return exec;
    }

    public QMMProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    @Override
    @NotNull
    public String getProjectId() {
        return this.projectInfo.getId();
    }

    @Override
    @NotNull
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    @Nullable
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    @NotNull
    public String getDriverId() {
        return this.driverId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getContextName() {
        return this.contextName;
    }

    public QMMStatementInfo getStatementStack() {
        return this.statementStack;
    }

    public QMMStatementExecuteInfo getExecutionStack() {
        return this.executionStack;
    }

    public QMMTransactionInfo getTransaction() {
        return this.transaction;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public String getConnectionUserName() {
        return this.connectionUserName;
    }

    @Override
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String toString() {
        return "SESSION " + this.containerName + " [" + this.contextName + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QMMConnectionInfo)) {
            return false;
        }
        QMMConnectionInfo si = (QMMConnectionInfo)obj;
        return CommonUtils.equalObjects((Object)this.containerId, (Object)si.containerId) && CommonUtils.equalObjects((Object)this.contextName, (Object)si.contextName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private QMMProjectInfo projectInfo;
        private String containerId;
        private String driverId;
        private String containerName;
        private String connectionUserName;
        private String connectionUrl;
        private String instanceId;
        private long openTime;
        private long closeTime;
        private String contextName;
        private boolean transactional;
        private QMMStatementInfo statementStack;
        private QMMStatementExecuteInfo executionStack;
        private QMMTransactionInfo transaction;

        public Builder setProjectInfo(QMMProjectInfo projectInfo) {
            this.projectInfo = projectInfo;
            return this;
        }

        public Builder setContainerId(String containerId) {
            this.containerId = containerId;
            return this;
        }

        public Builder setDriverId(String driverId) {
            this.driverId = driverId;
            return this;
        }

        public Builder setContainerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public Builder setConnectionUserName(String connectionUserName) {
            this.connectionUserName = connectionUserName;
            return this;
        }

        public Builder setConnectionUrl(String url) {
            this.connectionUrl = url;
            return this;
        }

        public Builder setInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder setOpenTime(long openTime) {
            this.openTime = openTime;
            return this;
        }

        public Builder setCloseTime(long closeTime) {
            this.closeTime = closeTime;
            return this;
        }

        public Builder setContextName(String contextName) {
            this.contextName = contextName;
            return this;
        }

        public Builder setTransactional(boolean transactional) {
            this.transactional = transactional;
            return this;
        }

        public Builder setStatementStack(QMMStatementInfo statementStack) {
            this.statementStack = statementStack;
            return this;
        }

        public Builder setExecutionStack(QMMStatementExecuteInfo executionStack) {
            this.executionStack = executionStack;
            return this;
        }

        public Builder setTransaction(QMMTransactionInfo transaction) {
            this.transaction = transaction;
            return this;
        }

        public QMMConnectionInfo build() {
            return new QMMConnectionInfo(this);
        }
    }
}

