/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.importer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.local.LocalStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferUtils;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferResultSet;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferUtils;
import org.jkiss.dbeaver.tools.transfer.stream.importer.StreamImporterAbstract;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;
import org.jkiss.utils.csv.CSVReader;
import org.jkiss.utils.io.BOMInputStream;

public class DataImporterCSV
extends StreamImporterAbstract {
    private static final Log log = Log.getLog(DataImporterCSV.class);
    private static final String PROP_ENCODING = "encoding";
    private static final String PROP_HEADER = "header";
    private static final String PROP_DELIMITER = "delimiter";
    private static final String PROP_QUOTE_CHAR = "quoteChar";
    private static final String PROP_NULL_STRING = "nullString";
    private static final String PROP_EMPTY_STRING_NULL = "emptyStringNull";
    private static final String PROP_ESCAPE_CHAR = "escapeChar";
    private static final String PROP_STRICT_QUOTES = "strictQuotes";
    private static final String PROP_TRIM_WHITESPACES = "trimWhitespaces";
    public static final int READ_BUFFER_SIZE = 261120;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public List<StreamDataImporterColumnInfo> readColumnsInfo(StreamEntityMapping entityMapping, @NotNull InputStream inputStream) throws DBException {
        ArrayList<StreamDataImporterColumnInfo> columnsInfo = new ArrayList<StreamDataImporterColumnInfo>();
        Map<String, Object> processorProperties = this.getSite().getProcessorProperties();
        HeaderPosition headerPosition = this.getHeaderPosition(processorProperties);
        String encoding = CommonUtils.toString((Object)processorProperties.get(PROP_ENCODING), (String)GeneralUtils.UTF8_ENCODING);
        int columnSamplesCount = Math.max(CommonUtils.toInt((Object)processorProperties.get("columnTypeSamplesCount"), (int)100), 0);
        int columnMinimalLength = Math.max(CommonUtils.toInt((Object)processorProperties.get("columnTypeMinimalLength"), (int)1), 1);
        boolean columnIsByteLength = CommonUtils.getBoolean((Object)processorProperties.get("columnTypeIsByteLength"), (boolean)false);
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (Reader reader = this.openStreamReader(inputStream, processorProperties, true);){
                Throwable throwable2 = null;
                Object var14_18 = null;
                try {
                    String[] header;
                    CSVReader csvReader;
                    block31: {
                        csvReader = this.openCSVReader(reader, processorProperties);
                        header = this.getNextLine(csvReader);
                        if (header != null) break block31;
                        ArrayList<StreamDataImporterColumnInfo> arrayList = columnsInfo;
                        if (csvReader == null) return arrayList;
                        csvReader.close();
                        return arrayList;
                    }
                    try {
                        int i = 0;
                        while (i < header.length) {
                            Object column = null;
                            if (headerPosition == HeaderPosition.top) {
                                column = DBUtils.getUnQuotedIdentifier((DBPDataSource)entityMapping.getDataSource(), (String)header[i]);
                            }
                            if (CommonUtils.isEmptyTrimmed(column)) {
                                column = "Column" + (i + 1);
                            }
                            StreamDataImporterColumnInfo columnInfo = new StreamDataImporterColumnInfo(entityMapping, i, (String)column, "String", columnMinimalLength, DBPDataKind.UNKNOWN);
                            columnInfo.setMappingMetadataPresent(headerPosition != HeaderPosition.none);
                            columnsInfo.add(columnInfo);
                            ++i;
                        }
                        int sample = 0;
                        while (sample < columnSamplesCount) {
                            String[] line;
                            if (sample == 0 && headerPosition == HeaderPosition.none) {
                                line = header;
                            } else {
                                line = this.getNextLine(csvReader);
                                if (line == null) break;
                            }
                            int i2 = 0;
                            while (i2 < Math.min(line.length, header.length)) {
                                Pair<DBPDataKind, String> dataType = DatabaseTransferUtils.getDataType(line[i2]);
                                StreamDataImporterColumnInfo columnInfo = (StreamDataImporterColumnInfo)((Object)columnsInfo.get(i2));
                                switch ((DBPDataKind)dataType.getFirst()) {
                                    case STRING: {
                                        columnInfo.updateMaxLength(entityMapping.getDataSource(), columnIsByteLength ? line[i2].getBytes(encoding).length : line[i2].length());
                                    }
                                    case BOOLEAN: 
                                    case NUMERIC: {
                                        columnInfo.updateType((DBPDataKind)dataType.getFirst(), (String)dataType.getSecond());
                                        break;
                                    }
                                }
                                ++i2;
                            }
                            ++sample;
                        }
                        for (StreamDataImporterColumnInfo columnInfo : columnsInfo) {
                            if (columnInfo.getDataKind() != DBPDataKind.UNKNOWN) continue;
                            log.debug((Object)("Cannot guess data type for column '" + columnInfo.getName() + "', defaulting to VARCHAR"));
                            columnInfo.updateType(DBPDataKind.STRING, "VARCHAR");
                        }
                        return columnsInfo;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                    finally {
                        if (csvReader != null) {
                            csvReader.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBException("IO error reading CSV", (Throwable)e);
        }
    }

    private int roundToNextPowerOf2(int value) {
        int power = 1;
        while (power < value) {
            power *= 2;
        }
        return power;
    }

    private HeaderPosition getHeaderPosition(Map<String, Object> processorProperties) {
        return (HeaderPosition)CommonUtils.valueOf(HeaderPosition.class, (String)CommonUtils.toString((Object)processorProperties.get(PROP_HEADER)), (Enum)HeaderPosition.top);
    }

    private CSVReader openCSVReader(Reader reader, Map<String, Object> processorProperties) {
        String escapeChar;
        String delimiter = StreamTransferUtils.getDelimiterString(processorProperties, PROP_DELIMITER);
        String quoteChar = CommonUtils.toString((Object)processorProperties.get(PROP_QUOTE_CHAR));
        if (CommonUtils.isEmpty((String)quoteChar)) {
            quoteChar = String.valueOf('\u0000');
        }
        if (CommonUtils.isEmpty((String)(escapeChar = CommonUtils.toString((Object)processorProperties.get(PROP_ESCAPE_CHAR))))) {
            escapeChar = String.valueOf('\u0000');
        }
        boolean strictQuotes = CommonUtils.toBoolean((Object)processorProperties.get(PROP_STRICT_QUOTES));
        return new CSVReader(reader, delimiter.charAt(0), quoteChar.charAt(0), escapeChar.charAt(0), 0, strictQuotes);
    }

    private Reader openStreamReader(InputStream inputStream, Map<String, Object> processorProperties, boolean useBufferedStream) throws UnsupportedEncodingException {
        String encoding = CommonUtils.toString((Object)processorProperties.get(PROP_ENCODING), (String)GeneralUtils.UTF8_ENCODING);
        Charset charset = Charset.forName(encoding);
        if (useBufferedStream) {
            inputStream = new BufferedInputStream(inputStream, 261120);
        }
        try {
            inputStream = new BOMInputStream(inputStream, charset);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return new InputStreamReader(inputStream, charset);
    }

    private String[] getNextLine(CSVReader csvReader) throws IOException {
        String[] line;
        do {
            if ((line = csvReader.readNext()) != null) continue;
            return null;
        } while (line.length == 0);
        return line;
    }

    @Override
    public void runImport(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource streamDataSource, @NotNull InputStream inputStream, @NotNull IDataTransferConsumer consumer) throws DBException {
        IStreamDataImporterSite site = this.getSite();
        StreamEntityMapping entityMapping = site.getSourceObject();
        Map<String, Object> properties = site.getProcessorProperties();
        HeaderPosition headerPosition = this.getHeaderPosition(properties);
        boolean emptyStringNull = CommonUtils.getBoolean((Object)properties.get(PROP_EMPTY_STRING_NULL), (boolean)false);
        boolean trimWhitespaces = CommonUtils.getBoolean((Object)properties.get(PROP_TRIM_WHITESPACES), (boolean)false);
        String nullValueMark = CommonUtils.toString((Object)properties.get(PROP_NULL_STRING));
        DBCExecutionContext context = streamDataSource.getDefaultInstance().getDefaultContext(monitor, false);
        Throwable throwable = null;
        Object var14_15 = null;
        try (DBCSession producerSession = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Transfer stream data");){
            LocalStatement localStatement = new LocalStatement(producerSession, "SELECT * FROM Stream");
            StreamTransferResultSet resultSet = new StreamTransferResultSet(producerSession, (DBCStatement)localStatement, entityMapping);
            consumer.fetchStart(producerSession, resultSet, -1L, -1L);
            this.applyTransformHints(resultSet, consumer, properties, "timestampFormat", "timestampZone");
            try {
                try {
                    Throwable throwable2 = null;
                    Object var19_23 = null;
                    try (Reader reader = this.openStreamReader(inputStream, properties, true);){
                        Throwable throwable3 = null;
                        Object var22_28 = null;
                        try (CSVReader csvReader = this.openCSVReader(reader, properties);){
                            int maxRows = site.getSettings().getMaxRows();
                            int targetAttrSize = entityMapping.getStreamColumns().size();
                            boolean headerRead = false;
                            long lineNum = 0L;
                            while (!monitor.isCanceled()) {
                                Object[] line = csvReader.readNext();
                                if (line == null) {
                                    if (csvReader.getParser().isPending()) {
                                        throw new IOException("Un-terminated quote sequence was detected");
                                    }
                                    break;
                                }
                                if (line.length == 0) continue;
                                if (headerPosition != HeaderPosition.none && !headerRead) {
                                    headerRead = true;
                                    continue;
                                }
                                if (maxRows > 0 && lineNum >= (long)maxRows) {
                                    break;
                                }
                                if (line.length < targetAttrSize) {
                                    String[] newLine = new String[targetAttrSize];
                                    System.arraycopy(line, 0, newLine, 0, line.length);
                                    int i = line.length;
                                    while (i < targetAttrSize) {
                                        newLine[i] = null;
                                        ++i;
                                    }
                                    line = newLine;
                                }
                                if (trimWhitespaces) {
                                    int i = 0;
                                    while (i < line.length) {
                                        line[i] = ((String)line[i]).trim();
                                        ++i;
                                    }
                                }
                                if (emptyStringNull) {
                                    int i = 0;
                                    while (i < line.length) {
                                        if ("".equals(line[i])) {
                                            line[i] = null;
                                        }
                                        ++i;
                                    }
                                }
                                if (!CommonUtils.isEmpty((String)nullValueMark)) {
                                    int i = 0;
                                    while (i < line.length) {
                                        if (nullValueMark.equals(line[i])) {
                                            line[i] = null;
                                        }
                                        ++i;
                                    }
                                }
                                resultSet.setStreamRow(line);
                                consumer.fetchRow(producerSession, resultSet);
                                if (!DBFetchProgress.monitorFetchProgress((long)(++lineNum))) continue;
                                monitor.subTask(Long.toUnsignedString(lineNum) + " rows processed");
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    throw new DBException("IO error reading CSV", (Throwable)e);
                }
            }
            finally {
                try {
                    consumer.fetchEnd(producerSession, resultSet);
                }
                finally {
                    consumer.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    public static enum HeaderPosition {
        none,
        top;

    }
}

