/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.BufferedImagePainter;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasKt;
import androidx.compose.ui.graphics.DesktopImageConverters_desktopKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.ImageBitmapKt;
import androidx.compose.ui.graphics.drawscope.CanvasDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.painter.BitmapPainter;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MultiResolutionImage;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0018\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0012\u0010+\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0015\u0010\u000fR\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Landroidx/compose/ui/graphics/PainterImage;", "Ljava/awt/Image;", "Ljava/awt/image/MultiResolutionImage;", "painter", "Landroidx/compose/ui/graphics/painter/Painter;", "density", "Landroidx/compose/ui/unit/Density;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "size", "Landroidx/compose/ui/geometry/Size;", "(Landroidx/compose/ui/graphics/painter/Painter;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/unit/LayoutDirection;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "defaultImage", "Ljava/awt/image/BufferedImage;", "getDefaultImage", "()Ljava/awt/image/BufferedImage;", "defaultImage$delegate", "Lkotlin/Lazy;", "height", "", "scaledImage", "getScaledImage", "scaledImage$delegate", "width", "asBitmap", "Landroidx/compose/ui/graphics/ImageBitmap;", "getGraphics", "Ljava/awt/Graphics;", "getHeight", "observer", "Ljava/awt/image/ImageObserver;", "getProperty", "", "name", "", "getResolutionVariant", "destImageWidth", "", "destImageHeight", "getResolutionVariants", "", "getSource", "Ljava/awt/image/ImageProducer;", "getWidth", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nDesktopImageConverters.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopImageConverters.desktop.kt\nandroidx/compose/ui/graphics/PainterImage\n+ 2 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 5 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 6 CanvasDrawScope.kt\nandroidx/compose/ui/graphics/drawscope/CanvasDrawScope\n*L\n1#1,266:1\n57#2:267\n61#2:270\n60#3:268\n70#3:271\n53#3,3:274\n22#4:269\n22#4:272\n33#5:273\n536#6,17:277\n*S KotlinDebug\n*F\n+ 1 DesktopImageConverters.desktop.kt\nandroidx/compose/ui/graphics/PainterImage\n*L\n137#1:267\n138#1:270\n137#1:268\n138#1:271\n162#1:274,3\n137#1:269\n138#1:272\n162#1:273\n164#1:277,17\n*E\n"})
final class PainterImage
extends Image
implements MultiResolutionImage {
    @NotNull
    private final Painter painter;
    @NotNull
    private final Density density;
    @NotNull
    private final LayoutDirection layoutDirection;
    private final int width;
    private final int height;
    @NotNull
    private final Lazy defaultImage$delegate;
    @NotNull
    private final Lazy scaledImage$delegate;

    private PainterImage(Painter painter, Density density, LayoutDirection layoutDirection, long size2) {
        Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        this.painter = painter;
        this.density = density;
        this.layoutDirection = layoutDirection;
        boolean bl = false;
        long value$iv$iv = size2;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        this.width = (int)Float.intBitsToFloat(bits$iv$iv$iv);
        boolean bl2 = false;
        value$iv$iv = size2;
        boolean $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        this.height = (int)Float.intBitsToFloat(bits$iv$iv$iv);
        this.defaultImage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BufferedImage>(this){
            final /* synthetic */ PainterImage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final BufferedImage invoke() {
                return PainterImage.access$getPainter$p(this.this$0) instanceof BufferedImagePainter ? ((BufferedImagePainter)PainterImage.access$getPainter$p(this.this$0)).getImage() : DesktopImageConverters_desktopKt.toAwtImage(PainterImage.access$asBitmap(this.this$0, PainterImage.access$getWidth$p(this.this$0), PainterImage.access$getHeight$p(this.this$0)));
            }
        }));
        this.scaledImage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BufferedImage>(this){
            final /* synthetic */ PainterImage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final BufferedImage invoke() {
                return DesktopImageConverters_desktopKt.toAwtImage(PainterImage.access$asBitmap(this.this$0, MathKt.roundToInt((float)((float)PainterImage.access$getWidth$p(this.this$0) * PainterImage.access$getDensity$p(this.this$0).getDensity())), MathKt.roundToInt((float)((float)PainterImage.access$getHeight$p(this.this$0) * PainterImage.access$getDensity$p(this.this$0).getDensity()))));
            }
        }));
    }

    @Override
    public int getWidth(@Nullable ImageObserver observer2) {
        return this.width;
    }

    @Override
    public int getHeight(@Nullable ImageObserver observer2) {
        return this.height;
    }

    @Override
    @NotNull
    public Image getResolutionVariant(double destImageWidth, double destImageHeight) {
        int width2 = (int)destImageWidth;
        int height2 = (int)destImageHeight;
        return this.painter instanceof BufferedImagePainter && ((BufferedImagePainter)this.painter).getImage().getWidth() == width2 && ((BufferedImagePainter)this.painter).getImage().getHeight() == height2 ? (Image)((BufferedImagePainter)this.painter).getImage() : (Image)DesktopImageConverters_desktopKt.toAwtImage(this.asBitmap(width2, height2));
    }

    /*
     * WARNING - void declaration
     */
    private final ImageBitmap asBitmap(int width2, int height2) {
        void layoutDirection$iv;
        void density$iv;
        CanvasDrawScope.DrawParams drawParams;
        void this_$iv;
        void width$iv22;
        ImageBitmap bitmap2 = ImageBitmapKt.ImageBitmap-x__-hDU$default(width2, height2, 0, false, null, 28, null);
        Canvas canvas = CanvasKt.Canvas(bitmap2);
        float f = width2;
        float height$iv22 = height2;
        boolean $i$f$Size22 = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)width$iv22);
        long v2$iv$iv = Float.floatToRawIntBits(height$iv22);
        long floatSize = Size.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
        CanvasDrawScope width$iv22 = new CanvasDrawScope();
        Density height$iv22 = this.density;
        LayoutDirection $i$f$Size22 = this.layoutDirection;
        boolean bl = false;
        CanvasDrawScope.DrawParams drawParams2 = this_$iv.getDrawParams();
        Density prevDensity$iv = drawParams2.component1();
        LayoutDirection prevLayoutDirection$iv = drawParams2.component2();
        Canvas prevCanvas$iv = drawParams2.component3();
        long prevSize$iv = drawParams2.component4-NH-jbRc();
        CanvasDrawScope.DrawParams $this$draw_yzxVdVo_u24lambda_u240$iv = drawParams = this_$iv.getDrawParams();
        boolean bl2 = false;
        $this$draw_yzxVdVo_u24lambda_u240$iv.setDensity((Density)density$iv);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setLayoutDirection((LayoutDirection)layoutDirection$iv);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setCanvas(canvas);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setSize-uvyYCjk(floatSize);
        canvas.save();
        DrawScope $this$asBitmap_u24lambda_u241 = (DrawScope)this_$iv;
        boolean bl3 = false;
        Painter $this$asBitmap_u24lambda_u241_u24lambda_u240 = this.painter;
        boolean bl4 = false;
        Painter.draw-x_KDEd0$default($this$asBitmap_u24lambda_u241_u24lambda_u240, $this$asBitmap_u24lambda_u241, floatSize, 0.0f, null, 6, null);
        canvas.restore();
        CanvasDrawScope.DrawParams $this$draw_yzxVdVo_u24lambda_u241$iv = drawParams = this_$iv.getDrawParams();
        boolean bl5 = false;
        $this$draw_yzxVdVo_u24lambda_u241$iv.setDensity(prevDensity$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setLayoutDirection(prevLayoutDirection$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setCanvas(prevCanvas$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setSize-uvyYCjk(prevSize$iv);
        return bitmap2;
    }

    @Override
    @NotNull
    public Object getProperty(@NotNull String name, @Nullable ImageObserver observer2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = Image.UndefinedProperty;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"UndefinedProperty");
        return object;
    }

    @Override
    @NotNull
    public ImageProducer getSource() {
        ImageProducer imageProducer = this.getDefaultImage().getSource();
        Intrinsics.checkNotNullExpressionValue((Object)imageProducer, (String)"getSource(...)");
        return imageProducer;
    }

    @Override
    @NotNull
    public Graphics getGraphics() {
        Graphics graphics = this.getDefaultImage().getGraphics();
        Intrinsics.checkNotNullExpressionValue((Object)graphics, (String)"getGraphics(...)");
        return graphics;
    }

    private final BufferedImage getDefaultImage() {
        Lazy lazy = this.defaultImage$delegate;
        return (BufferedImage)lazy.getValue();
    }

    private final BufferedImage getScaledImage() {
        Lazy lazy = this.scaledImage$delegate;
        return (BufferedImage)lazy.getValue();
    }

    @NotNull
    public List<BufferedImage> getResolutionVariants() {
        List list2;
        Painter painter = this.painter;
        if (painter instanceof BufferedImagePainter ? true : painter instanceof BitmapPainter) {
            list2 = CollectionsKt.listOf((Object)this.getDefaultImage());
        } else {
            Object[] objectArray = new BufferedImage[]{this.getDefaultImage(), this.getScaledImage()};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        return list2;
    }

    public /* synthetic */ PainterImage(Painter painter, Density density, LayoutDirection layoutDirection, long size2, DefaultConstructorMarker $constructor_marker) {
        this(painter, density, layoutDirection, size2);
    }

    public static final /* synthetic */ Painter access$getPainter$p(PainterImage $this) {
        return $this.painter;
    }

    public static final /* synthetic */ ImageBitmap access$asBitmap(PainterImage $this, int width2, int height2) {
        return $this.asBitmap(width2, height2);
    }

    public static final /* synthetic */ int access$getWidth$p(PainterImage $this) {
        return $this.width;
    }

    public static final /* synthetic */ int access$getHeight$p(PainterImage $this) {
        return $this.height;
    }

    public static final /* synthetic */ Density access$getDensity$p(PainterImage $this) {
        return $this.density;
    }
}

