/* ipdbase.h
 *
 * database output for ipaudit
 * By Jon Rifkin <jon.rifkin@uconn.edu>
 * Copyright 1999-2005 Jonathan Rifkin
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


#ifndef _IPDBASE_H
#define _IPDBASE_H

/*
------------------------------------------------------------------------
Inlucde files
------------------------------------------------------------------------
*/
#include <time.h>
#include "hash.h"

/*
------------------------------------------------------------------------
Exported Functions
------------------------------------------------------------------------
*/

/*
Retrieve and print packets from hash table in bin format
*/
void bin_writepkt   (htable_t *ht, char *outname);
void txt_writepkt   (htable_t *ht, char *outname);
void sql_writepkt   (htable_t *ht, char *outname);
int in_iprange      (int ip, int *iplist, int niplist);
int cmp_local_score (int ip1, int ip2, int *iplist, int niplist);
void mysql_writepkt (htable_t *ht, char mysql_config[NUM_MYSQL_OPTIONS][MYSQL_OPTION_LEN]);
struct tm *gettime  (const time_t *timep);

#endif
