include(LibFindMacros)

libfind_pkg_check_modules(LIBSHARPYUV_PKGCONF libsharpyuv)

find_path(LIBSHARPYUV_INCLUDE_DIR
    NAMES sharpyuv/sharpyuv.h
    HINTS ${LIBSHARPYUV_PKGCONF_INCLUDE_DIRS} ${LIBSHARPYUV_PKGCONF_INCLUDEDIR}
    PATH_SUFFIXES LIBSHARPYUV
)

find_library(LIBSHARPYUV_LIBRARY
    NAMES sharpyuv
    HINTS ${LIBSHARPYUV_PKGCONF_LIBRARY_DIRS} ${LIBSHARPYUV_PKGCONF_LIBDIR}
)

set(LIBSHARPYUV_PROCESS_LIBS LIBSHARPYUV_LIBRARY)
set(LIBSHARPYUV_PROCESS_INCLUDES LIBSHARPYUV_INCLUDE_DIR)
libfind_process(LIBSHARPYUV)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(libsharpyuv
    REQUIRED_VARS
        LIBSHARPYUV_INCLUDE_DIR
        LIBSHARPYUV_LIBRARIES
)
