"use strict";
// Copyright 2021-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNonEditionRuntime = void 0;
/**
 * Temporary function to retrieve the import symbol for the proto2 or proto3
 * runtime.
 *
 * For syntax "editions", this function raises and error.
 *
 * Once support for "editions" is implemented in the runtime, this function can
 * be removed.
 */
function getNonEditionRuntime(schema, file) {
    var _a;
    if (file.syntax === "editions") {
        // TODO support editions
        throw new Error(`${(_a = file.proto.name) !== null && _a !== void 0 ? _a : ""}: syntax "editions" is not supported yet`);
    }
    return schema.runtime[file.syntax];
}
exports.getNonEditionRuntime = getNonEditionRuntime;
