require File.expand_path('../../../test_helper', __FILE__)

require 'mocha/parameter_matchers/all_of'
require 'mocha/inspect'
require 'stub_matcher'
require 'parameter_matchers_test_helper'

class AllOfTest < Mocha::TestCase
  include Mocha::ParameterMatchers::Methods

  def test_should_match_if_all_matchers_match
    matcher = all_of(Stub::Matcher.new(true), Stub::Matcher.new(true), Stub::Matcher.new(true))
    assert matcher.matches?(['any_old_value'])
  end

  def test_should_not_match_if_any_matcher_does_not_match
    matcher = all_of(Stub::Matcher.new(true), Stub::Matcher.new(false), Stub::Matcher.new(true))
    assert !matcher.matches?(['any_old_value'])
  end

  def test_should_describe_matcher
    matcher = all_of(Stub::Matcher.new(true), Stub::Matcher.new(false), Stub::Matcher.new(true))
    assert_equal 'all_of(matcher(true), matcher(false), matcher(true))', matcher.mocha_inspect
  end

  include ParameterMatchersTestHelper.deprecation_tests_for_matcher_method(:all_of)
  include ParameterMatchersTestHelper.deprecation_tests_for_matcher_class(:AllOf)
end
