/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPRegistryDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.stream.IAppendableDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IMultiStreamDataImporter;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataTransferProcessorDescriptor
extends AbstractDescriptor
implements DBPRegistryDescriptor<IDataTransferProcessor> {
    private final DataTransferNodeDescriptor node;
    private final String id;
    private final AbstractDescriptor.ObjectType processorType;
    private final List<AbstractDescriptor.ObjectType> sourceTypes = new ArrayList<AbstractDescriptor.ObjectType>();
    private final String name;
    private final String description;
    private final String contentType;
    private final String appFileExtension;
    private final String appName;
    private final int order;
    @NotNull
    private final DBPImage icon;
    private final DBPPropertyDescriptor[] properties;
    private final boolean isBinary;
    private final boolean isHTML;

    DataTransferProcessorDescriptor(@NotNull DataTransferNodeDescriptor node, @NotNull IConfigurationElement config) {
        super(config);
        this.node = node;
        this.id = config.getAttribute("id");
        this.processorType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"), (DBPImage)DBIcon.TYPE_UNKNOWN);
        this.isBinary = CommonUtils.getBoolean((String)config.getAttribute("binary"), (boolean)false);
        this.isHTML = CommonUtils.getBoolean((String)config.getAttribute("html"), (boolean)false);
        this.contentType = CommonUtils.toString((Object)config.getAttribute("contentType"), (String)"application/octet-stream");
        this.appFileExtension = config.getAttribute("appFileExtension");
        this.appName = config.getAttribute("appName");
        this.order = CommonUtils.toInt((Object)config.getAttribute("order"));
        for (IConfigurationElement typeCfg : ArrayUtils.safeArray((Object[])config.getChildren("sourceType"))) {
            this.sourceTypes.add(new AbstractDescriptor.ObjectType((AbstractDescriptor)this, typeCfg.getAttribute("type")));
        }
        this.properties = PropertyDescriptor.extractPropertyGroups((IConfigurationElement)config);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Nullable
    public String getAppFileExtension() {
        return this.appFileExtension;
    }

    @Nullable
    public String getAppName() {
        return this.appName;
    }

    public int getOrder() {
        return this.order;
    }

    @NotNull
    public DBPImage getIcon() {
        return this.icon;
    }

    @NotNull
    public DBPPropertyDescriptor[] getProperties() {
        return this.properties;
    }

    @Nullable
    public DBPPropertyDescriptor getProperty(@NotNull String name) {
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = this.properties;
        int n = this.properties.length;
        int n2 = 0;
        while (n2 < n) {
            DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
            if (prop.getId().equals(name)) {
                return prop;
            }
            ++n2;
        }
        return null;
    }

    boolean appliesToType(@NotNull Class<?> objectType) {
        if (this.sourceTypes.isEmpty()) {
            return true;
        }
        for (AbstractDescriptor.ObjectType sourceType : this.sourceTypes) {
            if (!sourceType.matchesType(objectType)) continue;
            return true;
        }
        return false;
    }

    public boolean adaptsToType(@NotNull IAdaptable adaptable) {
        if (this.sourceTypes.isEmpty()) {
            return true;
        }
        for (AbstractDescriptor.ObjectType sourceType : this.sourceTypes) {
            if (adaptable.getAdapter(sourceType.getObjectClass()) == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public IDataTransferProcessor getInstance() {
        try {
            this.processorType.checkObjectClass(IDataTransferProcessor.class);
            Class clazz = this.processorType.getImplClass(IDataTransferProcessor.class);
            return (IDataTransferProcessor)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't instantiate data exporter", e);
        }
    }

    @NotNull
    public DataTransferNodeDescriptor getNode() {
        return this.node;
    }

    public boolean isBinaryFormat() {
        return this.isBinary;
    }

    public boolean isHTMLFormat() {
        return this.isHTML;
    }

    public boolean isAppendable() {
        return this.processorType.matchesType(IAppendableDataExporter.class);
    }

    public boolean isMulti() {
        return this.processorType.matchesType(IMultiStreamDataImporter.class);
    }

    public String getFullId() {
        return this.node.getId() + ":" + this.getId();
    }

    @NotNull
    public String getProcessorFileExtension() {
        DBPPropertyDescriptor extProperty = this.getProperty("extension");
        String ext = extProperty == null ? this.getAppFileExtension() : CommonUtils.toString((Object)extProperty.getDefaultValue(), null);
        return CommonUtils.isEmpty((String)ext) ? "data" : ext;
    }

    public String toString() {
        return this.getFullId();
    }
}

