/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.nativetool;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DatabaseURL;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public abstract class NativeToolUtils {
    private static final Log log = Log.getLog(NativeToolUtils.class);
    public static final String VARIABLE_HOST = "host";
    public static final String VARIABLE_DATABASE = "database";
    public static final String VARIABLE_SCHEMA = "schema";
    public static final String VARIABLE_TABLE = "table";
    public static final String VARIABLE_DATE = "date";
    public static final String VARIABLE_TIMESTAMP = "timestamp";
    public static final String VARIABLE_YEAR = "year";
    public static final String VARIABLE_MONTH = "month";
    public static final String VARIABLE_DAY = "day";
    public static final String VARIABLE_HOUR = "hour";
    public static final String VARIABLE_MINUTE = "minute";
    public static final String VARIABLE_CONN_TYPE = "connection.type";
    public static final String[] ALL_VARIABLES = new String[]{"host", "database", "schema", "table", "date", "timestamp", "year", "month", "day", "hour", "minute", "connection.type"};
    public static final String[] LIMITED_VARIABLES = new String[]{"host", "database", "date", "timestamp", "year", "month", "day", "hour", "minute", "connection.type"};

    public static boolean isSecureString(AbstractNativeToolSettings settings, String string) {
        String userPassword = settings.getDataSourceContainer().getActualConnectionConfiguration().getUserPassword();
        String toolUserPassword = settings.getToolUserPassword();
        return !CommonUtils.isEmpty((String)toolUserPassword) && string.endsWith(toolUserPassword) || !CommonUtils.isEmpty((String)userPassword) && string.endsWith(userPassword);
    }

    @NotNull
    public static String replaceVariables(@NotNull String name) {
        switch (name) {
            case "date": {
                return RuntimeUtils.getCurrentDate();
            }
            case "year": {
                return new SimpleDateFormat("yyyy").format(new Date());
            }
            case "month": {
                return new SimpleDateFormat("MM").format(new Date());
            }
            case "day": {
                return new SimpleDateFormat("dd").format(new Date());
            }
            case "hour": {
                return new SimpleDateFormat("HH").format(new Date());
            }
            case "minute": {
                return new SimpleDateFormat("mm").format(new Date());
            }
        }
        return System.getProperty(name);
    }

    public static void addHostAndPortParamsToCmd(@NotNull DBPDataSourceContainer dataSourceContainer, @NotNull List<String> cmd) {
        DBPConnectionConfiguration connectionInfo = dataSourceContainer.getActualConnectionConfiguration();
        String hostname = "";
        String port = "";
        if (connectionInfo.getConfigurationType().equals((Object)DBPDriverConfigurationType.MANUAL)) {
            hostname = connectionInfo.getHostName();
            port = connectionInfo.getHostPort();
        } else {
            String url = connectionInfo.getUrl();
            String sampleUrl = dataSourceContainer.getDriver().getSampleURL();
            if (sampleUrl != null) {
                DBPConnectionConfiguration config = DatabaseURL.extractConfigurationFromUrl((String)sampleUrl, (String)url);
                if (config != null) {
                    hostname = config.getHostName();
                    port = config.getHostPort();
                }
            } else {
                try {
                    URI uri = URI.create(url);
                    hostname = uri.getHost();
                    port = String.valueOf(uri.getPort());
                }
                catch (Exception e) {
                    log.error((Object)"Can't parse connection URL", (Throwable)e);
                }
            }
        }
        cmd.add("--host=" + hostname);
        if (!CommonUtils.isEmpty((String)port)) {
            cmd.add("--port=" + port);
        }
    }
}

