//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern_protocol!(
    /// This protocol represents the sender of an
    /// authentication challenge. It has methods to provide a credential,
    /// to continue without any credential, getting whatever failure
    /// result would happen in that case, cancel a challenge, perform the default
    /// action as defined by the system, or reject the currently supplied protection-space
    /// in the challenge.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlauthenticationchallengesender?language=objc)
    pub unsafe trait NSURLAuthenticationChallengeSender:
        NSObjectProtocol + Send + Sync
    {
        #[cfg(feature = "NSURLCredential")]
        #[unsafe(method(useCredential:forAuthenticationChallenge:))]
        #[unsafe(method_family = none)]
        fn useCredential_forAuthenticationChallenge(
            &self,
            credential: &NSURLCredential,
            challenge: &NSURLAuthenticationChallenge,
        );

        #[unsafe(method(continueWithoutCredentialForAuthenticationChallenge:))]
        #[unsafe(method_family = none)]
        fn continueWithoutCredentialForAuthenticationChallenge(
            &self,
            challenge: &NSURLAuthenticationChallenge,
        );

        #[unsafe(method(cancelAuthenticationChallenge:))]
        #[unsafe(method_family = none)]
        fn cancelAuthenticationChallenge(&self, challenge: &NSURLAuthenticationChallenge);

        #[optional]
        #[unsafe(method(performDefaultHandlingForAuthenticationChallenge:))]
        #[unsafe(method_family = none)]
        fn performDefaultHandlingForAuthenticationChallenge(
            &self,
            challenge: &NSURLAuthenticationChallenge,
        );

        #[optional]
        #[unsafe(method(rejectProtectionSpaceAndContinueWithChallenge:))]
        #[unsafe(method_family = none)]
        fn rejectProtectionSpaceAndContinueWithChallenge(
            &self,
            challenge: &NSURLAuthenticationChallenge,
        );
    }
);

extern_class!(
    /// This class represents an authentication challenge. It
    /// provides all the information about the challenge, and has a method
    /// to indicate when it's done.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlauthenticationchallenge?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLAuthenticationChallenge;
);

unsafe impl Send for NSURLAuthenticationChallenge {}

unsafe impl Sync for NSURLAuthenticationChallenge {}

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCoding for NSURLAuthenticationChallenge {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSURLAuthenticationChallenge {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSURLAuthenticationChallenge {}
);

impl NSURLAuthenticationChallenge {
    extern_methods!(
        #[cfg(all(
            feature = "NSError",
            feature = "NSURLCredential",
            feature = "NSURLProtectionSpace",
            feature = "NSURLResponse"
        ))]
        /// Initialize an authentication challenge
        ///
        /// Parameter `space`: The NSURLProtectionSpace to use
        ///
        /// Parameter `credential`: The proposed NSURLCredential for this challenge, or nil
        ///
        /// Parameter `previousFailureCount`: A count of previous failures attempting access.
        ///
        /// Parameter `response`: The NSURLResponse for the authentication failure, if applicable, else nil
        ///
        /// Parameter `error`: The NSError for the authentication failure, if applicable, else nil
        ///
        /// Returns: An authentication challenge initialized with the specified parameters
        #[unsafe(method(initWithProtectionSpace:proposedCredential:previousFailureCount:failureResponse:error:sender:))]
        #[unsafe(method_family = init)]
        pub fn initWithProtectionSpace_proposedCredential_previousFailureCount_failureResponse_error_sender(
            this: Allocated<Self>,
            space: &NSURLProtectionSpace,
            credential: Option<&NSURLCredential>,
            previous_failure_count: NSInteger,
            response: Option<&NSURLResponse>,
            error: Option<&NSError>,
            sender: &ProtocolObject<dyn NSURLAuthenticationChallengeSender>,
        ) -> Retained<Self>;

        /// Initialize an authentication challenge copying all parameters from another one.
        ///
        /// Returns: A new challenge initialized with the parameters from the passed in challenge
        ///
        /// This initializer may be useful to subclassers that want to proxy
        /// one type of authentication challenge to look like another type.
        #[unsafe(method(initWithAuthenticationChallenge:sender:))]
        #[unsafe(method_family = init)]
        pub fn initWithAuthenticationChallenge_sender(
            this: Allocated<Self>,
            challenge: &NSURLAuthenticationChallenge,
            sender: &ProtocolObject<dyn NSURLAuthenticationChallengeSender>,
        ) -> Retained<Self>;

        #[cfg(feature = "NSURLProtectionSpace")]
        /// Get a description of the protection space that requires authentication
        ///
        /// Returns: The protection space that needs authentication
        #[unsafe(method(protectionSpace))]
        #[unsafe(method_family = none)]
        pub fn protectionSpace(&self) -> Retained<NSURLProtectionSpace>;

        #[cfg(feature = "NSURLCredential")]
        /// Get the proposed credential for this challenge
        ///
        /// Returns: The proposed credential
        ///
        /// proposedCredential may be nil, if there is no default
        /// credential to use for this challenge (either stored or in the
        /// URL). If the credential is not nil and returns YES for
        /// hasPassword, this means the NSURLConnection thinks the credential
        /// is ready to use as-is. If it returns NO for hasPassword, then the
        /// credential is not ready to use as-is, but provides a default
        /// username the client could use when prompting.
        #[unsafe(method(proposedCredential))]
        #[unsafe(method_family = none)]
        pub fn proposedCredential(&self) -> Option<Retained<NSURLCredential>>;

        /// Get count of previous failed authentication attempts
        ///
        /// Returns: The count of previous failures
        #[unsafe(method(previousFailureCount))]
        #[unsafe(method_family = none)]
        pub fn previousFailureCount(&self) -> NSInteger;

        #[cfg(feature = "NSURLResponse")]
        /// Get the response representing authentication failure.
        ///
        /// Returns: The failure response or nil
        ///
        /// If there was a previous authentication failure, and
        /// this protocol uses responses to indicate authentication failure,
        /// then this method will return the response. Otherwise it will
        /// return nil.
        #[unsafe(method(failureResponse))]
        #[unsafe(method_family = none)]
        pub fn failureResponse(&self) -> Option<Retained<NSURLResponse>>;

        #[cfg(feature = "NSError")]
        /// Get the error representing authentication failure.
        ///
        /// If there was a previous authentication failure, and
        /// this protocol uses errors to indicate authentication failure,
        /// then this method will return the error. Otherwise it will
        /// return nil.
        #[unsafe(method(error))]
        #[unsafe(method_family = none)]
        pub fn error(&self) -> Option<Retained<NSError>>;

        /// Get the sender of this challenge
        ///
        /// Returns: The sender of the challenge
        ///
        /// The sender is the object you should reply to when done processing the challenge.
        #[unsafe(method(sender))]
        #[unsafe(method_family = none)]
        pub fn sender(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSURLAuthenticationChallengeSender>>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSURLAuthenticationChallenge {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSURLAuthenticationChallenge {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}
