#!/usr/bin/env python
#
# PARTIO SOFTWARE
# Copyright 2010 Disney Enterprises, Inc. All rights reserved
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
# * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
# 
# * Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in
# the documentation and/or other materials provided with the
# distribution.
# 
# * The names "Disney", "Walt Disney Pictures", "Walt Disney Animation
# Studios" or the names of its contributors may NOT be used to
# endorse or promote products derived from this software without
# specific prior written permission from Walt Disney Pictures.
# 
# Disclaimer: THIS SOFTWARE IS PROVIDED BY WALT DISNEY PICTURES AND
# CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, NONINFRINGEMENT AND TITLE ARE DISCLAIMED.
# IN NO EVENT SHALL WALT DISNEY PICTURES, THE COPYRIGHT HOLDER OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND BASED ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

import partio

# create a particle set and attributes
p=partio.create()
position=p.addAttribute("position",partio.VECTOR,3)
color=p.addAttribute("Cd",partio.FLOAT,3)
radius=p.addAttribute("radius",partio.FLOAT,1)
normal=p.addAttribute("normal",partio.VECTOR,3)

# make a spiral circle thingy
t=0
dt=.01
import math

while t<2*math.pi:
    # allocate new particle
    i=p.addParticle()

    # set particle attributes
    r=.25*math.sin(10*t)+1.
    x,y,z=-r*math.sin(t),0,r*math.cos(t)

    p.set(position,i,(x,y,z))
    p.set(color,i,(t/2./math.pi,1-(t/2./math.pi),0))
    p.set(radius,i,(.02,))
    p.set(normal,i,(0,1,0))
    foo=p.get(position,i)

    t+=dt

# Write to a point cloud
partio.write("spiral.ptc",p)
