/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.input.dtd;

import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import com.thaiopensource.resolver.xml.ExternalEntityIdentifier;
import com.thaiopensource.xml.em.EntityManager;
import com.thaiopensource.xml.em.ExternalId;
import com.thaiopensource.xml.em.OpenEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class ResolverEntityManager
extends EntityManager {
    private final Resolver resolver;

    public ResolverEntityManager(Resolver resolver) {
        this.resolver = resolver;
    }

    public OpenEntity open(String string) throws IOException {
        Input input = new Input();
        input.setUri(string);
        try {
            return this.open(input);
        }
        catch (ResolverException resolverException) {
            throw ResolverEntityManager.toIOException(resolverException);
        }
    }

    public OpenEntity open(ExternalId externalId, boolean bl, String string) throws IOException {
        Input input = new Input();
        if (bl) {
            string = "%" + string;
        }
        try {
            this.resolver.resolve(new ExternalEntityIdentifier(externalId.getSystemId(), externalId.getBaseUri(), externalId.getPublicId(), string), input);
            return this.open(input);
        }
        catch (ResolverException resolverException) {
            throw ResolverEntityManager.toIOException(resolverException);
        }
    }

    private OpenEntity open(Input input) throws ResolverException, IOException {
        this.resolver.open(input);
        if (!input.isOpen()) {
            throw new ResolverException("could not open input");
        }
        Reader reader = input.getCharacterStream();
        String string = input.getEncoding();
        String string2 = input.getUri();
        if (reader != null) {
            if (string == null) {
                string = "UTF-8";
            }
            return new OpenEntity(reader, string2, string2, string);
        }
        InputStream inputStream = input.getByteStream();
        if (string != null) {
            return new OpenEntity(new InputStreamReader(inputStream, string), string2, string2, string);
        }
        return this.detectEncoding(inputStream, string2);
    }

    private static IOException toIOException(ResolverException resolverException) {
        String string = resolverException.getMessage();
        Throwable throwable = resolverException.getCause();
        if (string == null) {
            if (throwable instanceof IOException) {
                return (IOException)throwable;
            }
            return new IOException(throwable.getMessage());
        }
        return new IOException(string);
    }
}

