/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.base.psi.SqlFunctionBodyInjector;
import com.intellij.sql.dialects.cassandra.CassTypes;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CassFunctionBodyInjector
extends SqlFunctionBodyInjector {
    protected boolean canApply(PsiElement context) {
        return context instanceof SqlStringLiteralExpression && SqlImplUtil.getSqlDialectSafe((PsiElement)context).getDbms().isCassandra();
    }

    @Nullable
    protected Pair<Language, String> calcBodyLanguage(@NotNull PsiElement context) {
        SqlStringLiteralExpression stringLiteral;
        SqlCreateFunctionStatementImpl statement2;
        if (context == null) {
            CassFunctionBodyInjector.$$$reportNull$$$0(0);
        }
        if ((statement2 = (SqlCreateFunctionStatementImpl)PsiTreeUtil.getParentOfType((PsiElement)(stringLiteral = (SqlStringLiteralExpression)context), SqlCreateFunctionStatementImpl.class)) == null) {
            return null;
        }
        List clauses = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)statement2, SqlClause.class);
        for (SqlClause clause : clauses) {
            PsiElement child = clause.getFirstChild();
            if (child == null || child.getNode().getElementType() != CassTypes.CASS_LANGUAGE) continue;
            for (PsiElement e = child.getNextSibling(); e != null; e = e.getNextSibling()) {
                IElementType type = PsiUtilCore.getElementType((PsiElement)e);
                if (type != SqlTokens.SQL_IDENT && !(type instanceof SqlIdentifierKeywordTokenType)) continue;
                return this.getLangBySpec(e.getText(), context);
            }
            return null;
        }
        return null;
    }

    @Nullable
    protected Pair<String, String> getPrefixSuffix(@NotNull Language language, @NotNull PsiElement context) {
        if (language == null) {
            CassFunctionBodyInjector.$$$reportNull$$$0(1);
        }
        if (context == null) {
            CassFunctionBodyInjector.$$$reportNull$$$0(2);
        }
        String prefix = "";
        String suffix = "";
        if (language.getID().equals("JAVA")) {
            prefix = "public class MyClass { public static Object main() { ";
            suffix = "} }";
        }
        return new Pair((Object)prefix, (Object)suffix);
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<SqlStringLiteralExpressionImpl>> list = Collections.singletonList(SqlStringLiteralExpressionImpl.class);
        if (list == null) {
            CassFunctionBodyInjector.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/cassandra/psi/CassFunctionBodyInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/cassandra/psi/CassFunctionBodyInjector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcBodyLanguage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixSuffix";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

