/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.usageView.UsageViewTypeLocation;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlElementDescriptionProvider
implements ElementDescriptionProvider {
    @Nullable
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        if (element == null) {
            SqlElementDescriptionProvider.$$$reportNull$$$0(0);
        }
        if (location == null) {
            SqlElementDescriptionProvider.$$$reportNull$$$0(1);
        }
        if (location != UsageViewTypeLocation.INSTANCE) {
            return null;
        }
        if (element instanceof SqlDefinition) {
            return SqlElementDescriptionProvider.getKindName((SqlDefinition)element);
        }
        if (element instanceof SqlReferenceExpression) {
            return SqlElementDescriptionProvider.getKindName((SqlReferenceExpression)element);
        }
        if (SqlImplUtil.unwrapPsiToObject((PsiElement)element) instanceof BuiltinFunction) {
            return DbPresentationCore.getPresentableName((ObjectKind)ObjectKind.ROUTINE, (Dbms)Dbms.UNKNOWN);
        }
        return null;
    }

    @Nls
    @NotNull
    public static String getKindName(SqlDefinition e) {
        Dbms dbms = SqlImplUtil.getSqlDialectSafe((PsiElement)e).getDbms();
        String string = DbPresentationCore.getPresentableName((ObjectKind)e.getKind(), (Dbms)dbms);
        if (string == null) {
            SqlElementDescriptionProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String getKindName(SqlReferenceExpression e) {
        Dbms dbms = SqlImplUtil.getSqlDialectSafe((PsiElement)e).getDbms();
        String string = DbPresentationCore.getPresentableName((ObjectKind)e.getKind(), (Dbms)dbms);
        if (string == null) {
            SqlElementDescriptionProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlElementDescriptionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlElementDescriptionProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementDescription";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

