/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.projectModel.uv;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.externalSystem.importing.AbstractOpenProjectProvider;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.jetbrains.python.projectModel.uv.UvConstants;
import com.jetbrains.python.projectModel.uv.UvProjectModelService;
import com.jetbrains.python.projectModel.uv.UvSettings;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0094@\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/python/projectModel/uv/UvProjectOpenProvider;", "Lcom/intellij/openapi/externalSystem/importing/AbstractOpenProjectProvider;", "<init>", "()V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "isProjectFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isUvSpecificPyProjectToml", "linkProject", "", "projectFile", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "unlinkProject", "externalProjectPath", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nUvProjectOpenProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UvProjectOpenProvider.kt\ncom/jetbrains/python/projectModel/uv/UvProjectOpenProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,39:1\n30#2,2:40\n*S KotlinDebug\n*F\n+ 1 UvProjectOpenProvider.kt\ncom/jetbrains/python/projectModel/uv/UvProjectOpenProvider\n*L\n27#1:40,2\n*E\n"})
public final class UvProjectOpenProvider
extends AbstractOpenProjectProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectSystemId systemId = UvConstants.INSTANCE.getSYSTEM_ID();
    @NotNull
    private static final Regex UV_TOOL_TABLE_HEADER = new Regex("\\[tool\\.uv[.\\w-]*]");

    @NotNull
    public ProjectSystemId getSystemId() {
        return this.systemId;
    }

    protected boolean isProjectFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getName(), (Object)"uv.lock") || this.isUvSpecificPyProjectToml(file);
    }

    private final boolean isUvSpecificPyProjectToml(VirtualFile file) {
        return Intrinsics.areEqual((Object)file.getName(), (Object)"pyproject.toml") && Regex.find$default((Regex)UV_TOOL_TABLE_HEADER, (CharSequence)VirtualFileUtil.readText((VirtualFile)file), (int)0, (int)2, null) != null;
    }

    @Nullable
    protected Object linkProject(@NotNull VirtualFile projectFile, @NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        VirtualFile projectDirectory = this.getProjectDirectory(projectFile);
        Path path2 = VirtualFileUtil.toNioPathOrNull((VirtualFile)projectDirectory);
        if (path2 == null) {
            path2 = Path.of(projectDirectory.getPath(), new String[0]);
        }
        Path projectRootPath = path2;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<UvSettings> serviceClass$iv = UvSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        UvSettings uvSettings = (UvSettings)object;
        Intrinsics.checkNotNull((Object)projectRootPath);
        uvSettings.addLinkedProject(projectRootPath);
        Object object2 = UvProjectModelService.INSTANCE.syncProjectModelRoot(project, projectRootPath, $completion);
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object2;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object unlinkProject(@NotNull Project project, @NotNull String externalProjectPath, @NotNull Continuation<? super Unit> $completion) {
        Path path2 = Path.of(externalProjectPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        Object object = UvProjectModelService.INSTANCE.forgetProjectModelRoot(project, path2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/projectModel/uv/UvProjectOpenProvider$Companion;", "", "<init>", "()V", "UV_TOOL_TABLE_HEADER", "Lkotlin/text/Regex;", "getUV_TOOL_TABLE_HEADER", "()Lkotlin/text/Regex;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getUV_TOOL_TABLE_HEADER() {
            return UV_TOOL_TABLE_HEADER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

