/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Range;
import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import com.oracle.truffle.regex.tregex.parser.CaseUnfoldingTrie;
import com.oracle.truffle.regex.tregex.parser.RegexASTBuilder;
import com.oracle.truffle.regex.tregex.parser.RegexLexer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.graalvm.collections.Pair;

public class MultiCharacterCaseFolding {
    public static void caseFoldUnfoldString(CaseFoldData.CaseFoldAlgorithm algorithm, int[] codepoints, CodePointSet encodingRange, RegexASTBuilder astBuilder) {
        MultiCharacterCaseFolding.caseFoldUnfoldString(algorithm, codepoints, encodingRange, false, astBuilder);
    }

    public static void caseFoldUnfoldString(CaseFoldData.CaseFoldAlgorithm algorithm, int[] codepoints, CodePointSet encodingRange, boolean dropAsciiOnStart, RegexASTBuilder astBuilder) {
        List<Integer> caseFolded = MultiCharacterCaseFolding.caseFold(algorithm, codepoints);
        List<CaseUnfoldingTrie.Unfolding> unfoldings = CaseUnfoldingTrie.findUnfoldings(algorithm, caseFolded);
        unfoldings = unfoldings.stream().filter(u -> encodingRange.contains(u.getCodepoint())).collect(Collectors.toList());
        astBuilder.pushGroup();
        int start = 0;
        int end = 0;
        int unfoldingsStartIndex = 0;
        int unfoldingsEndIndex = 0;
        for (int i = 0; i < unfoldings.size(); ++i) {
            CaseUnfoldingTrie.Unfolding unfolding = unfoldings.get(i);
            if (unfolding.getStart() >= end) {
                MultiCharacterCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings.subList(unfoldingsStartIndex, unfoldingsEndIndex), start, end, 0, dropAsciiOnStart);
                if (unfolding.getStart() > end) {
                    if (dropAsciiOnStart && end == 0 && RegexLexer.isAscii(caseFolded.get(end))) {
                        astBuilder.popGroup();
                        astBuilder.replaceCurTermWithDeadNode();
                        return;
                    }
                    MultiCharacterCaseFolding.addString(astBuilder, caseFolded.subList(end, unfolding.getStart()));
                }
                start = unfolding.getStart();
                unfoldingsStartIndex = i;
            }
            end = Math.max(end, unfolding.getEnd());
            unfoldingsEndIndex = i + 1;
        }
        MultiCharacterCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings.subList(unfoldingsStartIndex, unfoldingsEndIndex), start, end, 0, dropAsciiOnStart);
        if (end < caseFolded.size()) {
            if (dropAsciiOnStart && end == 0 && RegexLexer.isAscii(caseFolded.get(end))) {
                astBuilder.popGroup();
                astBuilder.replaceCurTermWithDeadNode();
                return;
            }
            MultiCharacterCaseFolding.addString(astBuilder, caseFolded.subList(end, caseFolded.size()));
        }
        astBuilder.popGroup();
    }

    public static int[] caseFold(CaseFoldData.CaseFoldAlgorithm algorithm, int codePoint) {
        return CaseFoldData.getTable(algorithm).caseFold(codePoint);
    }

    private static List<Integer> caseFold(CaseFoldData.CaseFoldAlgorithm algorithm, int[] codepoints) {
        ArrayList<Integer> caseFolded = new ArrayList<Integer>();
        for (int codepoint : codepoints) {
            int[] folded = MultiCharacterCaseFolding.caseFold(algorithm, codepoint);
            if (folded == null) {
                caseFolded.add(codepoint);
                continue;
            }
            for (int foldedElem : folded) {
                caseFolded.add(foldedElem);
            }
        }
        return caseFolded;
    }

    private static void addChar(RegexASTBuilder astBuilder, int codepoint) {
        astBuilder.addCharClass(CodePointSet.create(codepoint), true);
    }

    private static void addString(RegexASTBuilder astBuilder, List<Integer> codepoints) {
        for (int codepoint : codepoints) {
            MultiCharacterCaseFolding.addChar(astBuilder, codepoint);
        }
    }

    private static void unfoldSegment(RegexASTBuilder astBuilder, List<Integer> caseFolded, List<CaseUnfoldingTrie.Unfolding> unfoldings, int start, int end, int backtrackingDepth, boolean dropAsciiOnStart) {
        int unfoldingsNextIndex;
        if (backtrackingDepth > 8) {
            throw new UnsupportedRegexException("case-unfolding of case-insensitive string is too complex");
        }
        if (start == end) {
            return;
        }
        if (unfoldings.isEmpty()) {
            MultiCharacterCaseFolding.addString(astBuilder, caseFolded.subList(start, end));
            return;
        }
        CaseUnfoldingTrie.Unfolding unfolding = unfoldings.get(0);
        if (unfolding.getStart() > start) {
            MultiCharacterCaseFolding.addString(astBuilder, caseFolded.subList(start, unfolding.getStart()));
            MultiCharacterCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings, unfolding.getStart(), end, backtrackingDepth, dropAsciiOnStart);
            return;
        }
        if (unfolding.getLength() > 1) {
            int unfoldingsNextIndex2;
            for (unfoldingsNextIndex2 = 1; unfoldingsNextIndex2 < unfoldings.size() && unfoldings.get(unfoldingsNextIndex2).getStart() < unfolding.getEnd(); ++unfoldingsNextIndex2) {
            }
            astBuilder.pushGroup();
            MultiCharacterCaseFolding.addChar(astBuilder, unfolding.getCodepoint());
            MultiCharacterCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings.subList(unfoldingsNextIndex2, unfoldings.size()), unfolding.getEnd(), end, backtrackingDepth + 1, dropAsciiOnStart);
            astBuilder.nextSequence();
            MultiCharacterCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings.subList(1, unfoldings.size()), start, end, backtrackingDepth + 1, dropAsciiOnStart);
            astBuilder.popGroup();
            return;
        }
        CodePointSetAccumulator acc = new CodePointSetAccumulator();
        if (!dropAsciiOnStart || start != 0 || !RegexLexer.isAscii(caseFolded.get(start))) {
            acc.addCodePoint(caseFolded.get(start));
        }
        for (unfoldingsNextIndex = 0; unfoldingsNextIndex < unfoldings.size() && unfoldings.get(unfoldingsNextIndex).getStart() == start; ++unfoldingsNextIndex) {
            assert (unfoldings.get(unfoldingsNextIndex).getLength() == 1);
            int codepoint = unfoldings.get(unfoldingsNextIndex).getCodepoint();
            if (dropAsciiOnStart && start == 0 && RegexLexer.isAscii(codepoint)) continue;
            acc.addCodePoint(codepoint);
        }
        astBuilder.addCharClass(acc.toCodePointSet(), false);
        MultiCharacterCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings.subList(unfoldingsNextIndex, unfoldings.size()), start + 1, end, backtrackingDepth, dropAsciiOnStart);
    }

    private static void caseFoldCharClass(CaseFoldData.CaseFoldAlgorithm algorithm, CodePointSetAccumulator charClass, BiConsumer<Integer, int[]> caseFoldItem) {
        CaseFoldData.getTable(algorithm).caseFold(charClass, caseFoldItem);
    }

    public static void caseClosure(CaseFoldData.CaseFoldAlgorithm algorithm, CodePointSetAccumulator charClass, CodePointSetAccumulator tmp, BiPredicate<Integer, Integer> filter, CodePointSet allowedCodePoints) {
        tmp.clear();
        MultiCharacterCaseFolding.caseFoldCharClass(algorithm, charClass, (from, to) -> {
            if (((int[])to).length == 1 && filter.test((Integer)from, to[0])) {
                tmp.addCodePoint(to[0]);
            }
            for (int unfolding : CaseUnfoldingTrie.findSingleCharUnfoldings(algorithm, to)) {
                if (unfolding == from || !filter.test((Integer)from, unfolding)) continue;
                tmp.addCodePoint(unfolding);
            }
        });
        for (Range r : charClass) {
            for (int codepoint = r.lo; codepoint <= r.hi; ++codepoint) {
                for (int unfolding : CaseUnfoldingTrie.findSingleCharUnfoldings(algorithm, codepoint)) {
                    if (!filter.test(codepoint, unfolding)) continue;
                    tmp.addCodePoint(unfolding);
                }
            }
        }
        tmp.intersectWith(allowedCodePoints);
        charClass.addSet(tmp.get());
    }

    public static List<Pair<Integer, int[]>> caseClosureMultiCodePoint(CaseFoldData.CaseFoldAlgorithm algorithm, CodePointSetAccumulator charClass) {
        ArrayList<Pair<Integer, int[]>> multiCodePointExpansions = new ArrayList<Pair<Integer, int[]>>();
        MultiCharacterCaseFolding.caseFoldCharClass(algorithm, charClass, (from, to) -> {
            if (((int[])to).length > 1) {
                assert (!RegexLexer.isAscii(from));
                multiCodePointExpansions.add(Pair.create(from, to));
            }
        });
        return multiCodePointExpansions;
    }

    public static boolean equalsIgnoreCase(CaseFoldData.CaseFoldAlgorithm algorithm, int codePointA, int codePointB) {
        int[] foldedA = MultiCharacterCaseFolding.caseFold(algorithm, codePointA);
        int[] foldedB = MultiCharacterCaseFolding.caseFold(algorithm, codePointB);
        if (foldedA == null && foldedB == null) {
            return codePointA == codePointB;
        }
        if (foldedA == null) {
            return foldedB.length == 1 && codePointA == foldedB[0];
        }
        if (foldedB == null) {
            return foldedA.length == 1 && foldedA[0] == codePointB;
        }
        return Arrays.equals(foldedA, foldedB);
    }
}

