/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.branch.BranchType;
import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.git.shared.actions.GitSingleRefActions;
import com.intellij.vcs.git.shared.branch.GitInOutCountersInProject;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.actions.branch.GitBranchActionsUtil;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitRefType;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.i18n.GitBundleExtensions;
import git4idea.remote.GitConfigureRemotesDialogKt;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.BranchGroupingAction;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchesDashboardTreeController;
import git4idea.ui.branch.dashboard.BranchesDashboardTreeSelectionHandler;
import git4idea.ui.branch.dashboard.BranchesDataKeysKt;
import git4idea.ui.branch.dashboard.BranchesInGitLogUiFactoryProviderKt;
import git4idea.ui.branch.dashboard.BranchesTreeComponent;
import git4idea.ui.branch.dashboard.BranchesTreeSelection;
import git4idea.ui.branch.dashboard.RefInfo;
import git4idea.ui.branch.dashboard.RemoteInfo;
import git4idea.ui.branch.dashboard.TagInfo;
import git4idea.ui.branch.dashboard.VcsLogNavigatable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b!\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u001e\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\""}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions;", "", "<init>", "()V", "BranchesTreeActionGroup", "HeadAndBranchActions", "MultipleLocalBranchActions", "GroupActions", "MultipleGroupActions", "RemoteGlobalActions", "BranchActionsBuilder", "NewBranchAction", "UpdateSelectedBranchAction", "DeleteBranchAction", "ShowBranchDiffAction", "BranchesPairActionBase", "ShowArbitraryBranchesDiffAction", "ShowArbitraryBranchesFileDiffAction", "ShowMyBranchesAction", "ToggleFavoriteAction", "SelectionHandlingModeAction", "ChangeBranchFilterAction", "NavigateLogToBranchAction", "GroupingSettingsGroup", "GroupBranchByDirectoryAction", "GroupBranchByRepositoryAction", "HideBranchesAction", "RemoveRemoteAction", "EditRemoteAction", "RemoteActionBase", "RefActionBase", "BranchesActionBase", "UpdateBranchFilterInLogAction", "NavigateLogToSelectedBranchAction", "intellij.vcs.git"})
public final class BranchesDashboardActions {
    @NotNull
    public static final BranchesDashboardActions INSTANCE = new BranchesDashboardActions();

    private BranchesDashboardActions() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchActionsBuilder;", "", "<init>", "()V", "build", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    public static final class BranchActionsBuilder {
        @NotNull
        public static final BranchActionsBuilder INSTANCE = new BranchActionsBuilder();

        private BranchActionsBuilder() {
        }

        @RequiresBackgroundThread
        @Nullable
        public final ActionGroup build(@Nullable AnActionEvent e) {
            Object object;
            Object object2 = e;
            if (object2 == null || (object2 = (BranchesTreeSelection)object2.getData(BranchesDataKeysKt.getGIT_BRANCHES_TREE_SELECTION())) == null) {
                return null;
            }
            Object selection = object2;
            List<RefInfo> selectedRefs = ((BranchesTreeSelection)selection).getSelectedRefs();
            boolean headSelected = ((BranchesTreeSelection)selection).getHeadSelected();
            Set<RemoteInfo> selectedRemotes = ((BranchesTreeSelection)selection).getSelectedRemotes();
            List<BranchNodeDescriptor> selectedNodes = ((BranchesTreeSelection)selection).getSelectedNodeDescriptors();
            if (selectedNodes.size() == 1 && (selectedRefs.size() == 1 || headSelected)) {
                object = GitSingleRefActions.getSingleRefActionGroup();
            } else if (selectedNodes.size() == 2 && selectedRefs.size() == 1 && headSelected) {
                object = new HeadAndBranchActions();
            } else if (selectedNodes.size() == selectedRefs.size() && selectedRefs.size() > 1) {
                object = new MultipleLocalBranchActions();
            } else if (!((Collection)selectedNodes).isEmpty() && selectedRemotes.size() == selectedNodes.size()) {
                object = selectedRemotes.size() == 1 ? (ActionGroup)new GroupActions() : (ActionGroup)new MultipleGroupActions();
            } else {
                Object object3 = CollectionsKt.singleOrNull(selectedNodes);
                BranchNodeDescriptor.TopLevelGroup topLevelGroup = object3 instanceof BranchNodeDescriptor.TopLevelGroup ? (BranchNodeDescriptor.TopLevelGroup)object3 : null;
                object = (topLevelGroup != null ? topLevelGroup.getRefType() : null) == GitBranchType.REMOTE ? (ActionGroup)new RemoteGlobalActions() : null;
            }
            return object;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001BU\u0012\u001f\b\u0002\u0010\u0002\u001a\u0019\u0012\u0015\u0012\u00130\u0004\u00a2\u0006\u000e\b\u0005\u0012\n\b\u0006\u0012\u0006\b\n0\u00078\b0\u0003\u0012\u001f\b\u0002\u0010\t\u001a\u0019\u0012\u0015\u0012\u00130\u0004\u00a2\u0006\u000e\b\u0005\u0012\n\b\u0006\u0012\u0006\b\n0\u00078\n0\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R%\u0010\t\u001a\u0019\u0012\u0015\u0012\u00130\u0004\u00a2\u0006\u000e\b\u0005\u0012\n\b\u0006\u0012\u0006\b\n0\u00078\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "text", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "description", "Sentence", "icon", "Ljavax/swing/Icon;", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Ljavax/swing/Icon;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "selection", "Lgit4idea/ui/branch/dashboard/BranchesTreeSelection;", "intellij.vcs.git"})
    public static abstract class BranchesActionBase
    extends DumbAwareAction {
        @NotNull
        private final Function0<String> description;

        public BranchesActionBase(@NotNull Function0<String> text2, @NotNull Function0<String> description, @Nullable Icon icon) {
            Intrinsics.checkNotNullParameter(text2, (String)"text");
            Intrinsics.checkNotNullParameter(description, (String)"description");
            super(() -> BranchesActionBase._init_$lambda$2(text2), () -> BranchesActionBase._init_$lambda$3(description), icon);
            this.description = description;
        }

        public /* synthetic */ BranchesActionBase(Function0 function0, Function0 function02, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                function0 = BranchesActionBase::_init_$lambda$0;
            }
            if ((n & 2) != 0) {
                function02 = BranchesActionBase::_init_$lambda$1;
            }
            if ((n & 4) != 0) {
                icon = null;
            }
            this((Function0<String>)function0, (Function0<String>)function02, icon);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches, @NotNull BranchesTreeSelection selection) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(branches, (String)"branches");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        }

        public void update(@NotNull AnActionEvent e) {
            Collection collection;
            BranchesTreeSelection selection;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BranchesTreeSelection branchesTreeSelection = selection = (BranchesTreeSelection)e.getData(BranchesDataKeysKt.getGIT_BRANCHES_TREE_SELECTION());
            List<BranchInfo> branches = branchesTreeSelection != null ? branchesTreeSelection.getSelectedBranches() : null;
            Project project = e.getProject();
            boolean enabled = project != null && !((collection = (Collection)branches) == null || collection.isEmpty());
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setDescription((String)this.description.invoke());
            if (enabled) {
                this.update(e, project, (Collection<BranchInfo>)branches, selection);
            }
        }

        private static final String _init_$lambda$0() {
            return "";
        }

        private static final String _init_$lambda$1() {
            return "";
        }

        private static final String _init_$lambda$2(Function0 $tmp0) {
            return (String)$tmp0.invoke();
        }

        private static final String _init_$lambda$3(Function0 $tmp0) {
            return (String)$tmp0.invoke();
        }

        public BranchesActionBase() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001BU\u0012\u001f\b\u0002\u0010\u0002\u001a\u0019\u0012\u0015\u0012\u00130\u0004\u00a2\u0006\u000e\b\u0005\u0012\n\b\u0006\u0012\u0006\b\n0\u00078\b0\u0003\u0012\u001f\b\u0002\u0010\t\u001a\u0019\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u000e\b\u0005\u0012\n\b\u0006\u0012\u0006\b\n0\u00078\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J.\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J.\u0010!\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016H&\u00a8\u0006\""}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesPairActionBase;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "text", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "description", "Sentence", "icon", "Ljavax/swing/Icon;", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Ljavax/swing/Icon;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "selection", "Lgit4idea/ui/branch/dashboard/BranchesTreeSelection;", "actionPerformed", "getBranchPair", "Lkotlin/Pair;", "commonRepositories", "Lgit4idea/repo/GitRepository;", "branchOne", "branchTwo", "performAction", "intellij.vcs.git"})
    public static abstract class BranchesPairActionBase
    extends BranchesActionBase {
        public BranchesPairActionBase(@NotNull Function0<String> text2, @NotNull Function0<String> description, @Nullable Icon icon) {
            Intrinsics.checkNotNullParameter(text2, (String)"text");
            Intrinsics.checkNotNullParameter(description, (String)"description");
            super(text2, description, icon);
        }

        public /* synthetic */ BranchesPairActionBase(Function0 function0, Function0 function02, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                function0 = BranchesPairActionBase::_init_$lambda$0;
            }
            if ((n & 2) != 0) {
                function02 = BranchesPairActionBase::_init_$lambda$1;
            }
            if ((n & 4) != 0) {
                icon = null;
            }
            this((Function0<String>)function0, (Function0<String>)function02, icon);
        }

        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches, @NotNull BranchesTreeSelection selection) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(branches, (String)"branches");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Pair<BranchInfo, BranchInfo> branchPair = this.getBranchPair(selection, project, e);
            if (branchPair == null) {
                e.getPresentation().setEnabledAndVisible(false);
                e.getPresentation().setDescription("");
            } else {
                BranchInfo branchOne = (BranchInfo)branchPair.component1();
                BranchInfo branchTwo = (BranchInfo)branchPair.component2();
                if (Intrinsics.areEqual((Object)branchOne.getBranchName(), (Object)branchTwo.getBranchName()) || this.commonRepositories(branchOne, branchTwo, selection).isEmpty()) {
                    e.getPresentation().setEnabled(false);
                    e.getPresentation().setDescription(GitBundle.message((String)"action.Git.Compare.Selected.description.disabled", (Object[])new Object[0]));
                }
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            BranchesTreeSelection branchesTreeSelection = (BranchesTreeSelection)e.getData(BranchesDataKeysKt.getGIT_BRANCHES_TREE_SELECTION());
            if (branchesTreeSelection == null) {
                return;
            }
            BranchesTreeSelection selection = branchesTreeSelection;
            Pair<BranchInfo, BranchInfo> pair = this.getBranchPair(selection, project2, e);
            if (pair == null) {
                return;
            }
            Pair<BranchInfo, BranchInfo> pair2 = pair;
            BranchInfo branchOne = (BranchInfo)pair2.component1();
            BranchInfo branchTwo = (BranchInfo)pair2.component2();
            Collection<GitRepository> commonRepositories = this.commonRepositories(branchOne, branchTwo, selection);
            this.performAction(project2, branchOne, branchTwo, commonRepositories);
        }

        private final Pair<BranchInfo, BranchInfo> getBranchPair(BranchesTreeSelection selection, Project project, AnActionEvent e) {
            Pair pair;
            List<BranchInfo> branches = selection.getSelectedBranches();
            if (branches.size() == 1 && selection.getHeadSelected()) {
                GitRepository gitRepository = GitBranchUtil.guessWidgetRepository(project, e.getDataContext());
                if (gitRepository == null && (gitRepository = (GitRepository)CollectionsKt.singleOrNull(((BranchInfo)CollectionsKt.single(branches)).getRepositories())) == null) {
                    return null;
                }
                GitRepository guessRepo = gitRepository;
                GitLocalBranch gitLocalBranch = guessRepo.getCurrentBranch();
                if (gitLocalBranch == null) {
                    return null;
                }
                GitLocalBranch currentBranch = gitLocalBranch;
                pair = TuplesKt.to((Object)CollectionsKt.single(branches), (Object)new BranchInfo((GitBranch)currentBranch, true, false, GitInOutCountersInProject.EMPTY, CollectionsKt.listOf((Object)guessRepo)));
            } else {
                pair = branches.size() == 2 ? TuplesKt.to((Object)branches.get(0), (Object)branches.get(1)) : null;
            }
            return pair;
        }

        private final Collection<GitRepository> commonRepositories(BranchInfo branchOne, BranchInfo branchTwo, BranchesTreeSelection selection) {
            return branchOne.getRepositories().size() == 1 && branchTwo.getRepositories().size() == 1 ? (Collection)CollectionsKt.intersect((Iterable)branchOne.getRepositories(), (Iterable)branchTwo.getRepositories()) : (Collection)CollectionsKt.intersect((Iterable)selection.getSelectedRepositories(branchOne), (Iterable)selection.getSelectedRepositories(branchTwo));
        }

        public abstract void performAction(@NotNull Project var1, @NotNull BranchInfo var2, @NotNull BranchInfo var3, @NotNull Collection<? extends GitRepository> var4);

        private static final String _init_$lambda$0() {
            return "";
        }

        private static final String _init_$lambda$1() {
            return "";
        }

        public BranchesPairActionBase() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesTreeActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.vcs.git"})
    public static final class BranchesTreeActionGroup
    extends ActionGroup
    implements DumbAware {
        public BranchesTreeActionGroup() {
            this.getTemplatePresentation().setPopupGroup(true);
            this.getTemplatePresentation().setHideGroupIfEmpty(true);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = BranchActionsBuilder.INSTANCE.build(e);
            if (anActionArray == null || (anActionArray = anActionArray.getChildren(e)) == null) {
                anActionArray = AnAction.EMPTY_ARRAY;
                Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            }
            return anActionArray;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ChangeBranchFilterAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$SelectionHandlingModeAction;", "<init>", "()V", "intellij.vcs.git"})
    public static final class ChangeBranchFilterAction
    extends SelectionHandlingModeAction {
        public ChangeBranchFilterAction() {
            super(BranchesDashboardTreeSelectionHandler.SelectionAction.FILTER);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$DeleteBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RefActionBase;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "refs", "", "Lgit4idea/ui/branch/dashboard/RefInfo;", "selection", "Lgit4idea/ui/branch/dashboard/BranchesTreeSelection;", "actionPerformed", "delete", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$DeleteBranchAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,704:1\n1740#2,3:705\n2746#2,3:708\n1869#2,2:711\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$DeleteBranchAction\n*L\n220#1:705,3\n226#1:708,3\n249#1:711,2\n*E\n"})
    public static final class DeleteBranchAction
    extends RefActionBase {
        public DeleteBranchAction() {
            Object[] objectArray = new Object[]{0};
            Function0<String> function0 = GitBundleExtensions.INSTANCE.messagePointer("action.Git.Delete.Branch.title", objectArray);
            Icon icon = AllIcons.Actions.GC;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GC");
            super(function0, icon);
            objectArray = new ShortcutSet[]{KeymapUtil.getActiveKeymapShortcuts((String)"SafeDelete"), KeymapUtil.getActiveKeymapShortcuts((String)"EditorDeleteToLineStart")};
            this.setShortcutSet((ShortcutSet)new CompositeShortcutSet((ShortcutSet[])objectArray));
        }

        @Override
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<? extends RefInfo> refs, @NotNull BranchesTreeSelection selection) {
            boolean bl;
            block9: {
                String string;
                boolean bl2;
                Object[] $this$all$iv;
                block8: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter(refs, (String)"refs");
                    Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
                    $this$all$iv = (Object[])refs;
                    boolean $i$f$all = false;
                    if (((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object t : $this$all$iv) {
                            RefInfo it = (RefInfo)t;
                            boolean bl3 = false;
                            if (it instanceof BranchInfo) continue;
                            bl2 = false;
                            break block8;
                        }
                        bl2 = true;
                    }
                }
                boolean allRefsAreBranches = bl2;
                Presentation presentation = e.getPresentation();
                if (allRefsAreBranches) {
                    $this$all$iv = new Object[]{refs.size()};
                    string = GitBundle.message((String)"action.Git.Delete.Branch.title", (Object[])$this$all$iv);
                } else {
                    string = ApplicationBundle.message((String)"button.delete", (Object[])new Object[0]);
                }
                presentation.setText(string);
                Iterable $this$none$iv = refs;
                boolean $i$f$none = false;
                if (((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        RefInfo refInfo = (RefInfo)element$iv;
                        boolean bl4 = false;
                        BranchInfo branchInfo = refInfo instanceof BranchInfo ? (BranchInfo)refInfo : null;
                        GitBranch gitBranch = branchInfo != null ? branchInfo.getBranch() : null;
                        GitRemoteBranch remoteBranchInfo = gitBranch instanceof GitRemoteBranch ? (GitRemoteBranch)gitBranch : null;
                        if (!(refInfo.isCurrent() || remoteBranchInfo != null && GitProtectedBranchesKt.isRemoteBranchProtected((Collection<? extends GitRepository>)selection.getSelectedRepositories((BranchInfo)refInfo), remoteBranchInfo.getName()))) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            boolean enabled = bl;
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            BranchesTreeSelection branchesTreeSelection = (BranchesTreeSelection)e.getData(BranchesDataKeysKt.getGIT_BRANCHES_TREE_SELECTION());
            if (branchesTreeSelection == null) {
                return;
            }
            BranchesTreeSelection selection = branchesTreeSelection;
            this.delete(project2, selection);
        }

        private final void delete(Project project, BranchesTreeSelection selection) {
            GitBrancher gitBrancher = GitBrancher.getInstance(project);
            Set remoteBranchesNames = new LinkedHashSet();
            Set remoteBranchesRepos = new LinkedHashSet();
            Map localBranches = new LinkedHashMap();
            Map tags = new LinkedHashMap();
            Iterable $this$forEach$iv = selection.getSelectedRefsToRepositories();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                RefInfo refInfo = (RefInfo)pair.component1();
                List repos = (List)pair.component2();
                RefInfo refInfo2 = refInfo;
                if (refInfo2 instanceof BranchInfo) {
                    if (((BranchInfo)refInfo).isLocalBranch()) {
                        localBranches.put(((BranchInfo)refInfo).getBranchName(), repos);
                        continue;
                    }
                    remoteBranchesNames.add(((BranchInfo)refInfo).getBranchName());
                    remoteBranchesRepos.addAll(repos);
                    continue;
                }
                if (refInfo2 instanceof TagInfo) {
                    tags.put(((TagInfo)refInfo).getRef().getName(), repos);
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
            Function0 deleteRemoteBranches = () -> DeleteBranchAction.delete$lambda$3(gitBrancher, remoteBranchesNames, remoteBranchesRepos);
            if (!tags.isEmpty()) {
                gitBrancher.deleteTags(tags);
            }
            if (!localBranches.isEmpty()) {
                gitBrancher.deleteBranches(localBranches, () -> DeleteBranchAction.delete$lambda$4(deleteRemoteBranches));
            } else {
                deleteRemoteBranches.invoke();
            }
        }

        private static final Unit delete$lambda$3(GitBrancher $gitBrancher, Set $remoteBranchesNames, Set $remoteBranchesRepos) {
            $gitBrancher.deleteRemoteBranches(CollectionsKt.toList((Iterable)$remoteBranchesNames), CollectionsKt.toList((Iterable)$remoteBranchesRepos));
            return Unit.INSTANCE;
        }

        private static final void delete$lambda$4(Function0 $tmp0) {
            $tmp0.invoke();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bH\u0016J2\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$EditRemoteAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteActionBase;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "selectedRemotes", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "doAction", "intellij.vcs.git"})
    public static final class EditRemoteAction
    extends RemoteActionBase {
        public EditRemoteAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Log.Edit.Remote.text", new Object[0]), null, null, 6, null);
        }

        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Map<GitRepository, ? extends Set<GitRemote>> selectedRemotes) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRemotes, (String)"selectedRemotes");
            if (selectedRemotes.size() != 1) {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }

        @Override
        public void doAction(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Map<GitRepository, ? extends Set<GitRemote>> selectedRemotes) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRemotes, (String)"selectedRemotes");
            Map.Entry entry = (Map.Entry)CollectionsKt.first((Iterable)selectedRemotes.entrySet());
            GitRepository repository2 = (GitRepository)entry.getKey();
            Set remotes = (Set)entry.getValue();
            Git git = Git.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)git, (String)"getInstance(...)");
            GitConfigureRemotesDialogKt.editRemote$default(git, repository2, (GitRemote)CollectionsKt.first((Iterable)remotes), null, 8, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupActions;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupActions\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,704:1\n37#2:705\n36#2,3:706\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupActions\n*L\n76#1:705\n76#1:706,3\n*E\n"})
    public static final class GroupActions
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            Object[] objectArray = new AnAction[]{new EditRemoteAction(), new RemoveRemoteAction()};
            Collection $this$toTypedArray$iv = CollectionsKt.arrayListOf((Object[])objectArray);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new AnAction[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupBranchByDirectoryAction;", "Lgit4idea/ui/branch/BranchGroupingAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "state", "", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupBranchByDirectoryAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,704:1\n1#2:705\n*E\n"})
    public static final class GroupBranchByDirectoryAction
    extends BranchGroupingAction {
        public GroupBranchByDirectoryAction() {
            super(GroupingKey.GROUPING_BY_DIRECTORY, null, 2, null);
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            Supplier supplier = DvcsBundle.messagePointer((String)"action.text.branch.group.by.directory", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
            Supplier groupByDirectory = supplier;
            Function0<String> groupingSeparator = GitBundleExtensions.INSTANCE.messagePointer("group.Git.Log.Branches.Grouping.Settings.text", new Object[0]);
            e.getPresentation().setText((String)(GroupBranchByRepositoryAction.Companion.isEnabledAndVisible(e) ? (String)groupByDirectory.get() : groupingSeparator.invoke() + " " + groupByDirectory.get()));
        }

        @Override
        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.setSelected(e, state2);
                Project project = e.getProject();
                if (project == null) break block0;
                Project it = project;
                boolean bl = false;
                StoreUtilKt.saveSettingsForRemoteDevelopment((ComponentManager)((ComponentManager)it));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupBranchByRepositoryAction;", "Lgit4idea/ui/branch/BranchGroupingAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.vcs.git"})
    public static final class GroupBranchByRepositoryAction
    extends BranchGroupingAction {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public GroupBranchByRepositoryAction() {
            super(GroupingKey.GROUPING_BY_REPOSITORY, null, 2, null);
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            e.getPresentation().setEnabledAndVisible(Companion.isEnabledAndVisible(e));
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupBranchByRepositoryAction$Companion;", "", "<init>", "()V", "isEnabledAndVisible", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
        @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupBranchByRepositoryAction$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,704:1\n1#2:705\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isEnabledAndVisible(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Project project = e.getProject();
                Project project2 = project;
                if (project == null) return false;
                Project project3 = project2;
                RepositoryChangesBrowserNode.Companion companion = RepositoryChangesBrowserNode.Companion;
                Project p0 = project3;
                boolean bl = false;
                VcsLogColorManager vcsLogColorManager = companion.getColorManager(p0);
                project2 = vcsLogColorManager;
                if (vcsLogColorManager == null) return false;
                boolean bl2 = project2.hasMultiplePaths();
                return bl2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$GroupingSettingsGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    public static final class GroupingSettingsGroup
    extends DefaultActionGroup
    implements DumbAware {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setPopupGroup(GroupBranchByRepositoryAction.Companion.isEnabledAndVisible(e));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$HeadAndBranchActions;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    public static final class HeadAndBranchActions
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new ShowArbitraryBranchesDiffAction(), new ShowArbitraryBranchesFileDiffAction()};
            return anActionArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$HideBranchesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.vcs.git"})
    public static final class HideBranchesAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
            e.getPresentation().setEnabledAndVisible(properties != null && properties.exists(BranchesInGitLogUiFactoryProviderKt.getSHOW_GIT_BRANCHES_LOG_PROPERTY()));
            super.update(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
            if (properties != null && properties.exists(BranchesInGitLogUiFactoryProviderKt.getSHOW_GIT_BRANCHES_LOG_PROPERTY())) {
                properties.set(BranchesInGitLogUiFactoryProviderKt.getSHOW_GIT_BRANCHES_LOG_PROPERTY(), (Object)false);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$MultipleGroupActions;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$MultipleGroupActions\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,704:1\n37#2:705\n36#2,3:706\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$MultipleGroupActions\n*L\n82#1:705\n82#1:706,3\n*E\n"})
    public static final class MultipleGroupActions
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            Object[] objectArray = new AnAction[]{new RemoveRemoteAction()};
            Collection $this$toTypedArray$iv = CollectionsKt.arrayListOf((Object[])objectArray);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new AnAction[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$MultipleLocalBranchActions;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    public static final class MultipleLocalBranchActions
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new ShowArbitraryBranchesDiffAction(), new ShowArbitraryBranchesFileDiffAction(), new UpdateSelectedBranchAction(), new DeleteBranchAction()};
            return anActionArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$NavigateLogToBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$SelectionHandlingModeAction;", "<init>", "()V", "intellij.vcs.git"})
    public static final class NavigateLogToBranchAction
    extends SelectionHandlingModeAction {
        public NavigateLogToBranchAction() {
            super(BranchesDashboardTreeSelectionHandler.SelectionAction.NAVIGATE);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$NavigateLogToSelectedBranchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.vcs.git"})
    public static final class NavigateLogToSelectedBranchAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean visible;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BranchesDashboardTreeController uiController = (BranchesDashboardTreeController)e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            Project project = e.getProject();
            boolean bl = visible = project != null && uiController != null;
            if (!visible) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            BranchesTreeSelection branchesTreeSelection = (BranchesTreeSelection)e.getData(BranchesDataKeysKt.getGIT_BRANCHES_TREE_SELECTION());
            e.getPresentation().setEnabled((branchesTreeSelection != null ? branchesTreeSelection.getLogNavigatableNodeDescriptor() : null) != null);
            e.getPresentation().setVisible(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BranchesDashboardTreeController branchesDashboardTreeController = (BranchesDashboardTreeController)e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            if (branchesDashboardTreeController == null) {
                return;
            }
            BranchesDashboardTreeController controller = branchesDashboardTreeController;
            Object object = (BranchesTreeSelection)e.getData(BranchesDataKeysKt.getGIT_BRANCHES_TREE_SELECTION());
            if (object == null || (object = ((BranchesTreeSelection)object).getLogNavigatableNodeDescriptor()) == null) {
                return;
            }
            Object selection = object;
            controller.navigateLogToRef((VcsLogNavigatable)selection);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$NewBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "selection", "Lgit4idea/ui/branch/dashboard/BranchesTreeSelection;", "actionPerformed", "intellij.vcs.git"})
    public static final class NewBranchAction
    extends BranchesActionBase {
        public NewBranchAction() {
            super((Function0<String>)((Function0)NewBranchAction::_init_$lambda$0), (Function0<String>)((Function0)NewBranchAction::_init_$lambda$1), com.intellij.dvcs.ui.NewBranchAction.icon);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            Boolean headSelected;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BranchesTreeSelection branchesTreeSelection = (BranchesTreeSelection)e.getData(BranchesDataKeysKt.getGIT_BRANCHES_TREE_SELECTION());
            Boolean bl = headSelected = branchesTreeSelection != null ? Boolean.valueOf(branchesTreeSelection.getHeadSelected()) : null;
            if (Intrinsics.areEqual((Object)headSelected, (Object)true)) {
                e.getPresentation().setEnabled(true);
            } else {
                super.update(e);
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches, @NotNull BranchesTreeSelection selection) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(branches, (String)"branches");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            if (branches.size() > 1) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription(GitBundle.message((String)"action.Git.New.Branch.description", (Object[])new Object[0]));
                return;
            }
            Set<GitRepository> repositories = selection.getRepositoriesOfSelectedBranches();
            DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, (Collection)repositories, (String)DvcsBundle.message((String)"action.not.possible.in.fresh.repo.new.branch", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            BranchesTreeSelection branchesTreeSelection = (BranchesTreeSelection)e.getData(BranchesDataKeysKt.getGIT_BRANCHES_TREE_SELECTION());
            if (branchesTreeSelection == null) {
                return;
            }
            BranchesTreeSelection selection = branchesTreeSelection;
            if (selection.getHeadSelected()) {
                List<GitRepository> list = GitRepositoryManager.getInstance(project2).getRepositories();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
                List<GitRepository> repositories = list;
                GitBranchActionsUtilKt.createOrCheckoutNewBranch$default(project2, repositories, "HEAD", null, MultiRootBranches.getCommonCurrentBranch((Collection)repositories), 8, null);
            } else {
                List<BranchInfo> branches = selection.getSelectedBranches();
                Set<GitRepository> repositories = selection.getRepositoriesOfSelectedBranches();
                BranchInfo branchInfo = (BranchInfo)CollectionsKt.first(branches);
                String branchName = branchInfo.getBranchName();
                Collection collection = repositories;
                String string = branchName + "^0";
                Object[] objectArray = new Object[]{branchName};
                String string2 = GitBundle.message((String)"action.Git.New.Branch.dialog.title", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                GitBranchActionsUtilKt.createOrCheckoutNewBranch(project2, collection, string, string2, GitBranchActionsUtil.calculateNewBranchInitialName(branchName, !branchInfo.isLocalBranch()));
            }
        }

        private static final String _init_$lambda$0() {
            String string = DvcsBundle.message((String)"new.branch.action.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        private static final String _init_$lambda$1() {
            String string = DvcsBundle.message((String)"new.branch.action.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B.\u0012\u001d\u0010\u0002\u001a\u0019\u0012\u0015\u0012\u00130\u0004\u00a2\u0006\u000e\b\u0005\u0012\n\b\u0006\u0012\u0006\b\n0\u00078\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001a"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RefActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "text", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "icon", "Ljavax/swing/Icon;", "<init>", "(Lkotlin/jvm/functions/Function0;Ljavax/swing/Icon;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "refs", "", "Lgit4idea/ui/branch/dashboard/RefInfo;", "selection", "Lgit4idea/ui/branch/dashboard/BranchesTreeSelection;", "intellij.vcs.git"})
    public static abstract class RefActionBase
    extends DumbAwareAction {
        public RefActionBase(@NotNull Function0<String> text2, @NotNull Icon icon) {
            Intrinsics.checkNotNullParameter(text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            super(() -> RefActionBase._init_$lambda$0(text2), icon);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Collection collection;
            BranchesTreeSelection selection;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BranchesTreeSelection branchesTreeSelection = selection = (BranchesTreeSelection)e.getData(BranchesDataKeysKt.getGIT_BRANCHES_TREE_SELECTION());
            List<RefInfo> selectedRefs = branchesTreeSelection != null ? branchesTreeSelection.getSelectedRefs() : null;
            Project project = e.getProject();
            boolean enabled = project != null && !((collection = (Collection)selectedRefs) == null || collection.isEmpty());
            e.getPresentation().setEnabled(enabled);
            if (enabled) {
                this.update(e, project, (Collection<? extends RefInfo>)selectedRefs, selection);
            }
        }

        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<? extends RefInfo> refs, @NotNull BranchesTreeSelection selection) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(refs, (String)"refs");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        }

        private static final String _init_$lambda$0(Function0 $tmp0) {
            return (String)$tmp0.invoke();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001BS\u0012\u001d\u0010\u0002\u001a\u0019\u0012\u0015\u0012\u00130\u0004\u00a2\u0006\u000e\b\u0005\u0012\n\b\u0006\u0012\u0006\b\n0\u00078\b0\u0003\u0012\u001f\b\u0002\u0010\t\u001a\u0019\u0012\u0015\u0012\u00130\u0004\u00a2\u0006\u000e\b\u0005\u0012\n\b\u0006\u0012\u0006\b\n0\u00078\n0\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ2\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0016H\u0016J2\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0016H&J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R%\u0010\t\u001a\u0019\u0012\u0015\u0012\u00130\u0004\u00a2\u0006\u000e\b\u0005\u0012\n\b\u0006\u0012\u0006\b\n0\u00078\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "text", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "description", "Sentence", "icon", "Ljavax/swing/Icon;", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Ljavax/swing/Icon;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "selectedRemotes", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "doAction", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "intellij.vcs.git"})
    public static abstract class RemoteActionBase
    extends DumbAwareAction {
        @NotNull
        private final Function0<String> description;

        public RemoteActionBase(@NotNull Function0<String> text2, @NotNull Function0<String> description, @Nullable Icon icon) {
            Intrinsics.checkNotNullParameter(text2, (String)"text");
            Intrinsics.checkNotNullParameter(description, (String)"description");
            super(() -> RemoteActionBase._init_$lambda$1(text2), () -> RemoteActionBase._init_$lambda$2(description), icon);
            this.description = description;
        }

        public /* synthetic */ RemoteActionBase(Function0 function0, Function0 function02, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                function02 = RemoteActionBase::_init_$lambda$0;
            }
            if ((n & 4) != 0) {
                icon = null;
            }
            this((Function0<String>)function0, (Function0<String>)function02, icon);
        }

        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Map<GitRepository, ? extends Set<GitRemote>> selectedRemotes) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRemotes, (String)"selectedRemotes");
        }

        public abstract void doAction(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull Map<GitRepository, ? extends Set<GitRemote>> var3);

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Object selectedRemotes;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            BranchesDashboardTreeController controller = (BranchesDashboardTreeController)e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            Object object = controller;
            if (object == null || (object = ((BranchesDashboardTreeController)object).getSelectedRemotes()) == null) {
                object = selectedRemotes = MapsKt.emptyMap();
            }
            boolean enabled = project != null && !selectedRemotes.isEmpty();
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setDescription((String)this.description.invoke());
            if (enabled) {
                Project project2 = project;
                Intrinsics.checkNotNull((Object)project2);
                this.update(e, project2, (Map<GitRepository, ? extends Set<GitRemote>>)selectedRemotes);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            Object object = e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            Intrinsics.checkNotNull((Object)object);
            BranchesDashboardTreeController controller = (BranchesDashboardTreeController)object;
            Map<GitRepository, Set<GitRemote>> selectedRemotes = controller.getSelectedRemotes();
            this.doAction(e, project2, selectedRemotes);
        }

        private static final String _init_$lambda$0() {
            return "";
        }

        private static final String _init_$lambda$1(Function0 $tmp0) {
            return (String)$tmp0.invoke();
        }

        private static final String _init_$lambda$2(Function0 $tmp0) {
            return (String)$tmp0.invoke();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteGlobalActions;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteGlobalActions\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,704:1\n37#2:705\n36#2,3:706\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteGlobalActions\n*L\n88#1:705\n88#1:706,3\n*E\n"})
    public static final class RemoteGlobalActions
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            Object[] objectArray = new AnAction[1];
            Intrinsics.checkNotNullExpressionValue((Object)ActionManager.getInstance().getAction("Git.Configure.Remotes"), (String)"getAction(...)");
            Collection $this$toTypedArray$iv = CollectionsKt.arrayListOf((Object[])objectArray);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new AnAction[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bH\u0016J2\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoveRemoteAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RemoteActionBase;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "selectedRemotes", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "doAction", "intellij.vcs.git"})
    public static final class RemoveRemoteAction
    extends RemoteActionBase {
        public RemoveRemoteAction() {
            Object[] objectArray = new Object[]{0};
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Log.Remove.Remote.text", objectArray), null, null, 6, null);
        }

        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Map<GitRepository, ? extends Set<GitRemote>> selectedRemotes) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRemotes, (String)"selectedRemotes");
            Object[] objectArray = new Object[]{selectedRemotes.size()};
            e.getPresentation().setText(GitBundle.message((String)"action.Git.Log.Remove.Remote.text", (Object[])objectArray));
        }

        @Override
        public void doAction(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Map<GitRepository, ? extends Set<GitRemote>> selectedRemotes) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRemotes, (String)"selectedRemotes");
            for (Map.Entry<GitRepository, ? extends Set<GitRemote>> entry : selectedRemotes.entrySet()) {
                GitRepository repository2 = entry.getKey();
                Set<GitRemote> remotes = entry.getValue();
                Git git = Git.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)git, (String)"getInstance(...)");
                GitConfigureRemotesDialogKt.removeRemotes$default(git, repository2, remotes, null, 8, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b \u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$SelectionHandlingModeAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "mode", "Lgit4idea/ui/branch/dashboard/BranchesDashboardTreeSelectionHandler$SelectionAction;", "<init>", "(Lgit4idea/ui/branch/dashboard/BranchesDashboardTreeSelectionHandler$SelectionAction;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "intellij.vcs.git"})
    public static abstract class SelectionHandlingModeAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final BranchesDashboardTreeSelectionHandler.SelectionAction mode;

        public SelectionHandlingModeAction(@NotNull BranchesDashboardTreeSelectionHandler.SelectionAction mode) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            this.mode = mode;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabledAndVisible(e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER()) != null);
            super.update(e);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BranchesDashboardTreeController branchesDashboardTreeController = (BranchesDashboardTreeController)e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            if (branchesDashboardTreeController == null) {
                return false;
            }
            BranchesDashboardTreeController controller = branchesDashboardTreeController;
            return controller.getSelectionAction() == this.mode;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BranchesDashboardTreeController branchesDashboardTreeController = (BranchesDashboardTreeController)e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            if (branchesDashboardTreeController == null) {
                return;
            }
            BranchesDashboardTreeController controller = branchesDashboardTreeController;
            controller.setSelectionAction(state2 ? this.mode : null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a8\u0006\u000e"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowArbitraryBranchesDiffAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesPairActionBase;", "<init>", "()V", "performAction", "", "project", "Lcom/intellij/openapi/project/Project;", "branchOne", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "branchTwo", "commonRepositories", "", "Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
    public static final class ShowArbitraryBranchesDiffAction
    extends BranchesPairActionBase {
        public ShowArbitraryBranchesDiffAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Compare.Selected.title", new Object[0]), GitBundleExtensions.INSTANCE.messagePointer("action.Git.Compare.Selected.description", new Object[0]), AllIcons.Actions.Diff);
        }

        @Override
        public void performAction(@NotNull Project project, @NotNull BranchInfo branchOne, @NotNull BranchInfo branchTwo, @NotNull Collection<? extends GitRepository> commonRepositories) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)branchOne, (String)"branchOne");
            Intrinsics.checkNotNullParameter((Object)branchTwo, (String)"branchTwo");
            Intrinsics.checkNotNullParameter(commonRepositories, (String)"commonRepositories");
            GitBrancher.getInstance(project).compareAny(branchOne.getBranchName(), branchTwo.getBranchName(), CollectionsKt.toList((Iterable)commonRepositories));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a8\u0006\u000e"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowArbitraryBranchesFileDiffAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesPairActionBase;", "<init>", "()V", "performAction", "", "project", "Lcom/intellij/openapi/project/Project;", "branchOne", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "branchTwo", "commonRepositories", "", "Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
    public static final class ShowArbitraryBranchesFileDiffAction
    extends BranchesPairActionBase {
        public ShowArbitraryBranchesFileDiffAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Compare.Selected.Heads.title", new Object[0]), GitBundleExtensions.INSTANCE.messagePointer("action.Git.Compare.Selected.Heads.description", new Object[0]), null);
        }

        @Override
        public void performAction(@NotNull Project project, @NotNull BranchInfo branchOne, @NotNull BranchInfo branchTwo, @NotNull Collection<? extends GitRepository> commonRepositories) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)branchOne, (String)"branchOne");
            Intrinsics.checkNotNullParameter((Object)branchTwo, (String)"branchTwo");
            Intrinsics.checkNotNullParameter(commonRepositories, (String)"commonRepositories");
            GitBrancher.getInstance(project).showDiff(branchOne.getBranchName(), branchTwo.getBranchName(), CollectionsKt.toList((Iterable)commonRepositories));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowBranchDiffAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "selection", "Lgit4idea/ui/branch/dashboard/BranchesTreeSelection;", "actionPerformed", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowBranchDiffAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,704:1\n2746#2,3:705\n1869#2,2:708\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowBranchDiffAction\n*L\n289#1:705,3\n300#1:708,2\n*E\n"})
    public static final class ShowBranchDiffAction
    extends BranchesActionBase {
        public ShowBranchDiffAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Compare.With.Current.title", new Object[0]), null, AllIcons.Actions.Diff, 2, null);
            this.setShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"Diff.ShowDiff"));
        }

        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches, @NotNull BranchesTreeSelection selection) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(branches, (String)"branches");
                Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
                Iterable $this$none$iv = branches;
                boolean $i$f$none = false;
                if (((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        BranchInfo it = (BranchInfo)element$iv;
                        boolean bl2 = false;
                        if (!(!it.isCurrent())) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (bl) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription(GitBundle.message((String)"action.Git.Update.Selected.description.select.non.current", (Object[])new Object[0]));
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            BranchesTreeSelection branchesTreeSelection = (BranchesTreeSelection)e.getData(BranchesDataKeysKt.getGIT_BRANCHES_TREE_SELECTION());
            if (branchesTreeSelection == null) {
                return;
            }
            BranchesTreeSelection selection = branchesTreeSelection;
            GitBrancher gitBrancher = GitBrancher.getInstance(project2);
            Iterable $this$forEach$iv = selection.getSelectedRefsToRepositories();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                RefInfo refInfo = (RefInfo)pair.component1();
                List repositories = (List)pair.component2();
                if (!(refInfo instanceof BranchInfo) || ((BranchInfo)refInfo).isCurrent()) continue;
                gitBrancher.compare(((BranchInfo)refInfo).getBranchName(), repositories);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000f"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowMyBranchesAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowMyBranchesAction\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,704:1\n168#2,3:705\n1740#3,3:708\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$ShowMyBranchesAction\n*L\n423#1:705,3\n429#1:708,3\n*E\n"})
    public static final class ShowMyBranchesAction
    extends ToggleAction
    implements DumbAware {
        public ShowMyBranchesAction() {
            super(() -> ShowMyBranchesAction._init_$lambda$0(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Show.My.Branches.title", new Object[0])), AllIcons.Actions.Find);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BranchesDashboardTreeController branchesDashboardTreeController = (BranchesDashboardTreeController)e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            if (branchesDashboardTreeController == null) {
                return false;
            }
            BranchesDashboardTreeController controller = branchesDashboardTreeController;
            return controller.getShowOnlyMy();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BranchesDashboardTreeController branchesDashboardTreeController = (BranchesDashboardTreeController)e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            if (branchesDashboardTreeController == null) {
                return;
            }
            BranchesDashboardTreeController controller = branchesDashboardTreeController;
            controller.setShowOnlyMy(state2);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean bl;
            boolean isGraphReady;
            boolean supportsIndexing;
            block10: {
                boolean bl2;
                VcsProjectLog log;
                Project project;
                block9: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    super.update(e);
                    project = (Project)e.getData(CommonDataKeys.PROJECT);
                    if (project == null) {
                        e.getPresentation().setEnabled(false);
                        return;
                    }
                    log = VcsProjectLog.Companion.getInstance(project);
                    Object object = log.getDataManager();
                    if (object != null && (object = object.getLogProviders()) != null) {
                        Object $this$all$iv = object;
                        boolean $i$f$all = false;
                        if ($this$all$iv.isEmpty()) {
                            bl2 = true;
                        } else {
                            Iterator iterator = $this$all$iv.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry element$iv;
                                Map.Entry it = element$iv = iterator.next();
                                boolean bl3 = false;
                                Object object2 = VcsLogProperties.SUPPORTS_INDEXING.getOrDefault((VcsLogProvider)it.getValue());
                                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrDefault(...)");
                                if (((Boolean)object2).booleanValue()) continue;
                                bl2 = false;
                                break block9;
                            }
                            bl2 = true;
                        }
                    } else {
                        bl2 = false;
                    }
                }
                supportsIndexing = bl2;
                VcsLogData vcsLogData = log.getDataManager();
                isGraphReady = vcsLogData != null && (vcsLogData = vcsLogData.getDataPack()) != null ? vcsLogData.isFull() : false;
                List<GitRepository> list = GitRepositoryManager.getInstance(project).getRepositories();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
                Iterable $this$all$iv = list;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl4 = false;
                        VcsLogData vcsLogData2 = log.getDataManager();
                        if (vcsLogData2 != null && (vcsLogData2 = vcsLogData2.getIndex()) != null ? vcsLogData2.isIndexed(it.getRoot()) : false) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            boolean allRootsIndexed = bl;
            e.getPresentation().setEnabled(supportsIndexing && isGraphReady && allRootsIndexed);
            e.getPresentation().setDescription(!supportsIndexing ? GitBundle.message((String)"action.Git.Show.My.Branches.description.not.support.indexing", (Object[])new Object[0]) : (!allRootsIndexed ? GitBundle.message((String)"action.Git.Show.My.Branches.description.not.all.roots.indexed", (Object[])new Object[0]) : (!isGraphReady ? GitBundle.message((String)"action.Git.Show.My.Branches.description.not.graph.ready", (Object[])new Object[0]) : GitBundle.message((String)"action.Git.Show.My.Branches.description.is.my.branch", (Object[])new Object[0]))));
        }

        private static final String _init_$lambda$0(Function0 $tmp0) {
            return (String)$tmp0.invoke();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$ToggleFavoriteAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$RefActionBase;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$ToggleFavoriteAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,704:1\n30#2,2:705\n1869#3,2:707\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$ToggleFavoriteAction\n*L\n456#1:705,2\n457#1:707,2\n*E\n"})
    public static final class ToggleFavoriteAction
    extends RefActionBase {
        public ToggleFavoriteAction() {
            Function0<String> function0 = GitBundleExtensions.INSTANCE.messagePointer("action.Git.Toggle.Favorite.title", new Object[0]);
            Icon icon = AllIcons.Nodes.Favorite;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Favorite");
            super(function0, icon);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            BranchesTreeSelection branchesTreeSelection = (BranchesTreeSelection)e.getData(BranchesDataKeysKt.getGIT_BRANCHES_TREE_SELECTION());
            if (branchesTreeSelection == null) {
                return;
            }
            BranchesTreeSelection selection = branchesTreeSelection;
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            GitBranchManager gitBranchManager = (GitBranchManager)((Object)object);
            Iterable $this$forEach$iv = selection.getSelectedRefsToRepositories();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                RefInfo refInfo = (RefInfo)pair.component1();
                List repositories = (List)pair.component2();
                GitRefType type = GitRefType.Companion.of$default((GitRefType.Companion)GitRefType.Companion, (GitReference)refInfo.getRef(), (boolean)false, (int)2, null);
                for (GitRepository repository2 : repositories) {
                    gitBranchManager.setFavorite((BranchType)type, repository2, refInfo.getRefName(), !refInfo.isFavorite());
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$UpdateBranchFilterInLogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.vcs.git"})
    public static final class UpdateBranchFilterInLogAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        /*
         * Unable to fully structure code
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getProject() == null || e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER()) == null) ** GOTO lbl-1000
            v0 = (BranchesTreeSelection)e.getData(BranchesDataKeysKt.getGIT_BRANCHES_TREE_SELECTION());
            var3_2 = v0 != null ? v0.getSelectedBranchFilters() : null;
            if (!(var3_2 == null || var3_2.isEmpty() != false) && e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT) instanceof BranchesTreeComponent) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            enabled = v1;
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BranchesDashboardTreeController branchesDashboardTreeController = (BranchesDashboardTreeController)e.getData(BranchesDataKeysKt.getBRANCHES_UI_CONTROLLER());
            if (branchesDashboardTreeController == null) {
                return;
            }
            BranchesDashboardTreeController controller = branchesDashboardTreeController;
            controller.updateLogBranchFilter();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0012"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$UpdateSelectedBranchAction;", "Lgit4idea/ui/branch/dashboard/BranchesDashboardActions$BranchesActionBase;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "branches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "selection", "Lgit4idea/ui/branch/dashboard/BranchesTreeSelection;", "actionPerformed", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nBranchesDashboardActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$UpdateSelectedBranchAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,704:1\n1#2:705\n1563#3:706\n1634#3,3:707\n1563#3:710\n1634#3,3:711\n*S KotlinDebug\n*F\n+ 1 BranchesDashboardActions.kt\ngit4idea/ui/branch/dashboard/BranchesDashboardActions$UpdateSelectedBranchAction\n*L\n186#1:706\n186#1:707,3\n202#1:710\n202#1:711,3\n*E\n"})
    public static final class UpdateSelectedBranchAction
    extends BranchesActionBase {
        public UpdateSelectedBranchAction() {
            super(GitBundleExtensions.INSTANCE.messagePointer("action.Git.Update.Selected.text", new Object[0]), null, AllIcons.Actions.CheckOut, 2, null);
        }

        @Override
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project != null) {
                Project p0 = project;
                boolean bl2 = false;
                bl = GitBranchActionsUtilKt.hasRemotes(p0);
            } else {
                bl = false;
            }
            boolean enabledAndVisible = bl;
            e.getPresentation().setEnabledAndVisible(enabledAndVisible);
            if (enabledAndVisible) {
                super.update(e);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Collection<BranchInfo> branches, @NotNull BranchesTreeSelection selection) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(branches, (String)"branches");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            Presentation presentation2 = presentation;
            if (GitFetchSupport.fetchSupport(project).isFetchRunning()) {
                presentation2.setEnabled(false);
                presentation2.setDescription(GitBundle.message((String)"action.Git.Update.Selected.description.already.running", (Object[])new Object[0]));
                return;
            }
            Set<GitRepository> selectedRepositories = selection.getRepositoriesOfSelectedBranches();
            Object[] $this$map$iv = (Object[])branches;
            boolean $i$f$map22 = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                BranchInfo branchInfo = (BranchInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getBranchName());
            }
            List branchNames = (List)destination$iv$iv;
            Object[] $i$f$map22 = GitVcsSettings.getInstance((Project)project).getUpdateMethod().name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string = $i$f$map22.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String updateMethodName = string;
            $i$f$map22 = new Object[]{branches.size(), updateMethodName};
            presentation2.setDescription(GitBundle.message((String)"action.Git.Update.Selected.description", (Object[])$i$f$map22));
            boolean trackingInfosExist = GitBranchActionsUtilKt.isTrackingInfosExist(branchNames, (Collection<? extends GitRepository>)selectedRepositories);
            presentation2.setEnabled(trackingInfosExist);
            if (!trackingInfosExist) {
                objectArray = new Object[]{branches.size()};
                presentation2.setDescription(GitBundle.message((String)"action.Git.Update.Selected.description.tracking.not.configured", (Object[])objectArray));
            }
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            BranchesTreeSelection branchesTreeSelection = (BranchesTreeSelection)e.getData(BranchesDataKeysKt.getGIT_BRANCHES_TREE_SELECTION());
            if (branchesTreeSelection == null) {
                return;
            }
            BranchesTreeSelection selection = branchesTreeSelection;
            List<BranchInfo> branches = selection.getSelectedBranches();
            Set<GitRepository> repositories = selection.getRepositoriesOfSelectedBranches();
            Iterable $this$map$iv = branches;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                BranchInfo branchInfo = (BranchInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getBranchName());
            }
            List branchNames = (List)destination$iv$iv;
            GitBranchActionsUtilKt.updateBranches(project2, (Collection<? extends GitRepository>)repositories, branchNames);
        }
    }
}

