/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.statistics;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ui.ProfilerTabComponentNameWithId;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/statistics/FusAwareTreeExpansionListener;", "Ljavax/swing/event/TreeExpansionListener;", "project", "Lcom/intellij/openapi/project/Project;", "componentId", "Lcom/intellij/profiler/ui/ProfilerTabComponentNameWithId;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ui/ProfilerTabComponentNameWithId;)V", "treeExpanded", "", "event", "Ljavax/swing/event/TreeExpansionEvent;", "treeCollapsed", "Companion", "intellij.profiler.common"})
public final class FusAwareTreeExpansionListener
implements TreeExpansionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ProfilerTabComponentNameWithId componentId;
    @NotNull
    private static final Key<Boolean> SUPPRESS_EXPANSION_LOGGING;

    public FusAwareTreeExpansionListener(@NotNull Project project, @NotNull ProfilerTabComponentNameWithId componentId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)componentId, (String)"componentId");
        this.project = project;
        this.componentId = componentId;
    }

    @Override
    public void treeExpanded(@NotNull TreeExpansionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getSource();
        JTree jTree = object instanceof JTree ? (JTree)object : null;
        if (jTree == null) {
            return;
        }
        JTree tree = jTree;
        if (!Intrinsics.areEqual((Object)tree.getClientProperty(SUPPRESS_EXPANSION_LOGGING), (Object)true)) {
            ProfilerUsageTriggerCollector.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.INSTANCE, this.project, ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.PROFILER_TREE_EXPAND, this.componentId, null, 8, null);
        }
    }

    @Override
    public void treeCollapsed(@NotNull TreeExpansionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getSource();
        JTree jTree = object instanceof JTree ? (JTree)object : null;
        if (jTree == null) {
            return;
        }
        JTree tree = jTree;
        if (!Intrinsics.areEqual((Object)tree.getClientProperty(SUPPRESS_EXPANSION_LOGGING), (Object)true)) {
            ProfilerUsageTriggerCollector.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.INSTANCE, this.project, ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.PROFILER_TREE_COLLAPSE, this.componentId, null, 8, null);
        }
    }

    static {
        Key key = Key.create((String)"do not record treeExpanded events");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SUPPRESS_EXPANSION_LOGGING = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e\u00a2\u0006\u0002\u0010\u000fR!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/statistics/FusAwareTreeExpansionListener$Companion;", "", "<init>", "()V", "SUPPRESS_EXPANSION_LOGGING", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "underSuppressedExpansion", "T", "tree", "Ljavax/swing/JTree;", "block", "Lkotlin/Function0;", "(Ljavax/swing/JTree;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T underSuppressedExpansion(@NotNull JTree tree, @NotNull Function0<? extends T> block) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            tree.putClientProperty(SUPPRESS_EXPANSION_LOGGING, true);
            try {
                Object object = block.invoke();
                return (T)object;
            }
            finally {
                tree.putClientProperty(SUPPRESS_EXPANSION_LOGGING, false);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

