/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters.curl.exceptions;

import com.intellij.httpClient.converters.curl.exceptions.CurlParseErrorType;
import com.intellij.httpClient.execution.RestClientBundle;
import java.io.UnsupportedEncodingException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CurlParseException
extends RuntimeException {
    private final CurlParseErrorType myType;

    public CurlParseException(@NotNull CurlParseErrorType type, @Nls String message) {
        if (type == null) {
            CurlParseException.$$$reportNull$$$0(0);
        }
        super(message);
        this.myType = type;
    }

    @NotNull
    public CurlParseErrorType getType() {
        CurlParseErrorType curlParseErrorType = this.myType;
        if (curlParseErrorType == null) {
            CurlParseException.$$$reportNull$$$0(1);
        }
        return curlParseErrorType;
    }

    @NotNull
    public static CurlParseException newNotCurlException() {
        return new CurlParseException(CurlParseErrorType.NOT_A_CURL, RestClientBundle.message("http.request.convert.curl.is.not.curl", new Object[0]));
    }

    @NotNull
    public static CurlParseException newNoUrlException() {
        return new CurlParseException(CurlParseErrorType.NO_URL, RestClientBundle.message("http.request.convert.curl.no.url", new Object[0]));
    }

    @NotNull
    public static CurlParseException newInvalidUrlException(@NotNull String url) {
        if (url == null) {
            CurlParseException.$$$reportNull$$$0(2);
        }
        return new CurlParseException(CurlParseErrorType.INVALID_URL, RestClientBundle.message("http.request.convert.curl.invalid.url", url));
    }

    @NotNull
    public static CurlParseException newInvalidMethodException(@NotNull String method) {
        if (method == null) {
            CurlParseException.$$$reportNull$$$0(3);
        }
        return new CurlParseException(CurlParseErrorType.INVALID_HTTP_METHOD, RestClientBundle.message("http.request.convert.curl.method.not.supported", method));
    }

    @NotNull
    public static CurlParseException newMethodDoNotSupportBodyException(@NotNull String method) {
        if (method == null) {
            CurlParseException.$$$reportNull$$$0(4);
        }
        return new CurlParseException(CurlParseErrorType.METHOD_DO_NOT_SUPPORT_BODY, RestClientBundle.message("http.request.convert.curl.method.do.not.support.body", method));
    }

    @NotNull
    public static CurlParseException newNoRequiredOptionDataException(@NotNull String option) {
        if (option == null) {
            CurlParseException.$$$reportNull$$$0(5);
        }
        return new CurlParseException(CurlParseErrorType.INCOMPLETE_OPTION, RestClientBundle.message("http.request.convert.curl.no.data", option));
    }

    @NotNull
    public static CurlParseException newInvalidHeaderException(@NotNull String header) {
        if (header == null) {
            CurlParseException.$$$reportNull$$$0(6);
        }
        return new CurlParseException(CurlParseErrorType.INVALID_HEADER, RestClientBundle.message("http.request.convert.curl.invalid.header", header));
    }

    @NotNull
    public static CurlParseException newInvalidPathException(@NotNull String formData) {
        if (formData == null) {
            CurlParseException.$$$reportNull$$$0(7);
        }
        return new CurlParseException(CurlParseErrorType.INVALID_FORM_DATA, RestClientBundle.message("http.request.convert.curl.custom.path.in.form.data", formData));
    }

    @NotNull
    public static CurlParseException newUnsupportedEncodingException(@NotNull UnsupportedEncodingException e) {
        if (e == null) {
            CurlParseException.$$$reportNull$$$0(8);
        }
        return new CurlParseException(CurlParseErrorType.UNSUPPORTED_ENCODING, e.getMessage());
    }

    @NotNull
    public static CurlParseException newInvalidFormDataException(@NotNull String formData) {
        if (formData == null) {
            CurlParseException.$$$reportNull$$$0(9);
        }
        return new CurlParseException(CurlParseErrorType.INVALID_FORM_DATA, RestClientBundle.message("http.request.convert.curl.form.data.no.value", formData));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/converters/curl/exceptions/CurlParseException";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/converters/curl/exceptions/CurlParseException";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "newInvalidUrlException";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "newInvalidMethodException";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newMethodDoNotSupportBodyException";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newNoRequiredOptionDataException";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newInvalidHeaderException";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newInvalidPathException";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newUnsupportedEncodingException";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newInvalidFormDataException";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

