/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.util;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.softwrap.EmptySoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u001a\u001c\u0010\u0011\u001a\u00020\u0012*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\"\u0010\u0016\u001a\u00020\u0012*\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a$\u0010\u0018\u001a\u00020\u0012*\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0000\u001a*\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u001a\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u001a\u0018\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\"4\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002*\u00020\f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"OLD_STRINGS_KEY", "Lcom/intellij/openapi/util/Key;", "", "", "decoder", "Lcom/intellij/execution/process/AnsiEscapeDecoder;", "getDecoder", "()Lcom/intellij/execution/process/AnsiEscapeDecoder;", "decoder$delegate", "Lkotlin/Lazy;", "value", "oldStrings", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "getOldStrings", "(Lcom/intellij/execution/impl/ConsoleViewImpl;)Ljava/util/List;", "setOldStrings", "(Lcom/intellij/execution/impl/ConsoleViewImpl;Ljava/util/List;)V", "printLine", "", "line", "processOutputType", "Lcom/intellij/execution/process/ProcessOutputType;", "printLines", "lines", "setContent", "strings", "calculateLinesToAppend", "currentLines", "newLines", "filterLastNewLine", "calculateLineUpdate", "first", "second", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nConsoleViewUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleViewUtils.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/util/ConsoleViewUtilsKt\n+ 2 UiUtils.kt\ncom/intellij/openapi/ui/UiUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n56#2:146\n1#3:147\n1869#4,2:148\n*S KotlinDebug\n*F\n+ 1 ConsoleViewUtils.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/util/ConsoleViewUtilsKt\n*L\n21#1:146\n37#1:148,2\n*E\n"})
public final class ConsoleViewUtilsKt {
    @NotNull
    private static final Key<List<String>> OLD_STRINGS_KEY = new Key("OLD_STRINGS_KEY");
    @NotNull
    private static final Lazy decoder$delegate = LazyKt.lazy(ConsoleViewUtilsKt::decoder_delegate$lambda$0);

    private static final AnsiEscapeDecoder getDecoder() {
        Lazy lazy = decoder$delegate;
        return (AnsiEscapeDecoder)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getOldStrings(@NotNull ConsoleViewImpl $this$oldStrings) {
        Object object;
        void $this$getUserData$iv;
        Intrinsics.checkNotNullParameter((Object)$this$oldStrings, (String)"<this>");
        Object object2 = (JComponent)$this$oldStrings;
        Key<List<String>> key$iv = OLD_STRINGS_KEY;
        boolean $i$f$getUserData = false;
        Object object3 = $this$getUserData$iv.getClientProperty(key$iv);
        if (!(object3 instanceof List)) {
            object3 = null;
        }
        if ((object = (List)object3) == null) {
            Object it = object2 = CollectionsKt.emptyList();
            boolean bl = false;
            ConsoleViewUtilsKt.setOldStrings($this$oldStrings, (List<String>)it);
            object = object2;
        }
        return object;
    }

    public static final void setOldStrings(@NotNull ConsoleViewImpl $this$oldStrings, @NotNull List<String> value) {
        Intrinsics.checkNotNullParameter((Object)$this$oldStrings, (String)"<this>");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        UiUtils.putUserData((JComponent)((JComponent)$this$oldStrings), OLD_STRINGS_KEY, value);
    }

    public static final void printLine(@NotNull ConsoleViewImpl $this$printLine, @NotNull String line, @NotNull ProcessOutputType processOutputType) {
        Intrinsics.checkNotNullParameter((Object)$this$printLine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)processOutputType, (String)"processOutputType");
        ConsoleViewUtilsKt.getDecoder().escapeText(line, (Key)processOutputType, (arg_0, arg_1) -> ConsoleViewUtilsKt.printLine$lambda$2(processOutputType, $this$printLine, arg_0, arg_1));
    }

    private static final void printLines(ConsoleViewImpl $this$printLines, List<String> lines, ProcessOutputType processOutputType) {
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ConsoleViewUtilsKt.printLine($this$printLines, it, processOutputType);
        }
    }

    public static final void setContent(@NotNull ConsoleViewImpl $this$setContent, @NotNull List<String> strings, @NotNull ProcessOutputType processOutputType) {
        Intrinsics.checkNotNullParameter((Object)$this$setContent, (String)"<this>");
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)processOutputType, (String)"processOutputType");
        ThreadingAssertions.assertEventDispatchThread();
        if (Intrinsics.areEqual(ConsoleViewUtilsKt.getOldStrings($this$setContent), strings)) {
            return;
        }
        List<String> newStrings = ConsoleViewUtilsKt.calculateLinesToAppend(ConsoleViewUtilsKt.getOldStrings($this$setContent), strings);
        ConsoleViewUtilsKt.printLines($this$setContent, newStrings, processOutputType);
        ApplicationManager.getApplication().runWriteIntentReadAction(() -> ConsoleViewUtilsKt.setContent$lambda$4($this$setContent));
        if (ConsoleViewUtilsKt.getOldStrings($this$setContent).isEmpty()) {
            $this$setContent.scrollTo(0);
        }
        ConsoleViewUtilsKt.setOldStrings($this$setContent, CollectionsKt.toList((Iterable)strings));
    }

    public static /* synthetic */ void setContent$default(ConsoleViewImpl consoleViewImpl, List list, ProcessOutputType processOutputType, int n, Object object) {
        if ((n & 2) != 0) {
            ProcessOutputType processOutputType2 = ProcessOutputType.STDOUT;
            Intrinsics.checkNotNullExpressionValue((Object)processOutputType2, (String)"STDOUT");
            processOutputType = processOutputType2;
        }
        ConsoleViewUtilsKt.setContent(consoleViewImpl, list, processOutputType);
    }

    private static final List<String> calculateLinesToAppend(List<String> currentLines, List<String> newLines) {
        int countOfLinesToRemove;
        boolean haveLineToUpdate;
        int i;
        if (currentLines.isEmpty()) {
            return ConsoleViewUtilsKt.filterLastNewLine(newLines);
        }
        int minSize = Math.min(currentLines.size(), newLines.size());
        for (i = 0; i < minSize && Intrinsics.areEqual((Object)currentLines.get(i), (Object)newLines.get(i)); ++i) {
        }
        List result = new ArrayList();
        boolean bl = haveLineToUpdate = i < currentLines.size() && i < newLines.size();
        if (i < currentLines.size() && (countOfLinesToRemove = currentLines.size() - i - (haveLineToUpdate ? 1 : 0)) > 0) {
            Collection collection = result;
            int n = 0;
            char[] cArray = new char[countOfLinesToRemove];
            while (n < countOfLinesToRemove) {
                int n2 = n++;
                cArray[n2] = 13;
            }
            Object object = cArray;
            object = new String((char[])object);
            collection.add(object);
        }
        if (haveLineToUpdate) {
            ((Collection)result).add(ConsoleViewUtilsKt.calculateLineUpdate(currentLines.get(i), newLines.get(i)));
        }
        if (i < newLines.size()) {
            ((Collection)result).add("\n");
            CollectionsKt.addAll((Collection)result, (Iterable)newLines.subList(i + (haveLineToUpdate ? 1 : 0), newLines.size()));
        }
        return ConsoleViewUtilsKt.filterLastNewLine(result);
    }

    private static final List<String> filterLastNewLine(List<String> newLines) {
        List list;
        String string = (String)CollectionsKt.lastOrNull(newLines);
        boolean bl = string != null ? StringsKt.endsWith$default((String)string, (String)"\r\n", (boolean)false, (int)2, null) : false;
        if (bl) {
            String lastLine = (String)CollectionsKt.last(newLines);
            list = CollectionsKt.plus((Collection)CollectionsKt.dropLast(newLines, (int)1), (Object)StringsKt.dropLast((String)lastLine, (int)2));
        } else {
            String string2 = (String)CollectionsKt.lastOrNull(newLines);
            boolean bl2 = string2 != null ? StringsKt.endsWith$default((String)string2, (String)"\n", (boolean)false, (int)2, null) : false;
            if (bl2) {
                String lastLine = (String)CollectionsKt.last(newLines);
                list = CollectionsKt.plus((Collection)CollectionsKt.dropLast((List)newLines, (int)1), (Object)StringsKt.dropLast((String)lastLine, (int)1));
            } else {
                list = newLines;
            }
        }
        return list;
    }

    private static final String calculateLineUpdate(String first, String second) {
        Object object;
        int indexOfDifference;
        if (((CharSequence)first).length() == 0) {
            return second;
        }
        int common = Math.min(first.length(), second.length());
        for (indexOfDifference = 0; indexOfDifference < common && first.charAt(indexOfDifference) == second.charAt(indexOfDifference); ++indexOfDifference) {
        }
        if (indexOfDifference < first.length() / 2) {
            object = "\rsecond";
        } else {
            int n = 0;
            int n2 = first.length() - indexOfDifference;
            char[] cArray = new char[n2];
            while (n < n2) {
                int n3 = n++;
                cArray[n3] = 8;
            }
            char[] cArray2 = cArray;
            String string = new String(cArray2);
            String string2 = second.substring(indexOfDifference);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            object = string + string2;
        }
        return object;
    }

    private static final AnsiEscapeDecoder decoder_delegate$lambda$0() {
        return new AnsiEscapeDecoder();
    }

    private static final void printLine$lambda$2(ProcessOutputType $processOutputType, ConsoleViewImpl $this_printLine, String text, Key attributes) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Key key = JupyterSettings.Companion.getInstance().getAllowASCIIColoringInErrorOutputs() || !Intrinsics.areEqual((Object)$processOutputType, (Object)ProcessOutputType.STDERR) ? attributes : (Key)$processOutputType;
        Intrinsics.checkNotNull((Object)key);
        Key attr = key;
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType((Key)attr);
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"getConsoleViewType(...)");
        $this_printLine.print(text, consoleViewContentType);
    }

    private static final Unit setContent$lambda$4(ConsoleViewImpl $this_setContent) {
        Editor editor = $this_setContent.getEditor();
        EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
        if (editorImpl != null && (editorImpl = editorImpl.getSoftWrapModel()) != null) {
            editorImpl.setSoftWrapPainter((SoftWrapPainter)EmptySoftWrapPainter.INSTANCE);
        }
        $this_setContent.flushDeferredText();
        return Unit.INSTANCE;
    }
}

