/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.qunit;

import com.google.common.collect.Maps;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.JsTestSelector;
import com.intellij.javascript.testFramework.qunit.AbstractQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.DefaultQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitStructureElement;
import com.intellij.javascript.testFramework.qunit.QUnitTestMethodStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QUnitFileStructure
extends AbstractTestFileStructure {
    private final List<QUnitModuleStructure> myNonDefaultModuleStructures;
    private final Map<String, QUnitModuleStructure> myNonDefaultModuleStructureByNameMap;
    private final DefaultQUnitModuleStructure myDefaultModuleStructure;
    private Map<JSCallExpression, QUnitStructureElement> myStructureElementByPsiElementMap;
    private Map<LeafPsiElement, QUnitStructureElement> myStructureElementByNameLiteralElementMap;
    @Nullable
    Set<String> elementPathsCache;
    @Nullable
    String lastElementsPathsDelimiterCache;

    public QUnitFileStructure(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            QUnitFileStructure.$$$reportNull$$$0(0);
        }
        super(jsFile);
        this.myNonDefaultModuleStructures = new ArrayList<QUnitModuleStructure>();
        this.myNonDefaultModuleStructureByNameMap = Maps.newHashMap();
        this.myDefaultModuleStructure = new DefaultQUnitModuleStructure(this);
        this.elementPathsCache = null;
        this.lastElementsPathsDelimiterCache = null;
    }

    @Override
    public boolean isEmpty() {
        return !this.hasQUnitSymbols();
    }

    @NotNull
    public List<QUnitModuleStructure> getNonDefaultModuleStructures() {
        List<QUnitModuleStructure> list = this.myNonDefaultModuleStructures;
        if (list == null) {
            QUnitFileStructure.$$$reportNull$$$0(1);
        }
        return list;
    }

    public int getAllModuleCount() {
        return this.myNonDefaultModuleStructures.size() + 1;
    }

    public int getNonDefaultModuleCount() {
        return this.myNonDefaultModuleStructures.size();
    }

    public void addModuleStructure(@NotNull QUnitModuleStructure moduleStructure) {
        if (moduleStructure == null) {
            QUnitFileStructure.$$$reportNull$$$0(2);
        }
        this.myNonDefaultModuleStructureByNameMap.put(moduleStructure.getName(), moduleStructure);
        this.myNonDefaultModuleStructures.add(moduleStructure);
    }

    @Nullable
    public AbstractQUnitModuleStructure findQUnitModuleByName(@NotNull String qunitModuleName) {
        AbstractQUnitModuleStructure moduleStructure;
        if (qunitModuleName == null) {
            QUnitFileStructure.$$$reportNull$$$0(3);
        }
        if ((moduleStructure = (AbstractQUnitModuleStructure)this.myNonDefaultModuleStructureByNameMap.get(qunitModuleName)) == null && this.myDefaultModuleStructure.getName().equals(qunitModuleName)) {
            moduleStructure = this.myDefaultModuleStructure;
        }
        return moduleStructure;
    }

    @NotNull
    public DefaultQUnitModuleStructure getDefaultModuleStructure() {
        DefaultQUnitModuleStructure defaultQUnitModuleStructure = this.myDefaultModuleStructure;
        if (defaultQUnitModuleStructure == null) {
            QUnitFileStructure.$$$reportNull$$$0(4);
        }
        return defaultQUnitModuleStructure;
    }

    public boolean hasQUnitSymbols() {
        return this.myDefaultModuleStructure.getTestCount() > 0 || this.getNonDefaultModuleCount() > 0;
    }

    @Nullable
    public QUnitModuleStructure findModuleStructureContainingOffset(int offset) {
        for (QUnitModuleStructure moduleStructure : this.myNonDefaultModuleStructures) {
            TextRange moduleTextRange = moduleStructure.getEnclosingCallExpression().getTextRange();
            if (!JsPsiUtils.containsOffsetStrictly(moduleTextRange, offset)) continue;
            return moduleStructure;
        }
        return null;
    }

    @Nullable
    public QUnitTestMethodStructure findTestMethodStructureContainingOffset(int offset) {
        QUnitTestMethodStructure testMethodStructure = this.myDefaultModuleStructure.findTestMethodStructureContainingOffset(offset);
        if (testMethodStructure != null) {
            return testMethodStructure;
        }
        for (QUnitModuleStructure moduleStructure : this.myNonDefaultModuleStructures) {
            testMethodStructure = moduleStructure.findTestMethodStructureContainingOffset(offset);
            if (testMethodStructure == null) continue;
            return testMethodStructure;
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement findPsiElement(@NotNull JsTestSelector selector) {
        AbstractQUnitModuleStructure qunitModuleStructure;
        if (selector == null) {
            QUnitFileStructure.$$$reportNull$$$0(5);
        }
        String testCaseName = (String)ContainerUtil.getFirstItem(selector.getNames());
        String testMethodName = (String)ContainerUtil.getOrElse(selector.getNames(), (int)1, null);
        if (testCaseName != null && (qunitModuleStructure = this.findQUnitModuleByName(testCaseName)) != null) {
            if (testMethodName != null) {
                QUnitTestMethodStructure test = qunitModuleStructure.getTestMethodStructureByName(testMethodName);
                if (test != null) {
                    return test.getEnclosingCallExpression();
                }
            } else {
                QUnitModuleStructure nonDefault = (QUnitModuleStructure)ObjectUtils.tryCast((Object)qunitModuleStructure, QUnitModuleStructure.class);
                if (nonDefault != null) {
                    return nonDefault.getEnclosingCallExpression();
                }
            }
        }
        return null;
    }

    public List<AbstractQUnitModuleStructure> getChildren() {
        ArrayList<AbstractQUnitModuleStructure> result2 = new ArrayList<AbstractQUnitModuleStructure>(this.myNonDefaultModuleStructures);
        result2.add((QUnitModuleStructure)((Object)this.myDefaultModuleStructure));
        return result2;
    }

    @Override
    @Nullable
    public JsTestElementPath findTestElementPath(@NotNull TextRange textRange) {
        if (textRange == null) {
            QUnitFileStructure.$$$reportNull$$$0(6);
        }
        for (JSCallExpression callExpression : this.myStructureElementByPsiElementMap.keySet()) {
            if (!callExpression.getTextRange().contains(textRange)) continue;
            return QUnitFileStructure.toTestElementPath(this.myStructureElementByPsiElementMap.get(callExpression));
        }
        return null;
    }

    @Override
    @Nullable
    public JsTestElementPath findTestElementPath(@NotNull PsiElement testIdentifierLeafElement) {
        if (testIdentifierLeafElement == null) {
            QUnitFileStructure.$$$reportNull$$$0(7);
        }
        return QUnitFileStructure.toTestElementPath(this.myStructureElementByNameLiteralElementMap.get(testIdentifierLeafElement));
    }

    @Nullable
    private static JsTestElementPath toTestElementPath(@Nullable QUnitStructureElement structureElement) {
        if (structureElement == null) {
            return null;
        }
        boolean isSuite = structureElement instanceof QUnitModuleStructure;
        String name = structureElement.getName();
        JSCallExpression callExpression = structureElement.getEnclosingCallExpression();
        if (isSuite) {
            return new JsTestElementPath(Collections.singletonList(name), null, (PsiElement)callExpression);
        }
        return new JsTestElementPath(Collections.emptyList(), name, (PsiElement)callExpression);
    }

    void postProcess() {
        this.buildMappingByPsiElements();
    }

    private void buildMappingByPsiElements() {
        Map structureElementByNameLiteralElementMap;
        Map structureElementByPsiElementMap;
        int count = this.getStructureElementsCount();
        if (count == 0) {
            structureElementByPsiElementMap = Collections.emptyMap();
            structureElementByNameLiteralElementMap = Collections.emptyMap();
        } else {
            structureElementByPsiElementMap = new IdentityHashMap(count);
            structureElementByNameLiteralElementMap = new IdentityHashMap(count);
            this.walkStructure(moduleStructure -> {
                JSCallExpression moduleElement = moduleStructure.getEnclosingCallExpression();
                structureElementByPsiElementMap.put(moduleElement, moduleStructure);
                LeafPsiElement nameElement = moduleStructure.getNameLeafPsiElement();
                if (nameElement != null) {
                    structureElementByNameLiteralElementMap.put(nameElement, moduleStructure);
                }
            }, testMethodStructure -> {
                JSCallExpression methodElement = testMethodStructure.getEnclosingCallExpression();
                structureElementByPsiElementMap.put(methodElement, testMethodStructure);
                LeafPsiElement nameElement = testMethodStructure.getNameLeafPsiElement();
                if (nameElement != null) {
                    structureElementByNameLiteralElementMap.put(nameElement, testMethodStructure);
                }
            });
        }
        this.myStructureElementByPsiElementMap = structureElementByPsiElementMap;
        this.myStructureElementByNameLiteralElementMap = structureElementByNameLiteralElementMap;
    }

    private int getStructureElementsCount() {
        int count = this.myDefaultModuleStructure.getTestCount();
        for (QUnitModuleStructure nonDefaultModuleStructure : this.myNonDefaultModuleStructures) {
            count += nonDefaultModuleStructure.getTestCount() + 1;
        }
        return count;
    }

    private void walkStructure(@NotNull @NotNull Consumer<@NotNull QUnitModuleStructure> consumeModule, @NotNull @NotNull Consumer<@NotNull QUnitTestMethodStructure> consumeTest) {
        if (consumeModule == null) {
            QUnitFileStructure.$$$reportNull$$$0(8);
        }
        if (consumeTest == null) {
            QUnitFileStructure.$$$reportNull$$$0(9);
        }
        for (QUnitModuleStructure moduleStructure : this.myNonDefaultModuleStructures) {
            consumeModule.accept(moduleStructure);
            QUnitFileStructure.walkModule(moduleStructure, consumeTest);
        }
        QUnitFileStructure.walkModule(this.myDefaultModuleStructure, consumeTest);
    }

    private static void walkModule(@NotNull AbstractQUnitModuleStructure moduleStructure, @NotNull @NotNull Consumer<@NotNull QUnitTestMethodStructure> consumeTest) {
        if (moduleStructure == null) {
            QUnitFileStructure.$$$reportNull$$$0(10);
        }
        if (consumeTest == null) {
            QUnitFileStructure.$$$reportNull$$$0(11);
        }
        for (QUnitTestMethodStructure testMethodStructure : moduleStructure.getTestMethodStructures()) {
            consumeTest.accept(testMethodStructure);
        }
    }

    public void forEachTest(@NotNull Consumer<QUnitTestMethodStructure> testConsumer) {
        if (testConsumer == null) {
            QUnitFileStructure.$$$reportNull$$$0(12);
        }
        this.myDefaultModuleStructure.forEachTest(testConsumer);
        for (QUnitModuleStructure module : this.myNonDefaultModuleStructures) {
            module.forEachTest(testConsumer);
        }
    }

    @NotNull
    public Set<String> collectElementPaths(@NotNull String elementsPathsDelimiter) {
        if (elementsPathsDelimiter == null) {
            QUnitFileStructure.$$$reportNull$$$0(13);
        }
        if (this.elementPathsCache == null || this.lastElementsPathsDelimiterCache == null || !this.lastElementsPathsDelimiterCache.equals(elementsPathsDelimiter)) {
            this.lastElementsPathsDelimiterCache = elementsPathsDelimiter;
            this.elementPathsCache = new HashSet<String>();
            DefaultQUnitModuleStructure defaultQUnitModuleStructure = this.getDefaultModuleStructure();
            for (QUnitTestMethodStructure testMethodStructure : defaultQUnitModuleStructure.getTestMethodStructures()) {
                this.elementPathsCache.add(testMethodStructure.getName());
            }
            for (QUnitModuleStructure moduleStructure : this.getNonDefaultModuleStructures()) {
                String moduleName = moduleStructure.getName();
                this.elementPathsCache.add(moduleName);
                for (QUnitTestMethodStructure testMethodStructure : moduleStructure.getTestMethodStructures()) {
                    this.elementPathsCache.add(moduleName + elementsPathsDelimiter + testMethodStructure.getName());
                }
            }
        }
        Set<String> set = this.elementPathsCache;
        if (set == null) {
            QUnitFileStructure.$$$reportNull$$$0(14);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 1: 
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/qunit/QUnitFileStructure";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleStructure";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qunitModuleName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testIdentifierLeafElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumeModule";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumeTest";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testConsumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsPathsDelimiter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/qunit/QUnitFileStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonDefaultModuleStructures";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultModuleStructure";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectElementPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addModuleStructure";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findQUnitModuleByName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPsiElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findTestElementPath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "walkStructure";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "walkModule";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "forEachTest";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectElementPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 14 -> new IllegalStateException(string);
        };
    }
}

