/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.navigation;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.testFramework.util.PresentableTestNameKt;
import com.intellij.javascript.testing.navigation.JsTestNavigationItemKt;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000e\u001a\u00070\u0004\u00a2\u0006\u0002\b\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/testing/navigation/JsTestNavigationItem;", "Lcom/intellij/navigation/NavigationItem;", "testNames", "", "", "jsFile", "Lcom/intellij/lang/javascript/psi/JSFile;", "icon", "Ljavax/swing/Icon;", "<init>", "(Ljava/util/List;Lcom/intellij/lang/javascript/psi/JSFile;Ljavax/swing/Icon;)V", "presentableName", "getPresentableName", "()Ljava/lang/String;", "getName", "Lcom/intellij/openapi/util/NlsSafe;", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "navigate", "", "requestFocus", "", "canNavigate", "canNavigateToSource", "intellij.javascript.impl"})
public final class JsTestNavigationItem
implements NavigationItem {
    @NotNull
    private final List<String> testNames;
    @NotNull
    private final JSFile jsFile;
    @NotNull
    private final Icon icon;
    @NotNull
    private final String presentableName;

    public JsTestNavigationItem(@NotNull List<String> testNames, @NotNull JSFile jsFile, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter(testNames, (String)"testNames");
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.testNames = testNames;
        this.jsFile = jsFile;
        this.icon = icon;
        this.presentableName = PresentableTestNameKt.createPresentableTestName(this.testNames);
    }

    @NotNull
    public final String getPresentableName() {
        return this.presentableName;
    }

    @NotNull
    public String getName() {
        return this.presentableName;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ItemPresentation(this){
            final /* synthetic */ JsTestNavigationItem this$0;
            {
                this.this$0 = $receiver;
            }

            public String getPresentableText() {
                return this.this$0.getPresentableName();
            }

            public String getLocationString() {
                String string = JsTestNavigationItem.access$getJsFile$p(this.this$0).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return string;
            }

            public Icon getIcon(boolean unused) {
                return JsTestNavigationItem.access$getIcon$p(this.this$0);
            }
        };
    }

    public void navigate(boolean requestFocus) {
        block4: {
            Navigatable descriptor = null;
            PsiElement testStructureElement = JsTestNavigationItemKt.access$tryToFindTestStructureElementForNavigation(this.testNames, this.jsFile);
            if (testStructureElement != null) {
                VirtualFile file;
                if (testStructureElement instanceof JSLiteralExpression && (file = ((JSLiteralExpression)testStructureElement).getContainingFile().getVirtualFile()) != null) {
                    descriptor = PsiNavigationSupport.getInstance().createNavigatable(((JSLiteralExpression)testStructureElement).getProject(), file, ((JSLiteralExpression)testStructureElement).getTextOffset() + 1);
                }
                if (descriptor == null) {
                    descriptor = PsiNavigationSupport.getInstance().getDescriptor(testStructureElement);
                }
            } else {
                descriptor = PsiNavigationSupport.getInstance().getDescriptor((PsiElement)this.jsFile);
            }
            Navigatable navigatable = descriptor;
            if (navigatable == null) break block4;
            navigatable.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate((PsiElement)this.jsFile);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public static final /* synthetic */ JSFile access$getJsFile$p(JsTestNavigationItem $this) {
        return $this.jsFile;
    }

    public static final /* synthetic */ Icon access$getIcon$p(JsTestNavigationItem $this) {
        return $this.icon;
    }
}

