/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.watch;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.testing.watch.JsTestWatchProvider;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ExecutionDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import icons.JavaScriptLanguageIcons;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J0\u0010\u0012\u001a\n\u0012\u0004\u0012\u0002H\u0013\u0018\u00010\u0010\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/javascript/testing/watch/JsTestWatchToggleAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "requireContext", "Lcom/intellij/javascript/testing/watch/JsTestWatchToggleAction$Context;", "getContext", "createIfMatched", "T", "Lcom/intellij/execution/configurations/RunConfiguration;", "runConfiguration", "provider", "Lcom/intellij/javascript/testing/watch/JsTestWatchProvider;", "Context", "intellij.javascript.impl"})
public final class JsTestWatchToggleAction
extends ToggleAction
implements DumbAware {
    public JsTestWatchToggleAction() {
        super(JavaScriptBundle.messagePointer("js.testing.autoWatch.action.name", new Object[0]), JavaScriptLanguageIcons.Testing.TestRunnerWatch);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this.requireContext(e).isWatchEnabled();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.requireContext(e).setWatchedEnabled(state);
        if (state) {
            ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)e.getData(ExecutionDataKeys.EXECUTION_ENVIRONMENT);
            if (executionEnvironment == null) {
                return;
            }
            ExecutionEnvironment executionEnvironment2 = executionEnvironment;
            RunContentDescriptor runContentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
            if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
                return;
            }
            RunContentDescriptor processHandler = runContentDescriptor;
            if (processHandler.isProcessTerminated()) {
                ExecutionUtil.restart((ExecutionEnvironment)executionEnvironment2);
            } else {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(executionEnvironment2){
                    final /* synthetic */ ExecutionEnvironment $executionEnvironment;
                    {
                        this.$executionEnvironment = $executionEnvironment;
                    }

                    public void processTerminated(ProcessEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        ExecutionUtil.restart((ExecutionEnvironment)this.$executionEnvironment);
                    }
                });
            }
        } else {
            RunContentDescriptor runContentDescriptor;
            RunContentDescriptor runContentDescriptor2 = runContentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
            ProcessHandler processHandler = runContentDescriptor2 != null ? runContentDescriptor2.getProcessHandler() : null;
            Project project = e.getProject();
            if (processHandler != null && !processHandler.isProcessTerminated() && project != null) {
                MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)runContentDescriptor);
                Topic topic = SMTRunnerEventsListener.TEST_STATUS;
                Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TEST_STATUS");
                messageBusConnection.subscribe(topic, (Object)new SMTRunnerEventsAdapter(processHandler){
                    final /* synthetic */ ProcessHandler $processHandler;
                    {
                        this.$processHandler = $processHandler;
                    }

                    public void onTestingFinished(SMTestProxy.SMRootTestProxy testsRoot) {
                        Intrinsics.checkNotNullParameter((Object)testsRoot, (String)"testsRoot");
                        if (Intrinsics.areEqual((Object)testsRoot.getHandler(), (Object)this.$processHandler)) {
                            this.$processHandler.destroyProcess();
                        }
                    }
                });
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Context<?> data2 = this.getContext(e);
        if (data2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            super.update(e);
        }
    }

    private final Context<?> requireContext(AnActionEvent e) {
        Context<?> context2 = this.getContext(e);
        if (context2 == null) {
            throw new IllegalStateException("No provider found");
        }
        return context2;
    }

    private final Context<?> getContext(AnActionEvent e) {
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)e.getData(ExecutionDataKeys.EXECUTION_ENVIRONMENT);
        RunProfile runProfile = executionEnvironment != null ? executionEnvironment.getRunProfile() : null;
        RunConfiguration runConfiguration = runProfile instanceof RunConfiguration ? (RunConfiguration)runProfile : null;
        if (runConfiguration == null) {
            return null;
        }
        RunConfiguration runConfiguration2 = runConfiguration;
        return (Context)JsTestWatchProvider.Companion.getEP_NAME().computeSafeIfAny(arg_0 -> JsTestWatchToggleAction.getContext$lambda$0(this, runConfiguration2, arg_0));
    }

    private final <T extends RunConfiguration> Context<T> createIfMatched(RunConfiguration runConfiguration, JsTestWatchProvider<T> provider) {
        Context<RunConfiguration> context2;
        RunConfiguration runConfiguration2 = (RunConfiguration)ObjectUtils.tryCast((Object)runConfiguration, provider.getRunConfigurationClass());
        if (runConfiguration2 != null) {
            RunConfiguration it = runConfiguration2;
            boolean bl = false;
            context2 = new Context<RunConfiguration>(it, provider);
        } else {
            context2 = null;
        }
        return context2;
    }

    private static final Context getContext$lambda$0(JsTestWatchToggleAction this$0, RunConfiguration $runConfiguration, JsTestWatchProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createIfMatched($runConfiguration, it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bR\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/testing/watch/JsTestWatchToggleAction$Context;", "T", "Lcom/intellij/execution/configurations/RunConfiguration;", "", "runConfiguration", "provider", "Lcom/intellij/javascript/testing/watch/JsTestWatchProvider;", "<init>", "(Lcom/intellij/execution/configurations/RunConfiguration;Lcom/intellij/javascript/testing/watch/JsTestWatchProvider;)V", "Lcom/intellij/execution/configurations/RunConfiguration;", "isWatchEnabled", "", "setWatchedEnabled", "", "enabled", "intellij.javascript.impl"})
    private static final class Context<T extends RunConfiguration> {
        @NotNull
        private final T runConfiguration;
        @NotNull
        private final JsTestWatchProvider<T> provider;

        public Context(@NotNull T runConfiguration, @NotNull JsTestWatchProvider<T> provider) {
            Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            this.runConfiguration = runConfiguration;
            this.provider = provider;
        }

        public final boolean isWatchEnabled() {
            return this.provider.isWatchEnabled(this.runConfiguration);
        }

        public final void setWatchedEnabled(boolean enabled) {
            this.provider.setWatchEnabled(this.runConfiguration, enabled);
        }
    }
}

