/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptFileCachedDataEvaluator;
import com.intellij.lang.javascript.index.JSPragmaFlags;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.BooleanStack;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileCachedDataEvaluator
extends JSElementVisitor {
    @NotNull
    protected final JSFileCachedData myCachedData;
    private final BooleanStack mySkipChildren;
    private boolean mySkipCurrentElementChildren;

    public JSFileCachedDataEvaluator(@NotNull JSFileCachedData outCachedData) {
        if (outCachedData == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(0);
        }
        this.mySkipChildren = new BooleanStack();
        this.myCachedData = outCachedData;
    }

    public void setSkipChildren() {
        this.mySkipCurrentElementChildren = true;
    }

    public boolean isSkipChildren() {
        return !this.mySkipChildren.isEmpty() && this.mySkipChildren.peek();
    }

    public void startElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(1);
        }
        this.mySkipCurrentElementChildren = this.isSkipChildren();
        if (!this.mySkipCurrentElementChildren) {
            element2.accept((PsiElementVisitor)this);
        }
        this.mySkipChildren.push(this.mySkipCurrentElementChildren);
    }

    public void finishElement() {
        this.mySkipCurrentElementChildren = this.mySkipChildren.pop();
    }

    @Override
    public void visitJSFile(@NotNull JSFile file) {
        if (file == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(2);
        }
        super.visitJSFile(file);
        JSStatement statement = JSPsiImplUtils.findFirstStatementOrDirective(file);
        if (JSPsiImplUtils.isCompilerDirectiveStatement((PsiElement)statement, "use client")) {
            this.myCachedData.addPragmaFlag("use client", "");
        }
        JSPsiImplUtils.processTopLevelComment(file, (Processor<? super PsiComment>)((Processor)comment -> {
            JSPragmaFlags.INSTANCE.parseFlags(file, (PsiComment)comment, this.myCachedData);
            return true;
        }));
    }

    @Override
    public void visitJSCallExpression(@NotNull JSCallExpression node) {
        if (node == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(3);
        }
        if (node.isRequireCall()) {
            this.myCachedData.applyModuleStatus(JSFileCachedDataEvaluator.getStatusForCommonJSMarker(node));
        }
    }

    @Override
    public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
        if (node == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(4);
        }
        super.visitJSReferenceExpression(node);
        if (JSSymbolUtil.isExportReference(node)) {
            this.myCachedData.applyModuleStatus(JSFileCachedDataEvaluator.getStatusForCommonJSMarker(node));
        }
    }

    @NotNull
    private static JSModuleStatusOwner.ModuleStatus getStatusForCommonJSMarker(JSExpression element2) {
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, JSStatement.class);
        JSModuleStatusOwner.ModuleStatus moduleStatus = (statement instanceof JSExpressionStatement || statement instanceof JSVarStatement) && statement.getParent() instanceof PsiFile ? JSModuleStatusOwner.ModuleStatus.COMMONJS : JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS;
        if (moduleStatus == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(5);
        }
        return moduleStatus;
    }

    @Override
    public void visitES6ImportDeclaration(@NotNull ES6ImportDeclaration importDeclaration) {
        if (importDeclaration == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(6);
        }
        this.processImportExportDeclaration();
    }

    @Override
    public void visitES6ExportDeclaration(@NotNull ES6ExportDeclaration exportDeclaration) {
        if (exportDeclaration == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(7);
        }
        this.processImportExportDeclaration();
    }

    @Override
    public void visitES6ExportDefaultAssignment(@NotNull ES6ExportDefaultAssignment node) {
        if (node == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(8);
        }
        this.myCachedData.applyModuleStatus(JSModuleStatusOwner.ModuleStatus.ES6);
        this.myCachedData.setHasES6Syntax();
        this.setSkipChildren();
    }

    @Override
    public void visitES6ImportCall(@NotNull ES6ImportCall importCall) {
        if (importCall == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(9);
        }
        this.myCachedData.setHasES6Syntax();
    }

    @Override
    public void visitJSVariable(@NotNull JSVariable node) {
        if (node == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(10);
        }
        this.checkIfExportStatement(node);
    }

    @Override
    public void visitJSClass(@NotNull JSClass aClass) {
        if (aClass == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(11);
        }
        this.checkIfExportStatement(aClass);
    }

    @Override
    public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
        if (node == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(12);
        }
        this.checkIfExportStatement(node);
    }

    @Override
    public void visitTypeScriptModule(@NotNull TypeScriptModule module) {
        if (module == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(13);
        }
        this.checkIfExportStatement(module);
        this.setSkipChildren();
    }

    @Override
    public void visitJSXmlLiteralExpression(@NotNull JSXmlLiteralExpression node) {
        if (node == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(14);
        }
        this.myCachedData.setHasJSXSyntax();
        this.setSkipChildren();
    }

    private void checkIfExportStatement(@NotNull JSAttributeListOwner node) {
        JSAttributeList attributeList;
        if (node == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(15);
        }
        if ((attributeList = node.getAttributeList()) != null && attributeList.getNode().findChildByType(JSTokenTypes.EXPORT_KEYWORD) != null) {
            this.myCachedData.setHasES6Syntax();
            PsiElement scope2 = JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)node);
            if (!(scope2 instanceof TypeScriptModule)) {
                this.myCachedData.applyModuleStatus(JSModuleStatusOwner.ModuleStatus.ES6);
            }
        }
    }

    protected void processImportExportDeclaration() {
        this.myCachedData.applyModuleStatus(JSModuleStatusOwner.ModuleStatus.ES6);
        this.myCachedData.setHasES6Syntax();
        this.setSkipChildren();
    }

    @NotNull
    public static Set<String> calculateReferencedPaths(@NotNull JSFile file) {
        if (file == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(16);
        }
        JSReferencedPathsVisitor visitor = DialectDetector.isTypeScript(file) ? new TypeScriptFileCachedDataEvaluator.TypeScriptReferencePathsVisitor() : new JSReferencedPathsVisitor();
        file.acceptChildren(visitor);
        Set<String> set = visitor.getReferencedPaths();
        if (set == null) {
            JSFileCachedDataEvaluator.$$$reportNull$$$0(17);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outCachedData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDeclaration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportDeclaration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importCall";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusForCommonJSMarker";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateReferencedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitJSCallExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitJSReferenceExpression";
                break;
            }
            case 5: 
            case 17: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ImportDeclaration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ExportDeclaration";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ExportDefaultAssignment";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ImportCall";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitJSVariable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitJSClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFunctionDeclaration";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptModule";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitJSXmlLiteralExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkIfExportStatement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calculateReferencedPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 17 -> new IllegalStateException(string);
        };
    }

    protected static class JSReferencedPathsVisitor
    extends JSRecursiveWalkingElementVisitor {
        @Nullable
        protected Set<String> myReferencedPaths;

        protected JSReferencedPathsVisitor() {
        }

        protected void addReferencedPath(String filePath) {
            if (this.myReferencedPaths == null) {
                this.myReferencedPaths = new HashSet<String>();
            }
            this.myReferencedPaths.add(filePath);
        }

        @NotNull
        Set<String> getReferencedPaths() {
            Set set = (Set)ObjectUtils.notNull(this.myReferencedPaths, Collections.emptySet());
            if (set == null) {
                JSReferencedPathsVisitor.$$$reportNull$$$0(0);
            }
            return set;
        }

        @Override
        public void visitES6ImportDeclaration(@NotNull ES6ImportDeclaration importDeclaration) {
            if (importDeclaration == null) {
                JSReferencedPathsVisitor.$$$reportNull$$$0(1);
            }
            this.processImportExportDeclaration(importDeclaration);
            String moduleText = importDeclaration.getImportModuleText();
            if (moduleText != null) {
                this.addReferencedPath(moduleText);
            }
        }

        @Override
        public void visitES6ExportDeclaration(@NotNull ES6ExportDeclaration exportDeclaration) {
            if (exportDeclaration == null) {
                JSReferencedPathsVisitor.$$$reportNull$$$0(2);
            }
            this.processImportExportDeclaration(exportDeclaration);
        }

        @Override
        public void visitES6ImportCall(@NotNull ES6ImportCall importCall) {
            if (importCall == null) {
                JSReferencedPathsVisitor.$$$reportNull$$$0(3);
            }
            if (importCall.getReferenceText() != null) {
                this.addReferencedPath(StringUtil.unquoteString((String)importCall.getReferenceText()));
            }
        }

        protected void processImportExportDeclaration(@NotNull ES6ImportExportDeclaration declaration) {
            String path2;
            String text;
            ES6FromClause clause;
            if (declaration == null) {
                JSReferencedPathsVisitor.$$$reportNull$$$0(4);
            }
            if ((clause = declaration.getFromClause()) != null && (text = clause.getReferenceText()) != null && !StringUtil.isEmpty((String)(path2 = StringUtil.unquoteString((String)text)))) {
                this.addReferencedPath(path2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator$JSReferencedPathsVisitor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importDeclaration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportDeclaration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importCall";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencedPaths";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator$JSReferencedPathsVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitES6ImportDeclaration";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitES6ExportDeclaration";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitES6ImportCall";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processImportExportDeclaration";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

