/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.openapi.util.NlsContexts;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintOptionGroup {
    private final @NlsContexts.Label String myTitle;
    private final @NlsContexts.HintText String myDescription;
    private final Map<JSHintOption, @Nls String> myHtmlDescriptionByOptionMap;

    public JSHintOptionGroup(@NlsContexts.Label @NotNull String title, @NlsContexts.HintText @NotNull String description) {
        if (title == null) {
            JSHintOptionGroup.$$$reportNull$$$0(0);
        }
        if (description == null) {
            JSHintOptionGroup.$$$reportNull$$$0(1);
        }
        this.myTitle = title;
        this.myDescription = JSHintOptionGroup.htmlWrap(description);
        this.myHtmlDescriptionByOptionMap = new EnumMap<JSHintOption, String>(JSHintOption.class);
    }

    @NlsContexts.Label
    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            JSHintOptionGroup.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NlsContexts.HintText
    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            JSHintOptionGroup.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Collection<JSHintOption> getOptions() {
        Set<JSHintOption> set = this.myHtmlDescriptionByOptionMap.keySet();
        if (set == null) {
            JSHintOptionGroup.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Nullable
    @Nls
    public String getHtmlDescriptionByOption(@NotNull JSHintOption option) {
        if (option == null) {
            JSHintOptionGroup.$$$reportNull$$$0(5);
        }
        return this.myHtmlDescriptionByOptionMap.get(option);
    }

    public String toString() {
        return "(title: " + this.myTitle + ")";
    }

    public void add(@NotNull JSHintOption option, @NlsContexts.HintText @NotNull String description) {
        if (option == null) {
            JSHintOptionGroup.$$$reportNull$$$0(6);
        }
        if (description == null) {
            JSHintOptionGroup.$$$reportNull$$$0(7);
        }
        this.myHtmlDescriptionByOptionMap.put(option, JSHintOptionGroup.htmlWrap(description));
    }

    @NlsContexts.HintText
    private static String htmlWrap(@NlsContexts.HintText @NotNull String bodyHtml) {
        String openingTags;
        if (bodyHtml == null) {
            JSHintOptionGroup.$$$reportNull$$$0(8);
        }
        if (bodyHtml.startsWith(openingTags = "<html><body>")) {
            return bodyHtml;
        }
        return openingTags + bodyHtml + "</body></html>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintOptionGroup";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintOptionGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlDescriptionByOption";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "htmlWrap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

