package hybridnetworkapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/hybridnetwork/mgmt/2020-01-01-preview/hybridnetwork"
)

// NetworkFunctionsClientAPI contains the set of methods on the NetworkFunctionsClient type.
type NetworkFunctionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, networkFunctionName string, parameters hybridnetwork.NetworkFunction) (result hybridnetwork.NetworkFunctionsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, networkFunctionName string) (result hybridnetwork.NetworkFunctionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, networkFunctionName string) (result hybridnetwork.NetworkFunction, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result hybridnetwork.NetworkFunctionListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result hybridnetwork.NetworkFunctionListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result hybridnetwork.NetworkFunctionListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result hybridnetwork.NetworkFunctionListResultIterator, err error)
	UpdateTags(ctx context.Context, resourceGroupName string, networkFunctionName string, parameters hybridnetwork.TagsObject) (result hybridnetwork.NetworkFunction, err error)
}

var _ NetworkFunctionsClientAPI = (*hybridnetwork.NetworkFunctionsClient)(nil)

// DevicesClientAPI contains the set of methods on the DevicesClient type.
type DevicesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, deviceName string, parameters hybridnetwork.Device) (result hybridnetwork.DevicesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, deviceName string) (result hybridnetwork.DevicesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, deviceName string) (result hybridnetwork.Device, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result hybridnetwork.DeviceListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result hybridnetwork.DeviceListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result hybridnetwork.DeviceListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result hybridnetwork.DeviceListResultIterator, err error)
	ListRegistrationKey(ctx context.Context, resourceGroupName string, deviceName string) (result hybridnetwork.DeviceRegistrationKey, err error)
	UpdateTags(ctx context.Context, resourceGroupName string, deviceName string, parameters hybridnetwork.TagsObject) (result hybridnetwork.Device, err error)
}

var _ DevicesClientAPI = (*hybridnetwork.DevicesClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result hybridnetwork.OperationListPage, err error)
	ListComplete(ctx context.Context) (result hybridnetwork.OperationListIterator, err error)
}

var _ OperationsClientAPI = (*hybridnetwork.OperationsClient)(nil)

// VendorsClientAPI contains the set of methods on the VendorsClient type.
type VendorsClientAPI interface {
	CreateOrUpdate(ctx context.Context, vendorName string, parameters *hybridnetwork.Vendor) (result hybridnetwork.VendorsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, vendorName string) (result hybridnetwork.VendorsDeleteFuture, err error)
	Get(ctx context.Context, vendorName string) (result hybridnetwork.Vendor, err error)
	ListBySubscription(ctx context.Context) (result hybridnetwork.VendorListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result hybridnetwork.VendorListResultIterator, err error)
}

var _ VendorsClientAPI = (*hybridnetwork.VendorsClient)(nil)

// VendorSkusClientAPI contains the set of methods on the VendorSkusClient type.
type VendorSkusClientAPI interface {
	CreateOrUpdate(ctx context.Context, vendorName string, skuName string, parameters hybridnetwork.VendorSku) (result hybridnetwork.VendorSkusCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, vendorName string, skuName string) (result hybridnetwork.VendorSkusDeleteFuture, err error)
	Get(ctx context.Context, vendorName string, skuName string) (result hybridnetwork.VendorSku, err error)
	List(ctx context.Context, vendorName string) (result hybridnetwork.VendorSkuListResultPage, err error)
	ListComplete(ctx context.Context, vendorName string) (result hybridnetwork.VendorSkuListResultIterator, err error)
}

var _ VendorSkusClientAPI = (*hybridnetwork.VendorSkusClient)(nil)

// VendorSkuPreviewClientAPI contains the set of methods on the VendorSkuPreviewClient type.
type VendorSkuPreviewClientAPI interface {
	CreateOrUpdate(ctx context.Context, vendorName string, skuName string, previewSubscription string, parameters hybridnetwork.PreviewSubscription) (result hybridnetwork.VendorSkuPreviewCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, vendorName string, skuName string, previewSubscription string) (result hybridnetwork.VendorSkuPreviewDeleteFuture, err error)
	Get(ctx context.Context, vendorName string, skuName string, previewSubscription string) (result hybridnetwork.PreviewSubscription, err error)
	List(ctx context.Context, vendorName string, skuName string) (result hybridnetwork.PreviewSubscriptionsListPage, err error)
	ListComplete(ctx context.Context, vendorName string, skuName string) (result hybridnetwork.PreviewSubscriptionsListIterator, err error)
}

var _ VendorSkuPreviewClientAPI = (*hybridnetwork.VendorSkuPreviewClient)(nil)

// NetworkFunctionVendorsClientAPI contains the set of methods on the NetworkFunctionVendorsClient type.
type NetworkFunctionVendorsClientAPI interface {
	List(ctx context.Context) (result hybridnetwork.NetworkFunctionVendorListResultPage, err error)
	ListComplete(ctx context.Context) (result hybridnetwork.NetworkFunctionVendorListResultIterator, err error)
}

var _ NetworkFunctionVendorsClientAPI = (*hybridnetwork.NetworkFunctionVendorsClient)(nil)

// NetworkFunctionVendorSkusClientAPI contains the set of methods on the NetworkFunctionVendorSkusClient type.
type NetworkFunctionVendorSkusClientAPI interface {
	ListBySku(ctx context.Context, vendorName string, vendorSkuName string) (result hybridnetwork.NetworkFunctionSkuDetailsPage, err error)
	ListBySkuComplete(ctx context.Context, vendorName string, vendorSkuName string) (result hybridnetwork.NetworkFunctionSkuDetailsIterator, err error)
	ListByVendor(ctx context.Context, vendorName string) (result hybridnetwork.NetworkFunctionSkuListResultPage, err error)
	ListByVendorComplete(ctx context.Context, vendorName string) (result hybridnetwork.NetworkFunctionSkuListResultIterator, err error)
}

var _ NetworkFunctionVendorSkusClientAPI = (*hybridnetwork.NetworkFunctionVendorSkusClient)(nil)

// VendorNetworkFunctionsClientAPI contains the set of methods on the VendorNetworkFunctionsClient type.
type VendorNetworkFunctionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, locationName string, vendorName string, serviceKey string, parameters hybridnetwork.VendorNetworkFunction) (result hybridnetwork.VendorNetworkFunctionsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, locationName string, vendorName string, serviceKey string) (result hybridnetwork.VendorNetworkFunction, err error)
	List(ctx context.Context, locationName string, vendorName string, filter string) (result hybridnetwork.VendorNetworkFunctionListResultPage, err error)
	ListComplete(ctx context.Context, locationName string, vendorName string, filter string) (result hybridnetwork.VendorNetworkFunctionListResultIterator, err error)
}

var _ VendorNetworkFunctionsClientAPI = (*hybridnetwork.VendorNetworkFunctionsClient)(nil)

// RoleInstancesClientAPI contains the set of methods on the RoleInstancesClient type.
type RoleInstancesClientAPI interface {
	Get(ctx context.Context, locationName string, vendorName string, serviceKey string, roleInstanceName string) (result hybridnetwork.RoleInstance, err error)
	List(ctx context.Context, locationName string, vendorName string, serviceKey string) (result hybridnetwork.NetworkFunctionRoleInstanceListResultPage, err error)
	ListComplete(ctx context.Context, locationName string, vendorName string, serviceKey string) (result hybridnetwork.NetworkFunctionRoleInstanceListResultIterator, err error)
	Restart(ctx context.Context, locationName string, vendorName string, serviceKey string, roleInstanceName string) (result hybridnetwork.RoleInstancesRestartFuture, err error)
	Start(ctx context.Context, locationName string, vendorName string, serviceKey string, roleInstanceName string) (result hybridnetwork.RoleInstancesStartFuture, err error)
	Stop(ctx context.Context, locationName string, vendorName string, serviceKey string, roleInstanceName string) (result hybridnetwork.RoleInstancesStopFuture, err error)
}

var _ RoleInstancesClientAPI = (*hybridnetwork.RoleInstancesClient)(nil)
