package web

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// HostingEnvironmentsClient is the webSite Management Client
type HostingEnvironmentsClient struct {
	BaseClient
}

// NewHostingEnvironmentsClient creates an instance of the HostingEnvironmentsClient client.
func NewHostingEnvironmentsClient(subscriptionID string) HostingEnvironmentsClient {
	return NewHostingEnvironmentsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewHostingEnvironmentsClientWithBaseURI creates an instance of the HostingEnvironmentsClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewHostingEnvironmentsClientWithBaseURI(baseURI string, subscriptionID string) HostingEnvironmentsClient {
	return HostingEnvironmentsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdateHostingEnvironment sends the create or update hosting environment request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// hostingEnvironmentEnvelope - properties of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) CreateOrUpdateHostingEnvironment(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope HostingEnvironment) (result HostingEnvironmentsCreateOrUpdateHostingEnvironmentFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.CreateOrUpdateHostingEnvironment")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateHostingEnvironmentPreparer(ctx, resourceGroupName, name, hostingEnvironmentEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "CreateOrUpdateHostingEnvironment", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateHostingEnvironmentSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "CreateOrUpdateHostingEnvironment", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdateHostingEnvironmentPreparer prepares the CreateOrUpdateHostingEnvironment request.
func (client HostingEnvironmentsClient) CreateOrUpdateHostingEnvironmentPreparer(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope HostingEnvironment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", pathParameters),
		autorest.WithJSON(hostingEnvironmentEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateHostingEnvironmentSender sends the CreateOrUpdateHostingEnvironment request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) CreateOrUpdateHostingEnvironmentSender(req *http.Request) (future HostingEnvironmentsCreateOrUpdateHostingEnvironmentFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateOrUpdateHostingEnvironmentResponder handles the response to the CreateOrUpdateHostingEnvironment request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) CreateOrUpdateHostingEnvironmentResponder(resp *http.Response) (result HostingEnvironment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateMultiRolePool sends the create or update multi role pool request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// multiRolePoolEnvelope - properties of multiRole pool
func (client HostingEnvironmentsClient) CreateOrUpdateMultiRolePool(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPool) (result HostingEnvironmentsCreateOrUpdateMultiRolePoolFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.CreateOrUpdateMultiRolePool")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateMultiRolePoolPreparer(ctx, resourceGroupName, name, multiRolePoolEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "CreateOrUpdateMultiRolePool", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateMultiRolePoolSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "CreateOrUpdateMultiRolePool", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdateMultiRolePoolPreparer prepares the CreateOrUpdateMultiRolePool request.
func (client HostingEnvironmentsClient) CreateOrUpdateMultiRolePoolPreparer(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope WorkerPool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default", pathParameters),
		autorest.WithJSON(multiRolePoolEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateMultiRolePoolSender sends the CreateOrUpdateMultiRolePool request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) CreateOrUpdateMultiRolePoolSender(req *http.Request) (future HostingEnvironmentsCreateOrUpdateMultiRolePoolFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateOrUpdateMultiRolePoolResponder handles the response to the CreateOrUpdateMultiRolePool request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) CreateOrUpdateMultiRolePoolResponder(resp *http.Response) (result WorkerPool, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateWorkerPool sends the create or update worker pool request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// workerPoolName - name of worker pool
// workerPoolEnvelope - properties of worker pool
func (client HostingEnvironmentsClient) CreateOrUpdateWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPool) (result HostingEnvironmentsCreateOrUpdateWorkerPoolFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.CreateOrUpdateWorkerPool")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateWorkerPoolPreparer(ctx, resourceGroupName, name, workerPoolName, workerPoolEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "CreateOrUpdateWorkerPool", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateWorkerPoolSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "CreateOrUpdateWorkerPool", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdateWorkerPoolPreparer prepares the CreateOrUpdateWorkerPool request.
func (client HostingEnvironmentsClient) CreateOrUpdateWorkerPoolPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope WorkerPool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}", pathParameters),
		autorest.WithJSON(workerPoolEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateWorkerPoolSender sends the CreateOrUpdateWorkerPool request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) CreateOrUpdateWorkerPoolSender(req *http.Request) (future HostingEnvironmentsCreateOrUpdateWorkerPoolFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateOrUpdateWorkerPoolResponder handles the response to the CreateOrUpdateWorkerPool request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) CreateOrUpdateWorkerPoolResponder(resp *http.Response) (result WorkerPool, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteHostingEnvironment sends the delete hosting environment request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// forceDelete - delete even if the hostingEnvironment (App Service Environment) contains resources
func (client HostingEnvironmentsClient) DeleteHostingEnvironment(ctx context.Context, resourceGroupName string, name string, forceDelete *bool) (result HostingEnvironmentsDeleteHostingEnvironmentFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.DeleteHostingEnvironment")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteHostingEnvironmentPreparer(ctx, resourceGroupName, name, forceDelete)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "DeleteHostingEnvironment", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteHostingEnvironmentSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "DeleteHostingEnvironment", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteHostingEnvironmentPreparer prepares the DeleteHostingEnvironment request.
func (client HostingEnvironmentsClient) DeleteHostingEnvironmentPreparer(ctx context.Context, resourceGroupName string, name string, forceDelete *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if forceDelete != nil {
		queryParameters["forceDelete"] = autorest.Encode("query", *forceDelete)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHostingEnvironmentSender sends the DeleteHostingEnvironment request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) DeleteHostingEnvironmentSender(req *http.Request) (future HostingEnvironmentsDeleteHostingEnvironmentFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteHostingEnvironmentResponder handles the response to the DeleteHostingEnvironment request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) DeleteHostingEnvironmentResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironment sends the get hosting environment request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironment(ctx context.Context, resourceGroupName string, name string) (result HostingEnvironment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetHostingEnvironmentPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironment", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironment", resp, "Failure sending request")
		return
	}

	result, err = client.GetHostingEnvironmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironment", resp, "Failure responding to request")
		return
	}

	return
}

// GetHostingEnvironmentPreparer prepares the GetHostingEnvironment request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentSender sends the GetHostingEnvironment request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentResponder handles the response to the GetHostingEnvironment request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentResponder(resp *http.Response) (result HostingEnvironment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentCapacities sends the get hosting environment capacities request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentCapacities(ctx context.Context, resourceGroupName string, name string) (result StampCapacityCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentCapacities")
		defer func() {
			sc := -1
			if result.scc.Response.Response != nil {
				sc = result.scc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getHostingEnvironmentCapacitiesNextResults
	req, err := client.GetHostingEnvironmentCapacitiesPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentCapacities", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentCapacitiesSender(req)
	if err != nil {
		result.scc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentCapacities", resp, "Failure sending request")
		return
	}

	result.scc, err = client.GetHostingEnvironmentCapacitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentCapacities", resp, "Failure responding to request")
		return
	}
	if result.scc.hasNextLink() && result.scc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetHostingEnvironmentCapacitiesPreparer prepares the GetHostingEnvironmentCapacities request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentCapacitiesPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/compute", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentCapacitiesSender sends the GetHostingEnvironmentCapacities request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentCapacitiesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentCapacitiesResponder handles the response to the GetHostingEnvironmentCapacities request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentCapacitiesResponder(resp *http.Response) (result StampCapacityCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getHostingEnvironmentCapacitiesNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getHostingEnvironmentCapacitiesNextResults(ctx context.Context, lastResults StampCapacityCollection) (result StampCapacityCollection, err error) {
	req, err := lastResults.stampCapacityCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentCapacitiesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetHostingEnvironmentCapacitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentCapacitiesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetHostingEnvironmentCapacitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentCapacitiesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetHostingEnvironmentCapacitiesComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetHostingEnvironmentCapacitiesComplete(ctx context.Context, resourceGroupName string, name string) (result StampCapacityCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentCapacities")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetHostingEnvironmentCapacities(ctx, resourceGroupName, name)
	return
}

// GetHostingEnvironmentDiagnostics sends the get hosting environment diagnostics request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnostics(ctx context.Context, resourceGroupName string, name string) (result ListHostingEnvironmentDiagnostics, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentDiagnostics")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetHostingEnvironmentDiagnosticsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentDiagnostics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentDiagnosticsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentDiagnostics", resp, "Failure sending request")
		return
	}

	result, err = client.GetHostingEnvironmentDiagnosticsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentDiagnostics", resp, "Failure responding to request")
		return
	}

	return
}

// GetHostingEnvironmentDiagnosticsPreparer prepares the GetHostingEnvironmentDiagnostics request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnosticsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentDiagnosticsSender sends the GetHostingEnvironmentDiagnostics request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnosticsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentDiagnosticsResponder handles the response to the GetHostingEnvironmentDiagnostics request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnosticsResponder(resp *http.Response) (result ListHostingEnvironmentDiagnostics, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentDiagnosticsItem sends the get hosting environment diagnostics item request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// diagnosticsName - name of the diagnostics
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnosticsItem(ctx context.Context, resourceGroupName string, name string, diagnosticsName string) (result HostingEnvironmentDiagnostics, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentDiagnosticsItem")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetHostingEnvironmentDiagnosticsItemPreparer(ctx, resourceGroupName, name, diagnosticsName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentDiagnosticsItem", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentDiagnosticsItemSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentDiagnosticsItem", resp, "Failure sending request")
		return
	}

	result, err = client.GetHostingEnvironmentDiagnosticsItemResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentDiagnosticsItem", resp, "Failure responding to request")
		return
	}

	return
}

// GetHostingEnvironmentDiagnosticsItemPreparer prepares the GetHostingEnvironmentDiagnosticsItem request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnosticsItemPreparer(ctx context.Context, resourceGroupName string, name string, diagnosticsName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"diagnosticsName":   autorest.Encode("path", diagnosticsName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics/{diagnosticsName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentDiagnosticsItemSender sends the GetHostingEnvironmentDiagnosticsItem request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnosticsItemSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentDiagnosticsItemResponder handles the response to the GetHostingEnvironmentDiagnosticsItem request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentDiagnosticsItemResponder(resp *http.Response) (result HostingEnvironmentDiagnostics, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentMetricDefinitions sends the get hosting environment metric definitions request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricDefinitions(ctx context.Context, resourceGroupName string, name string) (result MetricDefinition, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentMetricDefinitions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetHostingEnvironmentMetricDefinitionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMetricDefinitions", resp, "Failure sending request")
		return
	}

	result, err = client.GetHostingEnvironmentMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMetricDefinitions", resp, "Failure responding to request")
		return
	}

	return
}

// GetHostingEnvironmentMetricDefinitionsPreparer prepares the GetHostingEnvironmentMetricDefinitions request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricDefinitionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentMetricDefinitionsSender sends the GetHostingEnvironmentMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentMetricDefinitionsResponder handles the response to the GetHostingEnvironmentMetricDefinitions request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricDefinitionsResponder(resp *http.Response) (result MetricDefinition, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentMetrics sends the get hosting environment metrics request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// details - include instance details
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetrics(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentMetrics")
		defer func() {
			sc := -1
			if result.rmc.Response.Response != nil {
				sc = result.rmc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getHostingEnvironmentMetricsNextResults
	req, err := client.GetHostingEnvironmentMetricsPreparer(ctx, resourceGroupName, name, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentMetricsSender(req)
	if err != nil {
		result.rmc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMetrics", resp, "Failure sending request")
		return
	}

	result.rmc, err = client.GetHostingEnvironmentMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMetrics", resp, "Failure responding to request")
		return
	}
	if result.rmc.hasNextLink() && result.rmc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetHostingEnvironmentMetricsPreparer prepares the GetHostingEnvironmentMetrics request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricsPreparer(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentMetricsSender sends the GetHostingEnvironmentMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentMetricsResponder handles the response to the GetHostingEnvironmentMetrics request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getHostingEnvironmentMetricsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getHostingEnvironmentMetricsNextResults(ctx context.Context, lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.resourceMetricCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentMetricsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetHostingEnvironmentMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentMetricsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetHostingEnvironmentMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentMetricsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetHostingEnvironmentMetricsComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMetricsComplete(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentMetrics")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetHostingEnvironmentMetrics(ctx, resourceGroupName, name, details, filter)
	return
}

// GetHostingEnvironmentMultiRoleMetricDefinitions sends the get hosting environment multi role metric definitions
// request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricDefinitions(ctx context.Context, resourceGroupName string, name string) (result MetricDefinitionCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentMultiRoleMetricDefinitions")
		defer func() {
			sc := -1
			if result.mdc.Response.Response != nil {
				sc = result.mdc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getHostingEnvironmentMultiRoleMetricDefinitionsNextResults
	req, err := client.GetHostingEnvironmentMultiRoleMetricDefinitionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentMultiRoleMetricDefinitionsSender(req)
	if err != nil {
		result.mdc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetricDefinitions", resp, "Failure sending request")
		return
	}

	result.mdc, err = client.GetHostingEnvironmentMultiRoleMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetricDefinitions", resp, "Failure responding to request")
		return
	}
	if result.mdc.hasNextLink() && result.mdc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetHostingEnvironmentMultiRoleMetricDefinitionsPreparer prepares the GetHostingEnvironmentMultiRoleMetricDefinitions request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricDefinitionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentMultiRoleMetricDefinitionsSender sends the GetHostingEnvironmentMultiRoleMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentMultiRoleMetricDefinitionsResponder handles the response to the GetHostingEnvironmentMultiRoleMetricDefinitions request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricDefinitionsResponder(resp *http.Response) (result MetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getHostingEnvironmentMultiRoleMetricDefinitionsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getHostingEnvironmentMultiRoleMetricDefinitionsNextResults(ctx context.Context, lastResults MetricDefinitionCollection) (result MetricDefinitionCollection, err error) {
	req, err := lastResults.metricDefinitionCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentMultiRoleMetricDefinitionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetHostingEnvironmentMultiRoleMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentMultiRoleMetricDefinitionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetHostingEnvironmentMultiRoleMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentMultiRoleMetricDefinitionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetHostingEnvironmentMultiRoleMetricDefinitionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricDefinitionsComplete(ctx context.Context, resourceGroupName string, name string) (result MetricDefinitionCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentMultiRoleMetricDefinitions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetHostingEnvironmentMultiRoleMetricDefinitions(ctx, resourceGroupName, name)
	return
}

// GetHostingEnvironmentMultiRoleMetrics sends the get hosting environment multi role metrics request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// startTime - beginning time of metrics query
// endTime - end time of metrics query
// timeGrain - time granularity of metrics query
// details - include instance details
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetrics(ctx context.Context, resourceGroupName string, name string, startTime string, endTime string, timeGrain string, details *bool, filter string) (result ResourceMetricCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentMultiRoleMetrics")
		defer func() {
			sc := -1
			if result.rmc.Response.Response != nil {
				sc = result.rmc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getHostingEnvironmentMultiRoleMetricsNextResults
	req, err := client.GetHostingEnvironmentMultiRoleMetricsPreparer(ctx, resourceGroupName, name, startTime, endTime, timeGrain, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentMultiRoleMetricsSender(req)
	if err != nil {
		result.rmc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetrics", resp, "Failure sending request")
		return
	}

	result.rmc, err = client.GetHostingEnvironmentMultiRoleMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleMetrics", resp, "Failure responding to request")
		return
	}
	if result.rmc.hasNextLink() && result.rmc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetHostingEnvironmentMultiRoleMetricsPreparer prepares the GetHostingEnvironmentMultiRoleMetrics request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricsPreparer(ctx context.Context, resourceGroupName string, name string, startTime string, endTime string, timeGrain string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(startTime) > 0 {
		queryParameters["startTime"] = autorest.Encode("query", startTime)
	}
	if len(endTime) > 0 {
		queryParameters["endTime"] = autorest.Encode("query", endTime)
	}
	if len(timeGrain) > 0 {
		queryParameters["timeGrain"] = autorest.Encode("query", timeGrain)
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentMultiRoleMetricsSender sends the GetHostingEnvironmentMultiRoleMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentMultiRoleMetricsResponder handles the response to the GetHostingEnvironmentMultiRoleMetrics request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getHostingEnvironmentMultiRoleMetricsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getHostingEnvironmentMultiRoleMetricsNextResults(ctx context.Context, lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.resourceMetricCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentMultiRoleMetricsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetHostingEnvironmentMultiRoleMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentMultiRoleMetricsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetHostingEnvironmentMultiRoleMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentMultiRoleMetricsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetHostingEnvironmentMultiRoleMetricsComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleMetricsComplete(ctx context.Context, resourceGroupName string, name string, startTime string, endTime string, timeGrain string, details *bool, filter string) (result ResourceMetricCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentMultiRoleMetrics")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetHostingEnvironmentMultiRoleMetrics(ctx, resourceGroupName, name, startTime, endTime, timeGrain, details, filter)
	return
}

// GetHostingEnvironmentMultiRoleUsages sends the get hosting environment multi role usages request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleUsages(ctx context.Context, resourceGroupName string, name string) (result UsageCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentMultiRoleUsages")
		defer func() {
			sc := -1
			if result.uc.Response.Response != nil {
				sc = result.uc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getHostingEnvironmentMultiRoleUsagesNextResults
	req, err := client.GetHostingEnvironmentMultiRoleUsagesPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleUsages", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentMultiRoleUsagesSender(req)
	if err != nil {
		result.uc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleUsages", resp, "Failure sending request")
		return
	}

	result.uc, err = client.GetHostingEnvironmentMultiRoleUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentMultiRoleUsages", resp, "Failure responding to request")
		return
	}
	if result.uc.hasNextLink() && result.uc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetHostingEnvironmentMultiRoleUsagesPreparer prepares the GetHostingEnvironmentMultiRoleUsages request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleUsagesPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentMultiRoleUsagesSender sends the GetHostingEnvironmentMultiRoleUsages request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleUsagesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentMultiRoleUsagesResponder handles the response to the GetHostingEnvironmentMultiRoleUsages request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleUsagesResponder(resp *http.Response) (result UsageCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getHostingEnvironmentMultiRoleUsagesNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getHostingEnvironmentMultiRoleUsagesNextResults(ctx context.Context, lastResults UsageCollection) (result UsageCollection, err error) {
	req, err := lastResults.usageCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentMultiRoleUsagesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetHostingEnvironmentMultiRoleUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentMultiRoleUsagesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetHostingEnvironmentMultiRoleUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentMultiRoleUsagesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetHostingEnvironmentMultiRoleUsagesComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetHostingEnvironmentMultiRoleUsagesComplete(ctx context.Context, resourceGroupName string, name string) (result UsageCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentMultiRoleUsages")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetHostingEnvironmentMultiRoleUsages(ctx, resourceGroupName, name)
	return
}

// GetHostingEnvironmentOperation sends the get hosting environment operation request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// operationID - operation identifier GUID
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperation(ctx context.Context, resourceGroupName string, name string, operationID string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentOperation")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetHostingEnvironmentOperationPreparer(ctx, resourceGroupName, name, operationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentOperation", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentOperationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentOperation", resp, "Failure sending request")
		return
	}

	result, err = client.GetHostingEnvironmentOperationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentOperation", resp, "Failure responding to request")
		return
	}

	return
}

// GetHostingEnvironmentOperationPreparer prepares the GetHostingEnvironmentOperation request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperationPreparer(ctx context.Context, resourceGroupName string, name string, operationID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"operationId":       autorest.Encode("path", operationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/operations/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentOperationSender sends the GetHostingEnvironmentOperation request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentOperationResponder handles the response to the GetHostingEnvironmentOperation request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperationResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNotFound, http.StatusInternalServerError),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentOperations sends the get hosting environment operations request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperations(ctx context.Context, resourceGroupName string, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentOperations")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetHostingEnvironmentOperationsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentOperations", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentOperationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentOperations", resp, "Failure sending request")
		return
	}

	result, err = client.GetHostingEnvironmentOperationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentOperations", resp, "Failure responding to request")
		return
	}

	return
}

// GetHostingEnvironmentOperationsPreparer prepares the GetHostingEnvironmentOperations request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperationsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/operations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentOperationsSender sends the GetHostingEnvironmentOperations request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperationsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentOperationsResponder handles the response to the GetHostingEnvironmentOperations request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentOperationsResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironments sends the get hosting environments request.
// Parameters:
// resourceGroupName - name of resource group
func (client HostingEnvironmentsClient) GetHostingEnvironments(ctx context.Context, resourceGroupName string) (result HostingEnvironmentCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironments")
		defer func() {
			sc := -1
			if result.hec.Response.Response != nil {
				sc = result.hec.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getHostingEnvironmentsNextResults
	req, err := client.GetHostingEnvironmentsPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironments", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentsSender(req)
	if err != nil {
		result.hec.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironments", resp, "Failure sending request")
		return
	}

	result.hec, err = client.GetHostingEnvironmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironments", resp, "Failure responding to request")
		return
	}
	if result.hec.hasNextLink() && result.hec.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetHostingEnvironmentsPreparer prepares the GetHostingEnvironments request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentsPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentsSender sends the GetHostingEnvironments request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentsResponder handles the response to the GetHostingEnvironments request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentsResponder(resp *http.Response) (result HostingEnvironmentCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getHostingEnvironmentsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getHostingEnvironmentsNextResults(ctx context.Context, lastResults HostingEnvironmentCollection) (result HostingEnvironmentCollection, err error) {
	req, err := lastResults.hostingEnvironmentCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetHostingEnvironmentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetHostingEnvironmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetHostingEnvironmentsComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetHostingEnvironmentsComplete(ctx context.Context, resourceGroupName string) (result HostingEnvironmentCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironments")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetHostingEnvironments(ctx, resourceGroupName)
	return
}

// GetHostingEnvironmentServerFarms sends the get hosting environment server farms request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentServerFarms(ctx context.Context, resourceGroupName string, name string) (result ServerFarmCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentServerFarms")
		defer func() {
			sc := -1
			if result.sfc.Response.Response != nil {
				sc = result.sfc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getHostingEnvironmentServerFarmsNextResults
	req, err := client.GetHostingEnvironmentServerFarmsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentServerFarms", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentServerFarmsSender(req)
	if err != nil {
		result.sfc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentServerFarms", resp, "Failure sending request")
		return
	}

	result.sfc, err = client.GetHostingEnvironmentServerFarmsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentServerFarms", resp, "Failure responding to request")
		return
	}
	if result.sfc.hasNextLink() && result.sfc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetHostingEnvironmentServerFarmsPreparer prepares the GetHostingEnvironmentServerFarms request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentServerFarmsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/serverfarms", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentServerFarmsSender sends the GetHostingEnvironmentServerFarms request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentServerFarmsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentServerFarmsResponder handles the response to the GetHostingEnvironmentServerFarms request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentServerFarmsResponder(resp *http.Response) (result ServerFarmCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getHostingEnvironmentServerFarmsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getHostingEnvironmentServerFarmsNextResults(ctx context.Context, lastResults ServerFarmCollection) (result ServerFarmCollection, err error) {
	req, err := lastResults.serverFarmCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentServerFarmsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetHostingEnvironmentServerFarmsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentServerFarmsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetHostingEnvironmentServerFarmsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentServerFarmsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetHostingEnvironmentServerFarmsComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetHostingEnvironmentServerFarmsComplete(ctx context.Context, resourceGroupName string, name string) (result ServerFarmCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentServerFarms")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetHostingEnvironmentServerFarms(ctx, resourceGroupName, name)
	return
}

// GetHostingEnvironmentSites sends the get hosting environment sites request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// propertiesToInclude - comma separated list of site properties to include
func (client HostingEnvironmentsClient) GetHostingEnvironmentSites(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (result SiteCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentSites")
		defer func() {
			sc := -1
			if result.sc.Response.Response != nil {
				sc = result.sc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getHostingEnvironmentSitesNextResults
	req, err := client.GetHostingEnvironmentSitesPreparer(ctx, resourceGroupName, name, propertiesToInclude)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentSites", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentSitesSender(req)
	if err != nil {
		result.sc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentSites", resp, "Failure sending request")
		return
	}

	result.sc, err = client.GetHostingEnvironmentSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentSites", resp, "Failure responding to request")
		return
	}
	if result.sc.hasNextLink() && result.sc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetHostingEnvironmentSitesPreparer prepares the GetHostingEnvironmentSites request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentSitesPreparer(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(propertiesToInclude) > 0 {
		queryParameters["propertiesToInclude"] = autorest.Encode("query", propertiesToInclude)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentSitesSender sends the GetHostingEnvironmentSites request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentSitesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentSitesResponder handles the response to the GetHostingEnvironmentSites request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentSitesResponder(resp *http.Response) (result SiteCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getHostingEnvironmentSitesNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getHostingEnvironmentSitesNextResults(ctx context.Context, lastResults SiteCollection) (result SiteCollection, err error) {
	req, err := lastResults.siteCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentSitesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetHostingEnvironmentSitesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentSitesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetHostingEnvironmentSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentSitesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetHostingEnvironmentSitesComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetHostingEnvironmentSitesComplete(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (result SiteCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentSites")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetHostingEnvironmentSites(ctx, resourceGroupName, name, propertiesToInclude)
	return
}

// GetHostingEnvironmentUsages sends the get hosting environment usages request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client HostingEnvironmentsClient) GetHostingEnvironmentUsages(ctx context.Context, resourceGroupName string, name string, filter string) (result CsmUsageQuotaCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentUsages")
		defer func() {
			sc := -1
			if result.cuqc.Response.Response != nil {
				sc = result.cuqc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getHostingEnvironmentUsagesNextResults
	req, err := client.GetHostingEnvironmentUsagesPreparer(ctx, resourceGroupName, name, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentUsages", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentUsagesSender(req)
	if err != nil {
		result.cuqc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentUsages", resp, "Failure sending request")
		return
	}

	result.cuqc, err = client.GetHostingEnvironmentUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentUsages", resp, "Failure responding to request")
		return
	}
	if result.cuqc.hasNextLink() && result.cuqc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetHostingEnvironmentUsagesPreparer prepares the GetHostingEnvironmentUsages request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentUsagesPreparer(ctx context.Context, resourceGroupName string, name string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentUsagesSender sends the GetHostingEnvironmentUsages request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentUsagesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentUsagesResponder handles the response to the GetHostingEnvironmentUsages request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentUsagesResponder(resp *http.Response) (result CsmUsageQuotaCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getHostingEnvironmentUsagesNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getHostingEnvironmentUsagesNextResults(ctx context.Context, lastResults CsmUsageQuotaCollection) (result CsmUsageQuotaCollection, err error) {
	req, err := lastResults.csmUsageQuotaCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentUsagesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetHostingEnvironmentUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentUsagesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetHostingEnvironmentUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentUsagesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetHostingEnvironmentUsagesComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetHostingEnvironmentUsagesComplete(ctx context.Context, resourceGroupName string, name string, filter string) (result CsmUsageQuotaCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentUsages")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetHostingEnvironmentUsages(ctx, resourceGroupName, name, filter)
	return
}

// GetHostingEnvironmentVips sends the get hosting environment vips request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentVips(ctx context.Context, resourceGroupName string, name string) (result AddressResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentVips")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetHostingEnvironmentVipsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentVips", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentVipsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentVips", resp, "Failure sending request")
		return
	}

	result, err = client.GetHostingEnvironmentVipsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentVips", resp, "Failure responding to request")
		return
	}

	return
}

// GetHostingEnvironmentVipsPreparer prepares the GetHostingEnvironmentVips request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentVipsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/virtualip", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentVipsSender sends the GetHostingEnvironmentVips request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentVipsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentVipsResponder handles the response to the GetHostingEnvironmentVips request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentVipsResponder(resp *http.Response) (result AddressResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostingEnvironmentWebHostingPlans sends the get hosting environment web hosting plans request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebHostingPlans(ctx context.Context, resourceGroupName string, name string) (result ServerFarmCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentWebHostingPlans")
		defer func() {
			sc := -1
			if result.sfc.Response.Response != nil {
				sc = result.sfc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getHostingEnvironmentWebHostingPlansNextResults
	req, err := client.GetHostingEnvironmentWebHostingPlansPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebHostingPlans", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentWebHostingPlansSender(req)
	if err != nil {
		result.sfc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebHostingPlans", resp, "Failure sending request")
		return
	}

	result.sfc, err = client.GetHostingEnvironmentWebHostingPlansResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebHostingPlans", resp, "Failure responding to request")
		return
	}
	if result.sfc.hasNextLink() && result.sfc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetHostingEnvironmentWebHostingPlansPreparer prepares the GetHostingEnvironmentWebHostingPlans request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebHostingPlansPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/webhostingplans", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentWebHostingPlansSender sends the GetHostingEnvironmentWebHostingPlans request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebHostingPlansSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentWebHostingPlansResponder handles the response to the GetHostingEnvironmentWebHostingPlans request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebHostingPlansResponder(resp *http.Response) (result ServerFarmCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getHostingEnvironmentWebHostingPlansNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getHostingEnvironmentWebHostingPlansNextResults(ctx context.Context, lastResults ServerFarmCollection) (result ServerFarmCollection, err error) {
	req, err := lastResults.serverFarmCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentWebHostingPlansNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetHostingEnvironmentWebHostingPlansSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentWebHostingPlansNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetHostingEnvironmentWebHostingPlansResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentWebHostingPlansNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetHostingEnvironmentWebHostingPlansComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebHostingPlansComplete(ctx context.Context, resourceGroupName string, name string) (result ServerFarmCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentWebHostingPlans")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetHostingEnvironmentWebHostingPlans(ctx, resourceGroupName, name)
	return
}

// GetHostingEnvironmentWebWorkerMetricDefinitions sends the get hosting environment web worker metric definitions
// request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// workerPoolName - name of worker pool
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricDefinitions(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result MetricDefinitionCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentWebWorkerMetricDefinitions")
		defer func() {
			sc := -1
			if result.mdc.Response.Response != nil {
				sc = result.mdc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getHostingEnvironmentWebWorkerMetricDefinitionsNextResults
	req, err := client.GetHostingEnvironmentWebWorkerMetricDefinitionsPreparer(ctx, resourceGroupName, name, workerPoolName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentWebWorkerMetricDefinitionsSender(req)
	if err != nil {
		result.mdc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetricDefinitions", resp, "Failure sending request")
		return
	}

	result.mdc, err = client.GetHostingEnvironmentWebWorkerMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetricDefinitions", resp, "Failure responding to request")
		return
	}
	if result.mdc.hasNextLink() && result.mdc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetHostingEnvironmentWebWorkerMetricDefinitionsPreparer prepares the GetHostingEnvironmentWebWorkerMetricDefinitions request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricDefinitionsPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentWebWorkerMetricDefinitionsSender sends the GetHostingEnvironmentWebWorkerMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentWebWorkerMetricDefinitionsResponder handles the response to the GetHostingEnvironmentWebWorkerMetricDefinitions request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricDefinitionsResponder(resp *http.Response) (result MetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getHostingEnvironmentWebWorkerMetricDefinitionsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getHostingEnvironmentWebWorkerMetricDefinitionsNextResults(ctx context.Context, lastResults MetricDefinitionCollection) (result MetricDefinitionCollection, err error) {
	req, err := lastResults.metricDefinitionCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentWebWorkerMetricDefinitionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetHostingEnvironmentWebWorkerMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentWebWorkerMetricDefinitionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetHostingEnvironmentWebWorkerMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentWebWorkerMetricDefinitionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetHostingEnvironmentWebWorkerMetricDefinitionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricDefinitionsComplete(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result MetricDefinitionCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentWebWorkerMetricDefinitions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetHostingEnvironmentWebWorkerMetricDefinitions(ctx, resourceGroupName, name, workerPoolName)
	return
}

// GetHostingEnvironmentWebWorkerMetrics sends the get hosting environment web worker metrics request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// workerPoolName - name of worker pool
// details - include instance details
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetrics(ctx context.Context, resourceGroupName string, name string, workerPoolName string, details *bool, filter string) (result ResourceMetricCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentWebWorkerMetrics")
		defer func() {
			sc := -1
			if result.rmc.Response.Response != nil {
				sc = result.rmc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getHostingEnvironmentWebWorkerMetricsNextResults
	req, err := client.GetHostingEnvironmentWebWorkerMetricsPreparer(ctx, resourceGroupName, name, workerPoolName, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentWebWorkerMetricsSender(req)
	if err != nil {
		result.rmc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetrics", resp, "Failure sending request")
		return
	}

	result.rmc, err = client.GetHostingEnvironmentWebWorkerMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerMetrics", resp, "Failure responding to request")
		return
	}
	if result.rmc.hasNextLink() && result.rmc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetHostingEnvironmentWebWorkerMetricsPreparer prepares the GetHostingEnvironmentWebWorkerMetrics request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricsPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentWebWorkerMetricsSender sends the GetHostingEnvironmentWebWorkerMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentWebWorkerMetricsResponder handles the response to the GetHostingEnvironmentWebWorkerMetrics request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getHostingEnvironmentWebWorkerMetricsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getHostingEnvironmentWebWorkerMetricsNextResults(ctx context.Context, lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.resourceMetricCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentWebWorkerMetricsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetHostingEnvironmentWebWorkerMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentWebWorkerMetricsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetHostingEnvironmentWebWorkerMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentWebWorkerMetricsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetHostingEnvironmentWebWorkerMetricsComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerMetricsComplete(ctx context.Context, resourceGroupName string, name string, workerPoolName string, details *bool, filter string) (result ResourceMetricCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentWebWorkerMetrics")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetHostingEnvironmentWebWorkerMetrics(ctx, resourceGroupName, name, workerPoolName, details, filter)
	return
}

// GetHostingEnvironmentWebWorkerUsages sends the get hosting environment web worker usages request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// workerPoolName - name of worker pool
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerUsages(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result UsageCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentWebWorkerUsages")
		defer func() {
			sc := -1
			if result.uc.Response.Response != nil {
				sc = result.uc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getHostingEnvironmentWebWorkerUsagesNextResults
	req, err := client.GetHostingEnvironmentWebWorkerUsagesPreparer(ctx, resourceGroupName, name, workerPoolName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerUsages", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostingEnvironmentWebWorkerUsagesSender(req)
	if err != nil {
		result.uc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerUsages", resp, "Failure sending request")
		return
	}

	result.uc, err = client.GetHostingEnvironmentWebWorkerUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetHostingEnvironmentWebWorkerUsages", resp, "Failure responding to request")
		return
	}
	if result.uc.hasNextLink() && result.uc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetHostingEnvironmentWebWorkerUsagesPreparer prepares the GetHostingEnvironmentWebWorkerUsages request.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerUsagesPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHostingEnvironmentWebWorkerUsagesSender sends the GetHostingEnvironmentWebWorkerUsages request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerUsagesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetHostingEnvironmentWebWorkerUsagesResponder handles the response to the GetHostingEnvironmentWebWorkerUsages request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerUsagesResponder(resp *http.Response) (result UsageCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getHostingEnvironmentWebWorkerUsagesNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getHostingEnvironmentWebWorkerUsagesNextResults(ctx context.Context, lastResults UsageCollection) (result UsageCollection, err error) {
	req, err := lastResults.usageCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentWebWorkerUsagesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetHostingEnvironmentWebWorkerUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentWebWorkerUsagesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetHostingEnvironmentWebWorkerUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getHostingEnvironmentWebWorkerUsagesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetHostingEnvironmentWebWorkerUsagesComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetHostingEnvironmentWebWorkerUsagesComplete(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result UsageCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetHostingEnvironmentWebWorkerUsages")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetHostingEnvironmentWebWorkerUsages(ctx, resourceGroupName, name, workerPoolName)
	return
}

// GetMultiRolePool sends the get multi role pool request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetMultiRolePool(ctx context.Context, resourceGroupName string, name string) (result WorkerPool, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetMultiRolePool")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetMultiRolePoolPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePool", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMultiRolePoolSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePool", resp, "Failure sending request")
		return
	}

	result, err = client.GetMultiRolePoolResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePool", resp, "Failure responding to request")
		return
	}

	return
}

// GetMultiRolePoolPreparer prepares the GetMultiRolePool request.
func (client HostingEnvironmentsClient) GetMultiRolePoolPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMultiRolePoolSender sends the GetMultiRolePool request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetMultiRolePoolSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetMultiRolePoolResponder handles the response to the GetMultiRolePool request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetMultiRolePoolResponder(resp *http.Response) (result WorkerPool, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMultiRolePoolInstanceMetricDefinitions sends the get multi role pool instance metric definitions request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// instance - name of instance in the multiRole pool&gt;
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetricDefinitions(ctx context.Context, resourceGroupName string, name string, instance string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetMultiRolePoolInstanceMetricDefinitions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetMultiRolePoolInstanceMetricDefinitionsPreparer(ctx, resourceGroupName, name, instance)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolInstanceMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMultiRolePoolInstanceMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolInstanceMetricDefinitions", resp, "Failure sending request")
		return
	}

	result, err = client.GetMultiRolePoolInstanceMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolInstanceMetricDefinitions", resp, "Failure responding to request")
		return
	}

	return
}

// GetMultiRolePoolInstanceMetricDefinitionsPreparer prepares the GetMultiRolePoolInstanceMetricDefinitions request.
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetricDefinitionsPreparer(ctx context.Context, resourceGroupName string, name string, instance string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMultiRolePoolInstanceMetricDefinitionsSender sends the GetMultiRolePoolInstanceMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetMultiRolePoolInstanceMetricDefinitionsResponder handles the response to the GetMultiRolePoolInstanceMetricDefinitions request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetricDefinitionsResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMultiRolePoolInstanceMetrics sends the get multi role pool instance metrics request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// instance - name of instance in the multiRole pool
// details - include instance details
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetrics(ctx context.Context, resourceGroupName string, name string, instance string, details *bool) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetMultiRolePoolInstanceMetrics")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetMultiRolePoolInstanceMetricsPreparer(ctx, resourceGroupName, name, instance, details)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolInstanceMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMultiRolePoolInstanceMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolInstanceMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.GetMultiRolePoolInstanceMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolInstanceMetrics", resp, "Failure responding to request")
		return
	}

	return
}

// GetMultiRolePoolInstanceMetricsPreparer prepares the GetMultiRolePoolInstanceMetrics request.
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetricsPreparer(ctx context.Context, resourceGroupName string, name string, instance string, details *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMultiRolePoolInstanceMetricsSender sends the GetMultiRolePoolInstanceMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetMultiRolePoolInstanceMetricsResponder handles the response to the GetMultiRolePoolInstanceMetrics request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetMultiRolePoolInstanceMetricsResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMultiRolePools sends the get multi role pools request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetMultiRolePools(ctx context.Context, resourceGroupName string, name string) (result WorkerPoolCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetMultiRolePools")
		defer func() {
			sc := -1
			if result.wpc.Response.Response != nil {
				sc = result.wpc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getMultiRolePoolsNextResults
	req, err := client.GetMultiRolePoolsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePools", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMultiRolePoolsSender(req)
	if err != nil {
		result.wpc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePools", resp, "Failure sending request")
		return
	}

	result.wpc, err = client.GetMultiRolePoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePools", resp, "Failure responding to request")
		return
	}
	if result.wpc.hasNextLink() && result.wpc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetMultiRolePoolsPreparer prepares the GetMultiRolePools request.
func (client HostingEnvironmentsClient) GetMultiRolePoolsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMultiRolePoolsSender sends the GetMultiRolePools request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetMultiRolePoolsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetMultiRolePoolsResponder handles the response to the GetMultiRolePools request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetMultiRolePoolsResponder(resp *http.Response) (result WorkerPoolCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getMultiRolePoolsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getMultiRolePoolsNextResults(ctx context.Context, lastResults WorkerPoolCollection) (result WorkerPoolCollection, err error) {
	req, err := lastResults.workerPoolCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getMultiRolePoolsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetMultiRolePoolsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getMultiRolePoolsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetMultiRolePoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getMultiRolePoolsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetMultiRolePoolsComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetMultiRolePoolsComplete(ctx context.Context, resourceGroupName string, name string) (result WorkerPoolCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetMultiRolePools")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetMultiRolePools(ctx, resourceGroupName, name)
	return
}

// GetMultiRolePoolSkus sends the get multi role pool skus request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetMultiRolePoolSkus(ctx context.Context, resourceGroupName string, name string) (result SkuInfoCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetMultiRolePoolSkus")
		defer func() {
			sc := -1
			if result.sic.Response.Response != nil {
				sc = result.sic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getMultiRolePoolSkusNextResults
	req, err := client.GetMultiRolePoolSkusPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMultiRolePoolSkusSender(req)
	if err != nil {
		result.sic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolSkus", resp, "Failure sending request")
		return
	}

	result.sic, err = client.GetMultiRolePoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetMultiRolePoolSkus", resp, "Failure responding to request")
		return
	}
	if result.sic.hasNextLink() && result.sic.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetMultiRolePoolSkusPreparer prepares the GetMultiRolePoolSkus request.
func (client HostingEnvironmentsClient) GetMultiRolePoolSkusPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMultiRolePoolSkusSender sends the GetMultiRolePoolSkus request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetMultiRolePoolSkusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetMultiRolePoolSkusResponder handles the response to the GetMultiRolePoolSkus request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetMultiRolePoolSkusResponder(resp *http.Response) (result SkuInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getMultiRolePoolSkusNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getMultiRolePoolSkusNextResults(ctx context.Context, lastResults SkuInfoCollection) (result SkuInfoCollection, err error) {
	req, err := lastResults.skuInfoCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getMultiRolePoolSkusNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetMultiRolePoolSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getMultiRolePoolSkusNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetMultiRolePoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getMultiRolePoolSkusNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetMultiRolePoolSkusComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetMultiRolePoolSkusComplete(ctx context.Context, resourceGroupName string, name string) (result SkuInfoCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetMultiRolePoolSkus")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetMultiRolePoolSkus(ctx, resourceGroupName, name)
	return
}

// GetWorkerPool sends the get worker pool request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// workerPoolName - name of worker pool
func (client HostingEnvironmentsClient) GetWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result WorkerPool, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetWorkerPool")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetWorkerPoolPreparer(ctx, resourceGroupName, name, workerPoolName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPool", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetWorkerPoolSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPool", resp, "Failure sending request")
		return
	}

	result, err = client.GetWorkerPoolResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPool", resp, "Failure responding to request")
		return
	}

	return
}

// GetWorkerPoolPreparer prepares the GetWorkerPool request.
func (client HostingEnvironmentsClient) GetWorkerPoolPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetWorkerPoolSender sends the GetWorkerPool request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetWorkerPoolSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetWorkerPoolResponder handles the response to the GetWorkerPool request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetWorkerPoolResponder(resp *http.Response) (result WorkerPool, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWorkerPoolInstanceMetricDefinitions sends the get worker pool instance metric definitions request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// workerPoolName - name of worker pool
// instance - name of instance in the worker pool
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetricDefinitions(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetWorkerPoolInstanceMetricDefinitions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetWorkerPoolInstanceMetricDefinitionsPreparer(ctx, resourceGroupName, name, workerPoolName, instance)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolInstanceMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetWorkerPoolInstanceMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolInstanceMetricDefinitions", resp, "Failure sending request")
		return
	}

	result, err = client.GetWorkerPoolInstanceMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolInstanceMetricDefinitions", resp, "Failure responding to request")
		return
	}

	return
}

// GetWorkerPoolInstanceMetricDefinitionsPreparer prepares the GetWorkerPoolInstanceMetricDefinitions request.
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetricDefinitionsPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetWorkerPoolInstanceMetricDefinitionsSender sends the GetWorkerPoolInstanceMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetWorkerPoolInstanceMetricDefinitionsResponder handles the response to the GetWorkerPoolInstanceMetricDefinitions request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetricDefinitionsResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWorkerPoolInstanceMetrics sends the get worker pool instance metrics request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// workerPoolName - name of worker pool
// instance - name of instance in the worker pool
// details - include instance details
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetrics(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string, details *bool, filter string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetWorkerPoolInstanceMetrics")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetWorkerPoolInstanceMetricsPreparer(ctx, resourceGroupName, name, workerPoolName, instance, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolInstanceMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetWorkerPoolInstanceMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolInstanceMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.GetWorkerPoolInstanceMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolInstanceMetrics", resp, "Failure responding to request")
		return
	}

	return
}

// GetWorkerPoolInstanceMetricsPreparer prepares the GetWorkerPoolInstanceMetrics request.
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetricsPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instance":          autorest.Encode("path", instance),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetWorkerPoolInstanceMetricsSender sends the GetWorkerPoolInstanceMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetWorkerPoolInstanceMetricsResponder handles the response to the GetWorkerPoolInstanceMetrics request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetWorkerPoolInstanceMetricsResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWorkerPools sends the get worker pools request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) GetWorkerPools(ctx context.Context, resourceGroupName string, name string) (result WorkerPoolCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetWorkerPools")
		defer func() {
			sc := -1
			if result.wpc.Response.Response != nil {
				sc = result.wpc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getWorkerPoolsNextResults
	req, err := client.GetWorkerPoolsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPools", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetWorkerPoolsSender(req)
	if err != nil {
		result.wpc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPools", resp, "Failure sending request")
		return
	}

	result.wpc, err = client.GetWorkerPoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPools", resp, "Failure responding to request")
		return
	}
	if result.wpc.hasNextLink() && result.wpc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetWorkerPoolsPreparer prepares the GetWorkerPools request.
func (client HostingEnvironmentsClient) GetWorkerPoolsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetWorkerPoolsSender sends the GetWorkerPools request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetWorkerPoolsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetWorkerPoolsResponder handles the response to the GetWorkerPools request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetWorkerPoolsResponder(resp *http.Response) (result WorkerPoolCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getWorkerPoolsNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getWorkerPoolsNextResults(ctx context.Context, lastResults WorkerPoolCollection) (result WorkerPoolCollection, err error) {
	req, err := lastResults.workerPoolCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getWorkerPoolsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetWorkerPoolsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getWorkerPoolsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetWorkerPoolsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getWorkerPoolsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetWorkerPoolsComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetWorkerPoolsComplete(ctx context.Context, resourceGroupName string, name string) (result WorkerPoolCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetWorkerPools")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetWorkerPools(ctx, resourceGroupName, name)
	return
}

// GetWorkerPoolSkus sends the get worker pool skus request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
// workerPoolName - name of worker pool
func (client HostingEnvironmentsClient) GetWorkerPoolSkus(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result SkuInfoCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetWorkerPoolSkus")
		defer func() {
			sc := -1
			if result.sic.Response.Response != nil {
				sc = result.sic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getWorkerPoolSkusNextResults
	req, err := client.GetWorkerPoolSkusPreparer(ctx, resourceGroupName, name, workerPoolName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetWorkerPoolSkusSender(req)
	if err != nil {
		result.sic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolSkus", resp, "Failure sending request")
		return
	}

	result.sic, err = client.GetWorkerPoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "GetWorkerPoolSkus", resp, "Failure responding to request")
		return
	}
	if result.sic.hasNextLink() && result.sic.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetWorkerPoolSkusPreparer prepares the GetWorkerPoolSkus request.
func (client HostingEnvironmentsClient) GetWorkerPoolSkusPreparer(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerPoolName":    autorest.Encode("path", workerPoolName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetWorkerPoolSkusSender sends the GetWorkerPoolSkus request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) GetWorkerPoolSkusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetWorkerPoolSkusResponder handles the response to the GetWorkerPoolSkus request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) GetWorkerPoolSkusResponder(resp *http.Response) (result SkuInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getWorkerPoolSkusNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) getWorkerPoolSkusNextResults(ctx context.Context, lastResults SkuInfoCollection) (result SkuInfoCollection, err error) {
	req, err := lastResults.skuInfoCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getWorkerPoolSkusNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetWorkerPoolSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getWorkerPoolSkusNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetWorkerPoolSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "getWorkerPoolSkusNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetWorkerPoolSkusComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) GetWorkerPoolSkusComplete(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result SkuInfoCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.GetWorkerPoolSkus")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetWorkerPoolSkus(ctx, resourceGroupName, name, workerPoolName)
	return
}

// RebootHostingEnvironment sends the reboot hosting environment request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) RebootHostingEnvironment(ctx context.Context, resourceGroupName string, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.RebootHostingEnvironment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.RebootHostingEnvironmentPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "RebootHostingEnvironment", nil, "Failure preparing request")
		return
	}

	resp, err := client.RebootHostingEnvironmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "RebootHostingEnvironment", resp, "Failure sending request")
		return
	}

	result, err = client.RebootHostingEnvironmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "RebootHostingEnvironment", resp, "Failure responding to request")
		return
	}

	return
}

// RebootHostingEnvironmentPreparer prepares the RebootHostingEnvironment request.
func (client HostingEnvironmentsClient) RebootHostingEnvironmentPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/reboot", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RebootHostingEnvironmentSender sends the RebootHostingEnvironment request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) RebootHostingEnvironmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// RebootHostingEnvironmentResponder handles the response to the RebootHostingEnvironment request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) RebootHostingEnvironmentResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusBadRequest, http.StatusNotFound, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ResumeHostingEnvironment sends the resume hosting environment request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) ResumeHostingEnvironment(ctx context.Context, resourceGroupName string, name string) (result HostingEnvironmentsResumeHostingEnvironmentFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.ResumeHostingEnvironment")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ResumeHostingEnvironmentPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "ResumeHostingEnvironment", nil, "Failure preparing request")
		return
	}

	result, err = client.ResumeHostingEnvironmentSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "ResumeHostingEnvironment", result.Response(), "Failure sending request")
		return
	}

	return
}

// ResumeHostingEnvironmentPreparer prepares the ResumeHostingEnvironment request.
func (client HostingEnvironmentsClient) ResumeHostingEnvironmentPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/resume", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ResumeHostingEnvironmentSender sends the ResumeHostingEnvironment request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) ResumeHostingEnvironmentSender(req *http.Request) (future HostingEnvironmentsResumeHostingEnvironmentFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// ResumeHostingEnvironmentResponder handles the response to the ResumeHostingEnvironment request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) ResumeHostingEnvironmentResponder(resp *http.Response) (result SiteCollectionPage, err error) {
	result.sc, err = client.resumeHostingEnvironmentResponder(resp)
	result.fn = client.resumeHostingEnvironmentNextResults
	return
}

func (client HostingEnvironmentsClient) resumeHostingEnvironmentResponder(resp *http.Response) (result SiteCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// resumeHostingEnvironmentNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) resumeHostingEnvironmentNextResults(ctx context.Context, lastResults SiteCollection) (result SiteCollection, err error) {
	req, err := lastResults.siteCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "resumeHostingEnvironmentNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "resumeHostingEnvironmentNextResults", resp, "Failure sending next results request")
	}
	return client.resumeHostingEnvironmentResponder(resp)
}

// ResumeHostingEnvironmentComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) ResumeHostingEnvironmentComplete(ctx context.Context, resourceGroupName string, name string) (result HostingEnvironmentsResumeHostingEnvironmentAllFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.ResumeHostingEnvironment")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	var future HostingEnvironmentsResumeHostingEnvironmentFuture
	future, err = client.ResumeHostingEnvironment(ctx, resourceGroupName, name)
	result.FutureAPI = future.FutureAPI
	return
}

// SuspendHostingEnvironment sends the suspend hosting environment request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of hostingEnvironment (App Service Environment)
func (client HostingEnvironmentsClient) SuspendHostingEnvironment(ctx context.Context, resourceGroupName string, name string) (result HostingEnvironmentsSuspendHostingEnvironmentFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.SuspendHostingEnvironment")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SuspendHostingEnvironmentPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "SuspendHostingEnvironment", nil, "Failure preparing request")
		return
	}

	result, err = client.SuspendHostingEnvironmentSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "SuspendHostingEnvironment", result.Response(), "Failure sending request")
		return
	}

	return
}

// SuspendHostingEnvironmentPreparer prepares the SuspendHostingEnvironment request.
func (client HostingEnvironmentsClient) SuspendHostingEnvironmentPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/suspend", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SuspendHostingEnvironmentSender sends the SuspendHostingEnvironment request. The method will close the
// http.Response Body if it receives an error.
func (client HostingEnvironmentsClient) SuspendHostingEnvironmentSender(req *http.Request) (future HostingEnvironmentsSuspendHostingEnvironmentFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// SuspendHostingEnvironmentResponder handles the response to the SuspendHostingEnvironment request. The method always
// closes the http.Response Body.
func (client HostingEnvironmentsClient) SuspendHostingEnvironmentResponder(resp *http.Response) (result SiteCollectionPage, err error) {
	result.sc, err = client.suspendHostingEnvironmentResponder(resp)
	result.fn = client.suspendHostingEnvironmentNextResults
	return
}

func (client HostingEnvironmentsClient) suspendHostingEnvironmentResponder(resp *http.Response) (result SiteCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// suspendHostingEnvironmentNextResults retrieves the next set of results, if any.
func (client HostingEnvironmentsClient) suspendHostingEnvironmentNextResults(ctx context.Context, lastResults SiteCollection) (result SiteCollection, err error) {
	req, err := lastResults.siteCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "suspendHostingEnvironmentNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	var resp *http.Response
	resp, err = client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.HostingEnvironmentsClient", "suspendHostingEnvironmentNextResults", resp, "Failure sending next results request")
	}
	return client.suspendHostingEnvironmentResponder(resp)
}

// SuspendHostingEnvironmentComplete enumerates all values, automatically crossing page boundaries as required.
func (client HostingEnvironmentsClient) SuspendHostingEnvironmentComplete(ctx context.Context, resourceGroupName string, name string) (result HostingEnvironmentsSuspendHostingEnvironmentAllFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostingEnvironmentsClient.SuspendHostingEnvironment")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	var future HostingEnvironmentsSuspendHostingEnvironmentFuture
	future, err = client.SuspendHostingEnvironment(ctx, resourceGroupName, name)
	result.FutureAPI = future.FutureAPI
	return
}
