package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBClusterConfig invokes the clickhouse.ModifyDBClusterConfig API synchronously
func (client *Client) ModifyDBClusterConfig(request *ModifyDBClusterConfigRequest) (response *ModifyDBClusterConfigResponse, err error) {
	response = CreateModifyDBClusterConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBClusterConfigWithChan invokes the clickhouse.ModifyDBClusterConfig API asynchronously
func (client *Client) ModifyDBClusterConfigWithChan(request *ModifyDBClusterConfigRequest) (<-chan *ModifyDBClusterConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyDBClusterConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBClusterConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBClusterConfigWithCallback invokes the clickhouse.ModifyDBClusterConfig API asynchronously
func (client *Client) ModifyDBClusterConfigWithCallback(request *ModifyDBClusterConfigRequest, callback func(response *ModifyDBClusterConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBClusterConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBClusterConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBClusterConfigRequest is the request struct for api ModifyDBClusterConfig
type ModifyDBClusterConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	UserConfig           string           `position:"Query" name:"UserConfig"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ModifyDBClusterConfigResponse is the response struct for api ModifyDBClusterConfig
type ModifyDBClusterConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDBClusterConfigRequest creates a request to invoke ModifyDBClusterConfig API
func CreateModifyDBClusterConfigRequest() (request *ModifyDBClusterConfigRequest) {
	request = &ModifyDBClusterConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "ModifyDBClusterConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyDBClusterConfigResponse creates a response to parse from ModifyDBClusterConfig response
func CreateModifyDBClusterConfigResponse() (response *ModifyDBClusterConfigResponse) {
	response = &ModifyDBClusterConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
