package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FindRecords invokes the cloudcallcenter.FindRecords API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/findrecords.html
func (client *Client) FindRecords(request *FindRecordsRequest) (response *FindRecordsResponse, err error) {
	response = CreateFindRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// FindRecordsWithChan invokes the cloudcallcenter.FindRecords API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/findrecords.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindRecordsWithChan(request *FindRecordsRequest) (<-chan *FindRecordsResponse, <-chan error) {
	responseChan := make(chan *FindRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FindRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FindRecordsWithCallback invokes the cloudcallcenter.FindRecords API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/findrecords.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindRecordsWithCallback(request *FindRecordsRequest, callback func(response *FindRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FindRecordsResponse
		var err error
		defer close(result)
		response, err = client.FindRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FindRecordsRequest is the request struct for api FindRecords
type FindRecordsRequest struct {
	*requests.RpcRequest
	Instance string `position:"Query" name:"Instance"`
	Query    string `position:"Query" name:"Query"`
}

// FindRecordsResponse is the response struct for api FindRecords
type FindRecordsResponse struct {
	*responses.BaseResponse
	RequestId      string  `json:"RequestId" xml:"RequestId"`
	Success        bool    `json:"Success" xml:"Success"`
	Code           string  `json:"Code" xml:"Code"`
	Message        string  `json:"Message" xml:"Message"`
	HttpStatusCode int     `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Records        Records `json:"Records" xml:"Records"`
}

// CreateFindRecordsRequest creates a request to invoke FindRecords API
func CreateFindRecordsRequest() (request *FindRecordsRequest) {
	request = &FindRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "FindRecords", "", "")
	request.Method = requests.POST
	return
}

// CreateFindRecordsResponse creates a response to parse from FindRecords response
func CreateFindRecordsResponse() (response *FindRecordsResponse) {
	response = &FindRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
