package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePositionMap invokes the cloudwf.DeletePositionMap API synchronously
// api document: https://help.aliyun.com/api/cloudwf/deletepositionmap.html
func (client *Client) DeletePositionMap(request *DeletePositionMapRequest) (response *DeletePositionMapResponse, err error) {
	response = CreateDeletePositionMapResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePositionMapWithChan invokes the cloudwf.DeletePositionMap API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/deletepositionmap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeletePositionMapWithChan(request *DeletePositionMapRequest) (<-chan *DeletePositionMapResponse, <-chan error) {
	responseChan := make(chan *DeletePositionMapResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePositionMap(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePositionMapWithCallback invokes the cloudwf.DeletePositionMap API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/deletepositionmap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeletePositionMapWithCallback(request *DeletePositionMapRequest, callback func(response *DeletePositionMapResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePositionMapResponse
		var err error
		defer close(result)
		response, err = client.DeletePositionMap(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePositionMapRequest is the request struct for api DeletePositionMap
type DeletePositionMapRequest struct {
	*requests.RpcRequest
	MapId requests.Integer `position:"Query" name:"MapId"`
}

// DeletePositionMapResponse is the response struct for api DeletePositionMap
type DeletePositionMapResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateDeletePositionMapRequest creates a request to invoke DeletePositionMap API
func CreateDeletePositionMapRequest() (request *DeletePositionMapRequest) {
	request = &DeletePositionMapRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "DeletePositionMap", "cloudwf", "openAPI")
	return
}

// CreateDeletePositionMapResponse creates a response to parse from DeletePositionMap response
func CreateDeletePositionMapResponse() (response *DeletePositionMapResponse) {
	response = &DeletePositionMapResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
