package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDiscoveredResource invokes the config.GetDiscoveredResource API synchronously
func (client *Client) GetDiscoveredResource(request *GetDiscoveredResourceRequest) (response *GetDiscoveredResourceResponse, err error) {
	response = CreateGetDiscoveredResourceResponse()
	err = client.DoAction(request, response)
	return
}

// GetDiscoveredResourceWithChan invokes the config.GetDiscoveredResource API asynchronously
func (client *Client) GetDiscoveredResourceWithChan(request *GetDiscoveredResourceRequest) (<-chan *GetDiscoveredResourceResponse, <-chan error) {
	responseChan := make(chan *GetDiscoveredResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDiscoveredResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDiscoveredResourceWithCallback invokes the config.GetDiscoveredResource API asynchronously
func (client *Client) GetDiscoveredResourceWithCallback(request *GetDiscoveredResourceRequest, callback func(response *GetDiscoveredResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDiscoveredResourceResponse
		var err error
		defer close(result)
		response, err = client.GetDiscoveredResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDiscoveredResourceRequest is the request struct for api GetDiscoveredResource
type GetDiscoveredResourceRequest struct {
	*requests.RpcRequest
	ResourceId   string `position:"Query" name:"ResourceId"`
	ResourceType string `position:"Query" name:"ResourceType"`
	Region       string `position:"Query" name:"Region"`
}

// GetDiscoveredResourceResponse is the response struct for api GetDiscoveredResource
type GetDiscoveredResourceResponse struct {
	*responses.BaseResponse
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	DiscoveredResourceDetail DiscoveredResourceDetail `json:"DiscoveredResourceDetail" xml:"DiscoveredResourceDetail"`
}

// CreateGetDiscoveredResourceRequest creates a request to invoke GetDiscoveredResource API
func CreateGetDiscoveredResourceRequest() (request *GetDiscoveredResourceRequest) {
	request = &GetDiscoveredResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetDiscoveredResource", "", "")
	request.Method = requests.GET
	return
}

// CreateGetDiscoveredResourceResponse creates a response to parse from GetDiscoveredResource response
func CreateGetDiscoveredResourceResponse() (response *GetDiscoveredResourceResponse) {
	response = &GetDiscoveredResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
