package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGWSCluster invokes the ehpc.DeleteGWSCluster API synchronously
func (client *Client) DeleteGWSCluster(request *DeleteGWSClusterRequest) (response *DeleteGWSClusterResponse, err error) {
	response = CreateDeleteGWSClusterResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGWSClusterWithChan invokes the ehpc.DeleteGWSCluster API asynchronously
func (client *Client) DeleteGWSClusterWithChan(request *DeleteGWSClusterRequest) (<-chan *DeleteGWSClusterResponse, <-chan error) {
	responseChan := make(chan *DeleteGWSClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGWSCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGWSClusterWithCallback invokes the ehpc.DeleteGWSCluster API asynchronously
func (client *Client) DeleteGWSClusterWithCallback(request *DeleteGWSClusterRequest, callback func(response *DeleteGWSClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGWSClusterResponse
		var err error
		defer close(result)
		response, err = client.DeleteGWSCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGWSClusterRequest is the request struct for api DeleteGWSCluster
type DeleteGWSClusterRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DeleteGWSClusterResponse is the response struct for api DeleteGWSCluster
type DeleteGWSClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteGWSClusterRequest creates a request to invoke DeleteGWSCluster API
func CreateDeleteGWSClusterRequest() (request *DeleteGWSClusterRequest) {
	request = &DeleteGWSClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "DeleteGWSCluster", "", "")
	request.Method = requests.GET
	return
}

// CreateDeleteGWSClusterResponse creates a response to parse from DeleteGWSCluster response
func CreateDeleteGWSClusterResponse() (response *DeleteGWSClusterResponse) {
	response = &DeleteGWSClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
