package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDiagnoseReportIds invokes the elasticsearch.ListDiagnoseReportIds API synchronously
func (client *Client) ListDiagnoseReportIds(request *ListDiagnoseReportIdsRequest) (response *ListDiagnoseReportIdsResponse, err error) {
	response = CreateListDiagnoseReportIdsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDiagnoseReportIdsWithChan invokes the elasticsearch.ListDiagnoseReportIds API asynchronously
func (client *Client) ListDiagnoseReportIdsWithChan(request *ListDiagnoseReportIdsRequest) (<-chan *ListDiagnoseReportIdsResponse, <-chan error) {
	responseChan := make(chan *ListDiagnoseReportIdsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDiagnoseReportIds(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDiagnoseReportIdsWithCallback invokes the elasticsearch.ListDiagnoseReportIds API asynchronously
func (client *Client) ListDiagnoseReportIdsWithCallback(request *ListDiagnoseReportIdsRequest, callback func(response *ListDiagnoseReportIdsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDiagnoseReportIdsResponse
		var err error
		defer close(result)
		response, err = client.ListDiagnoseReportIds(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDiagnoseReportIdsRequest is the request struct for api ListDiagnoseReportIds
type ListDiagnoseReportIdsRequest struct {
	*requests.RoaRequest
	InstanceId string           `position:"Path" name:"InstanceId"`
	Size       requests.Integer `position:"Query" name:"size"`
	EndTime    requests.Integer `position:"Query" name:"endTime"`
	StartTime  requests.Integer `position:"Query" name:"startTime"`
	Page       requests.Integer `position:"Query" name:"page"`
	Trigger    string           `position:"Query" name:"trigger"`
	Lang       string           `position:"Query" name:"lang"`
}

// ListDiagnoseReportIdsResponse is the response struct for api ListDiagnoseReportIds
type ListDiagnoseReportIdsResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Result    []string `json:"Result" xml:"Result"`
	Headers   Headers  `json:"Headers" xml:"Headers"`
}

// CreateListDiagnoseReportIdsRequest creates a request to invoke ListDiagnoseReportIds API
func CreateListDiagnoseReportIdsRequest() (request *ListDiagnoseReportIdsRequest) {
	request = &ListDiagnoseReportIdsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListDiagnoseReportIds", "/openapi/diagnosis/instances/[InstanceId]/report-ids", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListDiagnoseReportIdsResponse creates a response to parse from ListDiagnoseReportIds response
func CreateListDiagnoseReportIdsResponse() (response *ListDiagnoseReportIdsResponse) {
	response = &ListDiagnoseReportIdsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
