package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchGetEdgeInstanceDeviceDriver invokes the iot.BatchGetEdgeInstanceDeviceDriver API synchronously
func (client *Client) BatchGetEdgeInstanceDeviceDriver(request *BatchGetEdgeInstanceDeviceDriverRequest) (response *BatchGetEdgeInstanceDeviceDriverResponse, err error) {
	response = CreateBatchGetEdgeInstanceDeviceDriverResponse()
	err = client.DoAction(request, response)
	return
}

// BatchGetEdgeInstanceDeviceDriverWithChan invokes the iot.BatchGetEdgeInstanceDeviceDriver API asynchronously
func (client *Client) BatchGetEdgeInstanceDeviceDriverWithChan(request *BatchGetEdgeInstanceDeviceDriverRequest) (<-chan *BatchGetEdgeInstanceDeviceDriverResponse, <-chan error) {
	responseChan := make(chan *BatchGetEdgeInstanceDeviceDriverResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchGetEdgeInstanceDeviceDriver(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchGetEdgeInstanceDeviceDriverWithCallback invokes the iot.BatchGetEdgeInstanceDeviceDriver API asynchronously
func (client *Client) BatchGetEdgeInstanceDeviceDriverWithCallback(request *BatchGetEdgeInstanceDeviceDriverRequest, callback func(response *BatchGetEdgeInstanceDeviceDriverResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchGetEdgeInstanceDeviceDriverResponse
		var err error
		defer close(result)
		response, err = client.BatchGetEdgeInstanceDeviceDriver(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchGetEdgeInstanceDeviceDriverRequest is the request struct for api BatchGetEdgeInstanceDeviceDriver
type BatchGetEdgeInstanceDeviceDriverRequest struct {
	*requests.RpcRequest
	IotIds        *[]string `position:"Query" name:"IotIds"  type:"Repeated"`
	IotInstanceId string    `position:"Query" name:"IotInstanceId"`
	InstanceId    string    `position:"Query" name:"InstanceId"`
	ApiProduct    string    `position:"Body" name:"ApiProduct"`
	ApiRevision   string    `position:"Body" name:"ApiRevision"`
}

// BatchGetEdgeInstanceDeviceDriverResponse is the response struct for api BatchGetEdgeInstanceDeviceDriver
type BatchGetEdgeInstanceDeviceDriverResponse struct {
	*responses.BaseResponse
	RequestId        string         `json:"RequestId" xml:"RequestId"`
	Success          bool           `json:"Success" xml:"Success"`
	Code             string         `json:"Code" xml:"Code"`
	ErrorMessage     string         `json:"ErrorMessage" xml:"ErrorMessage"`
	DeviceDriverList []DeviceDriver `json:"DeviceDriverList" xml:"DeviceDriverList"`
}

// CreateBatchGetEdgeInstanceDeviceDriverRequest creates a request to invoke BatchGetEdgeInstanceDeviceDriver API
func CreateBatchGetEdgeInstanceDeviceDriverRequest() (request *BatchGetEdgeInstanceDeviceDriverRequest) {
	request = &BatchGetEdgeInstanceDeviceDriverRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchGetEdgeInstanceDeviceDriver", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchGetEdgeInstanceDeviceDriverResponse creates a response to parse from BatchGetEdgeInstanceDeviceDriver response
func CreateBatchGetEdgeInstanceDeviceDriverResponse() (response *BatchGetEdgeInstanceDeviceDriverResponse) {
	response = &BatchGetEdgeInstanceDeviceDriverResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
