package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRotationPolicy invokes the kms.UpdateRotationPolicy API synchronously
func (client *Client) UpdateRotationPolicy(request *UpdateRotationPolicyRequest) (response *UpdateRotationPolicyResponse, err error) {
	response = CreateUpdateRotationPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRotationPolicyWithChan invokes the kms.UpdateRotationPolicy API asynchronously
func (client *Client) UpdateRotationPolicyWithChan(request *UpdateRotationPolicyRequest) (<-chan *UpdateRotationPolicyResponse, <-chan error) {
	responseChan := make(chan *UpdateRotationPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRotationPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRotationPolicyWithCallback invokes the kms.UpdateRotationPolicy API asynchronously
func (client *Client) UpdateRotationPolicyWithCallback(request *UpdateRotationPolicyRequest, callback func(response *UpdateRotationPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRotationPolicyResponse
		var err error
		defer close(result)
		response, err = client.UpdateRotationPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRotationPolicyRequest is the request struct for api UpdateRotationPolicy
type UpdateRotationPolicyRequest struct {
	*requests.RpcRequest
	KeyId                   string           `position:"Query" name:"KeyId"`
	RotationInterval        string           `position:"Query" name:"RotationInterval"`
	EnableAutomaticRotation requests.Boolean `position:"Query" name:"EnableAutomaticRotation"`
}

// UpdateRotationPolicyResponse is the response struct for api UpdateRotationPolicy
type UpdateRotationPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateRotationPolicyRequest creates a request to invoke UpdateRotationPolicy API
func CreateUpdateRotationPolicyRequest() (request *UpdateRotationPolicyRequest) {
	request = &UpdateRotationPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "UpdateRotationPolicy", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateRotationPolicyResponse creates a response to parse from UpdateRotationPolicy response
func CreateUpdateRotationPolicyResponse() (response *UpdateRotationPolicyResponse) {
	response = &UpdateRotationPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
