package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNumberDistrictInfoTemplateDownloadUrl invokes the outboundbot.GetNumberDistrictInfoTemplateDownloadUrl API synchronously
func (client *Client) GetNumberDistrictInfoTemplateDownloadUrl(request *GetNumberDistrictInfoTemplateDownloadUrlRequest) (response *GetNumberDistrictInfoTemplateDownloadUrlResponse, err error) {
	response = CreateGetNumberDistrictInfoTemplateDownloadUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetNumberDistrictInfoTemplateDownloadUrlWithChan invokes the outboundbot.GetNumberDistrictInfoTemplateDownloadUrl API asynchronously
func (client *Client) GetNumberDistrictInfoTemplateDownloadUrlWithChan(request *GetNumberDistrictInfoTemplateDownloadUrlRequest) (<-chan *GetNumberDistrictInfoTemplateDownloadUrlResponse, <-chan error) {
	responseChan := make(chan *GetNumberDistrictInfoTemplateDownloadUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNumberDistrictInfoTemplateDownloadUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNumberDistrictInfoTemplateDownloadUrlWithCallback invokes the outboundbot.GetNumberDistrictInfoTemplateDownloadUrl API asynchronously
func (client *Client) GetNumberDistrictInfoTemplateDownloadUrlWithCallback(request *GetNumberDistrictInfoTemplateDownloadUrlRequest, callback func(response *GetNumberDistrictInfoTemplateDownloadUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNumberDistrictInfoTemplateDownloadUrlResponse
		var err error
		defer close(result)
		response, err = client.GetNumberDistrictInfoTemplateDownloadUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNumberDistrictInfoTemplateDownloadUrlRequest is the request struct for api GetNumberDistrictInfoTemplateDownloadUrl
type GetNumberDistrictInfoTemplateDownloadUrlRequest struct {
	*requests.RpcRequest
}

// GetNumberDistrictInfoTemplateDownloadUrlResponse is the response struct for api GetNumberDistrictInfoTemplateDownloadUrl
type GetNumberDistrictInfoTemplateDownloadUrlResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	FileHttpUrl    string `json:"FileHttpUrl" xml:"FileHttpUrl"`
}

// CreateGetNumberDistrictInfoTemplateDownloadUrlRequest creates a request to invoke GetNumberDistrictInfoTemplateDownloadUrl API
func CreateGetNumberDistrictInfoTemplateDownloadUrlRequest() (request *GetNumberDistrictInfoTemplateDownloadUrlRequest) {
	request = &GetNumberDistrictInfoTemplateDownloadUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "GetNumberDistrictInfoTemplateDownloadUrl", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetNumberDistrictInfoTemplateDownloadUrlResponse creates a response to parse from GetNumberDistrictInfoTemplateDownloadUrl response
func CreateGetNumberDistrictInfoTemplateDownloadUrlResponse() (response *GetNumberDistrictInfoTemplateDownloadUrlResponse) {
	response = &GetNumberDistrictInfoTemplateDownloadUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
