package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartScene invokes the pts.StartScene API synchronously
// api document: https://help.aliyun.com/api/pts/startscene.html
func (client *Client) StartScene(request *StartSceneRequest) (response *StartSceneResponse, err error) {
	response = CreateStartSceneResponse()
	err = client.DoAction(request, response)
	return
}

// StartSceneWithChan invokes the pts.StartScene API asynchronously
// api document: https://help.aliyun.com/api/pts/startscene.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartSceneWithChan(request *StartSceneRequest) (<-chan *StartSceneResponse, <-chan error) {
	responseChan := make(chan *StartSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartSceneWithCallback invokes the pts.StartScene API asynchronously
// api document: https://help.aliyun.com/api/pts/startscene.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartSceneWithCallback(request *StartSceneRequest, callback func(response *StartSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartSceneResponse
		var err error
		defer close(result)
		response, err = client.StartScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartSceneRequest is the request struct for api StartScene
type StartSceneRequest struct {
	*requests.RpcRequest
	SceneId requests.Integer `position:"Query" name:"SceneId"`
}

// StartSceneResponse is the response struct for api StartScene
type StartSceneResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	ReportId  int64  `json:"ReportId" xml:"ReportId"`
}

// CreateStartSceneRequest creates a request to invoke StartScene API
func CreateStartSceneRequest() (request *StartSceneRequest) {
	request = &StartSceneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2018-11-11", "StartScene", "1.0.0", "openAPI")
	return
}

// CreateStartSceneResponse creates a response to parse from StartScene response
func CreateStartSceneResponse() (response *StartSceneResponse) {
	response = &StartSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
