package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRouteDistributionStrategy invokes the smartag.DeleteRouteDistributionStrategy API synchronously
func (client *Client) DeleteRouteDistributionStrategy(request *DeleteRouteDistributionStrategyRequest) (response *DeleteRouteDistributionStrategyResponse, err error) {
	response = CreateDeleteRouteDistributionStrategyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRouteDistributionStrategyWithChan invokes the smartag.DeleteRouteDistributionStrategy API asynchronously
func (client *Client) DeleteRouteDistributionStrategyWithChan(request *DeleteRouteDistributionStrategyRequest) (<-chan *DeleteRouteDistributionStrategyResponse, <-chan error) {
	responseChan := make(chan *DeleteRouteDistributionStrategyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRouteDistributionStrategy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRouteDistributionStrategyWithCallback invokes the smartag.DeleteRouteDistributionStrategy API asynchronously
func (client *Client) DeleteRouteDistributionStrategyWithCallback(request *DeleteRouteDistributionStrategyRequest, callback func(response *DeleteRouteDistributionStrategyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRouteDistributionStrategyResponse
		var err error
		defer close(result)
		response, err = client.DeleteRouteDistributionStrategy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRouteDistributionStrategyRequest is the request struct for api DeleteRouteDistributionStrategy
type DeleteRouteDistributionStrategyRequest struct {
	*requests.RpcRequest
	RouteSource          string           `position:"Query" name:"RouteSource"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SourceType           string           `position:"Query" name:"SourceType"`
	DestCidrBlock        string           `position:"Query" name:"DestCidrBlock"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// DeleteRouteDistributionStrategyResponse is the response struct for api DeleteRouteDistributionStrategy
type DeleteRouteDistributionStrategyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteRouteDistributionStrategyRequest creates a request to invoke DeleteRouteDistributionStrategy API
func CreateDeleteRouteDistributionStrategyRequest() (request *DeleteRouteDistributionStrategyRequest) {
	request = &DeleteRouteDistributionStrategyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DeleteRouteDistributionStrategy", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteRouteDistributionStrategyResponse creates a response to parse from DeleteRouteDistributionStrategy response
func CreateDeleteRouteDistributionStrategyResponse() (response *DeleteRouteDistributionStrategyResponse) {
	response = &DeleteRouteDistributionStrategyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
