package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHealthCheckAttribute invokes the smartag.DescribeHealthCheckAttribute API synchronously
func (client *Client) DescribeHealthCheckAttribute(request *DescribeHealthCheckAttributeRequest) (response *DescribeHealthCheckAttributeResponse, err error) {
	response = CreateDescribeHealthCheckAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHealthCheckAttributeWithChan invokes the smartag.DescribeHealthCheckAttribute API asynchronously
func (client *Client) DescribeHealthCheckAttributeWithChan(request *DescribeHealthCheckAttributeRequest) (<-chan *DescribeHealthCheckAttributeResponse, <-chan error) {
	responseChan := make(chan *DescribeHealthCheckAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHealthCheckAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHealthCheckAttributeWithCallback invokes the smartag.DescribeHealthCheckAttribute API asynchronously
func (client *Client) DescribeHealthCheckAttributeWithCallback(request *DescribeHealthCheckAttributeRequest, callback func(response *DescribeHealthCheckAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHealthCheckAttributeResponse
		var err error
		defer close(result)
		response, err = client.DescribeHealthCheckAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHealthCheckAttributeRequest is the request struct for api DescribeHealthCheckAttribute
type DescribeHealthCheckAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HcInstanceId         string           `position:"Query" name:"HcInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// DescribeHealthCheckAttributeResponse is the response struct for api DescribeHealthCheckAttribute
type DescribeHealthCheckAttributeResponse struct {
	*responses.BaseResponse
	SrcPort            int    `json:"SrcPort" xml:"SrcPort"`
	Description        string `json:"Description" xml:"Description"`
	RequestId          string `json:"RequestId" xml:"RequestId"`
	SrcIpAddr          string `json:"SrcIpAddr" xml:"SrcIpAddr"`
	CreateTime         int64  `json:"CreateTime" xml:"CreateTime"`
	FailCountThreshold int    `json:"FailCountThreshold" xml:"FailCountThreshold"`
	DstPort            int    `json:"DstPort" xml:"DstPort"`
	Name               string `json:"Name" xml:"Name"`
	ProbeCount         int    `json:"ProbeCount" xml:"ProbeCount"`
	Type               string `json:"Type" xml:"Type"`
	ProbeTimeout       int    `json:"ProbeTimeout" xml:"ProbeTimeout"`
	HcInstanceId       string `json:"HcInstanceId" xml:"HcInstanceId"`
	RttThreshold       int    `json:"RttThreshold" xml:"RttThreshold"`
	ProbeInterval      int    `json:"ProbeInterval" xml:"ProbeInterval"`
	SmartAGId          string `json:"SmartAGId" xml:"SmartAGId"`
	RttFailThreshold   int    `json:"RttFailThreshold" xml:"RttFailThreshold"`
	DstIpAddr          string `json:"DstIpAddr" xml:"DstIpAddr"`
}

// CreateDescribeHealthCheckAttributeRequest creates a request to invoke DescribeHealthCheckAttribute API
func CreateDescribeHealthCheckAttributeRequest() (request *DescribeHealthCheckAttributeRequest) {
	request = &DescribeHealthCheckAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeHealthCheckAttribute", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeHealthCheckAttributeResponse creates a response to parse from DescribeHealthCheckAttribute response
func CreateDescribeHealthCheckAttributeResponse() (response *DescribeHealthCheckAttributeResponse) {
	response = &DescribeHealthCheckAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
