package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFaceOptions invokes the vcs.GetFaceOptions API synchronously
func (client *Client) GetFaceOptions(request *GetFaceOptionsRequest) (response *GetFaceOptionsResponse, err error) {
	response = CreateGetFaceOptionsResponse()
	err = client.DoAction(request, response)
	return
}

// GetFaceOptionsWithChan invokes the vcs.GetFaceOptions API asynchronously
func (client *Client) GetFaceOptionsWithChan(request *GetFaceOptionsRequest) (<-chan *GetFaceOptionsResponse, <-chan error) {
	responseChan := make(chan *GetFaceOptionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFaceOptions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFaceOptionsWithCallback invokes the vcs.GetFaceOptions API asynchronously
func (client *Client) GetFaceOptionsWithCallback(request *GetFaceOptionsRequest, callback func(response *GetFaceOptionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFaceOptionsResponse
		var err error
		defer close(result)
		response, err = client.GetFaceOptions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFaceOptionsRequest is the request struct for api GetFaceOptions
type GetFaceOptionsRequest struct {
	*requests.RpcRequest
	CorpId string `position:"Body" name:"CorpId"`
}

// GetFaceOptionsResponse is the response struct for api GetFaceOptions
type GetFaceOptionsResponse struct {
	*responses.BaseResponse
	Code      string     `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetFaceOptionsRequest creates a request to invoke GetFaceOptions API
func CreateGetFaceOptionsRequest() (request *GetFaceOptionsRequest) {
	request = &GetFaceOptionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "GetFaceOptions", "", "")
	request.Method = requests.POST
	return
}

// CreateGetFaceOptionsResponse creates a response to parse from GetFaceOptions response
func CreateGetFaceOptionsResponse() (response *GetFaceOptionsResponse) {
	response = &GetFaceOptionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
