package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVpcGatewayEndpoint invokes the vpc.DeleteVpcGatewayEndpoint API synchronously
func (client *Client) DeleteVpcGatewayEndpoint(request *DeleteVpcGatewayEndpointRequest) (response *DeleteVpcGatewayEndpointResponse, err error) {
	response = CreateDeleteVpcGatewayEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVpcGatewayEndpointWithChan invokes the vpc.DeleteVpcGatewayEndpoint API asynchronously
func (client *Client) DeleteVpcGatewayEndpointWithChan(request *DeleteVpcGatewayEndpointRequest) (<-chan *DeleteVpcGatewayEndpointResponse, <-chan error) {
	responseChan := make(chan *DeleteVpcGatewayEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVpcGatewayEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVpcGatewayEndpointWithCallback invokes the vpc.DeleteVpcGatewayEndpoint API asynchronously
func (client *Client) DeleteVpcGatewayEndpointWithCallback(request *DeleteVpcGatewayEndpointRequest, callback func(response *DeleteVpcGatewayEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVpcGatewayEndpointResponse
		var err error
		defer close(result)
		response, err = client.DeleteVpcGatewayEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVpcGatewayEndpointRequest is the request struct for api DeleteVpcGatewayEndpoint
type DeleteVpcGatewayEndpointRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	EndpointId           string           `position:"Query" name:"EndpointId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteVpcGatewayEndpointResponse is the response struct for api DeleteVpcGatewayEndpoint
type DeleteVpcGatewayEndpointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVpcGatewayEndpointRequest creates a request to invoke DeleteVpcGatewayEndpoint API
func CreateDeleteVpcGatewayEndpointRequest() (request *DeleteVpcGatewayEndpointRequest) {
	request = &DeleteVpcGatewayEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteVpcGatewayEndpoint", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteVpcGatewayEndpointResponse creates a response to parse from DeleteVpcGatewayEndpoint response
func CreateDeleteVpcGatewayEndpointResponse() (response *DeleteVpcGatewayEndpointResponse) {
	response = &DeleteVpcGatewayEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
